/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.message.action;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.Validate;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntryLite;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MessageLogEntryBean implements Serializable {
    
    private static final long serialVersionUID = 8112568008455978936L;
    
    private static Map messageTypeCapabilityMap = new HashMap ();
    
    static {    	    	
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORFZ11_TO_SITE.getName(),Capability.RE_TRANSMIT_Z11.getName());
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORUZ11_TO_SITE.getName(),Capability.RE_TRANSMIT_Z11.getName());
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORUZ05_TO_SITE.getName(),Capability.RE_TRANSMIT_Z05.getName());
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORUZ04_TO_SITE.getName(),Capability.RE_TRANSMIT_Z04.getName());
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORFZ10_TO_SITE.getName(),Capability.RE_TRANSMIT_Z10.getName());
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORUZ10_TO_SITE.getName(),Capability.RE_TRANSMIT_Z10.getName());
    	messageTypeCapabilityMap.put(
    			MessageType.CODE_ORUZ06_TO_SITE.getName(),Capability.RE_TRANSMIT_Z06.getName());
    }
    
    private MessageLogEntryLite messageLogEntryLite = null;
    
    MessageLogEntryBean(MessageLogEntryLite messageLogEntryLite)
    {
        Validate.notNull(messageLogEntryLite, "A MessageLogEntryLite must not be null");
        this.messageLogEntryLite = messageLogEntryLite;
    }
    
    public String getMessageLogEntryId() {
        return messageLogEntryLite.getEntityKey().getKeyValueAsString();
    }
    
    public Date getTransmissionDate() {
        return messageLogEntryLite.getTransmissionDate();
    }
    
    public MessageStatus getStatus() {
        return messageLogEntryLite.getStatus();
    }
    
    public MessageType getType() {
        return messageLogEntryLite.getType();
    }
    
    public String getMessageTypeString() {
        return (messageLogEntryLite.getType() != null) ? messageLogEntryLite.getType().getCode() + ":" + messageLogEntryLite.getType().getDescription() : "";
    }
    
    public VAFacility getFacility() {
        return messageLogEntryLite.getVaFacility();
    }
    
    public String getFacilityString() {
        return (messageLogEntryLite.getVaFacility() != null) ? messageLogEntryLite.getVaFacility().getDescription() + " (#" + messageLogEntryLite.getVaFacility().getStationNumber() + ")" : "";
    }
    
    public boolean isTransmittableMessageType() {
        String msgType = (messageLogEntryLite.getType() != null) ? messageLogEntryLite.getType().getCode() : "";
        if (MessageType.CODE_ORFZ11_TO_SITE.getName().equals(msgType) || 
            MessageType.CODE_ORUZ11_TO_SITE.getName().equals(msgType) ||
            MessageType.CODE_ORUZ05_TO_SITE.getName().equals(msgType) ||
            MessageType.CODE_ORUZ04_TO_SITE.getName().equals(msgType) ||
            MessageType.CODE_ORFZ10_TO_SITE.getName().equals(msgType) || 
            MessageType.CODE_ORUZ10_TO_SITE.getName().equals(msgType) ||
            MessageType.CODE_ORUZ06_TO_SITE.getName().equals(msgType)) {
            return true;
        }
        return false;
    }
    public String getRetransmitPermissionCode() {
    	return  (messageLogEntryLite.getType() == null ? "" : (String)messageTypeCapabilityMap.get(messageLogEntryLite.getType().getCode()));
    }
    public boolean isError() {
        return (messageLogEntryLite.getStatus() != null && messageLogEntryLite.getStatus().getCode().equals(MessageStatus.ERROR.getName())) ? true : false;
    }
}
