/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java classes
import java.math.BigDecimal;
import java.util.*;

// Framework classes
import gov.va.med.fw.ui.struts.AbstractForm;

// ESR classes
import gov.va.med.esr.common.model.financials.GMTThreshold;
import gov.va.med.esr.common.model.financials.IncomeThreshold;

/**
 * This is the struts action form for the financials overview screen.
 *
 * @author Priya
 */
public class ThresholdForm extends AbstractForm
{
	private static final long serialVersionUID = 2744958694883432566L;
    
    private String incomeYear;
	private String zipCode;
	private String state;
	private String city;
	private String county;
	private String FIPSCode;
	
	private String additionalDependent;
	private BigDecimal addDepGMTThreshold;
	private BigDecimal addDepMTThreshold;
	private BigDecimal addDepPensionThreshold;
	private BigDecimal addDepMedicalDeductible;
	
	private List GMTThreshold = new ArrayList();
	private List MTThreshold = new ArrayList();
	private List pensionThreshold = new ArrayList();
	private List medicalDeductible = new ArrayList();
		
	private GMTThreshold gmtThreshold;
	private IncomeThreshold incomeThreshold;
	
	/**
	 * @return Returns the additionalDependent.
	 */
	public String getAdditionalDependent() {
		return additionalDependent;
	}
	/**
	 * @param additionalDependent The additionalDependent to set.
	 */
	public void setAdditionalDependent(String additionalDependent) {
		this.additionalDependent = additionalDependent;
	}
	/**
	 * @return Returns the city.
	 */
	public String getCity() {
		return city;
	}
	/**
	 * @param city The city to set.
	 */
	public void setCity(String city) {
		this.city = city;
	}
	/**
	 * @return Returns the county.
	 */
	public String getCounty() {
		return county;
	}
	/**
	 * @param county The county to set.
	 */
	public void setCounty(String county) {
		this.county = county;
	}
	/**
	 * @return Returns the fIPSCode.
	 */
	public String getFIPSCode() {
		return FIPSCode;
	}
	/**
	 * @param code The fIPSCode to set.
	 */
	public void setFIPSCode(String code) {
		FIPSCode = code;
	}
	/**
	 * @return Returns the gmtThreshold.
	 */
	public GMTThreshold getGmtThreshold() {
		return gmtThreshold;
	}
	/**
	 * @param gmtThreshold The gmtThreshold to set.
	 */
	public void setGmtThreshold(GMTThreshold gmtThreshold) {
		this.gmtThreshold = gmtThreshold;
	}
	/**
	 * @return Returns the incomeThreshold.
	 */
	public IncomeThreshold getIncomeThreshold() {
		return incomeThreshold;
	}
	/**
	 * @param incomeThreshold The incomeThreshold to set.
	 */
	public void setIncomeThreshold(IncomeThreshold incomeThreshold) {
		this.incomeThreshold = incomeThreshold;
	}
	/**
	 * @return Returns the incomeYear.
	 */
	public String getIncomeYear() {
/*		if(incomeYear == null)
		{
			int year = Calendar.getInstance().get(Calendar.YEAR) - 1;
			incomeYear = Integer.toString(year);
		}
*/		return incomeYear;
	}
	/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(String incomeYear) {
		this.incomeYear = incomeYear;
	}
	/**
	 * @return Returns the state.
	 */
	public String getState() {
		return state;
	}
	/**
	 * @param state The state to set.
	 */
	public void setState(String state) {
		this.state = state;
	}
	/**
	 * @return Returns the zipCode.
	 */
	public String getZipCode() {
		return zipCode;
	}
	/**
	 * @param zipCode The zipCode to set.
	 */
	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}
	/**
	 * @return Returns the addDepGMTThreshold.
	 */
	public BigDecimal getAddDepGMTThreshold() {
		return addDepGMTThreshold;
	}
	/**
	 * @param addDepGMTThreshold The addDepGMTThreshold to set.
	 */
	public void setAddDepGMTThreshold(BigDecimal addDepGMTThreshold) {
		this.addDepGMTThreshold = addDepGMTThreshold;
	}
	/**
	 * @return Returns the addDepMedicalDeductible.
	 */
	public BigDecimal getAddDepMedicalDeductible() {
		return addDepMedicalDeductible;
	}
	/**
	 * @param addDepMedicalDeductible The addDepMedicalDeductible to set.
	 */
	public void setAddDepMedicalDeductible(BigDecimal addDepMedicalDeductible) {
		this.addDepMedicalDeductible = addDepMedicalDeductible;
	}
	/**
	 * @return Returns the addDepMTThreshold.
	 */
	public BigDecimal getAddDepMTThreshold() {
		return addDepMTThreshold;
	}
	/**
	 * @param addDepMTThreshold The addDepMTThreshold to set.
	 */
	public void setAddDepMTThreshold(BigDecimal addDepMTThreshold) {
		this.addDepMTThreshold = addDepMTThreshold;
	}
	/**
	 * @return Returns the addDepPensionThreshold.
	 */
	public BigDecimal getAddDepPensionThreshold() {
		return addDepPensionThreshold;
	}
	/**
	 * @param addDepPensionThreshold The addDepPensionThreshold to set.
	 */
	public void setAddDepPensionThreshold(BigDecimal addDepPensionThreshold) {
		this.addDepPensionThreshold = addDepPensionThreshold;
	}
	/**
	 * @return Returns the gMTThreshold.
	 */
	public List getGMTThreshold() {
		return GMTThreshold;
	}
	/**
	 * @param threshold The gMTThreshold to set.
	 */
	public void setGMTThreshold(List threshold) {
		GMTThreshold = threshold;
	}
	
	public void addGMTThresholdValue(BigDecimal threshold) {
		this.GMTThreshold.add(threshold);
	}
	/**
	 * @return Returns the medicalDeductible.
	 */
	public List getMedicalDeductible() {
		return medicalDeductible;
	}
	/**
	 * @param medicalDeductible The medicalDeductible to set.
	 */
	public void setMedicalDeductible(List medicalDeductible) {
		this.medicalDeductible = medicalDeductible;
	}
	
	public void addMedicalDeductibleValue(BigDecimal medicalDeductible) {
		this.medicalDeductible.add(medicalDeductible);
	}
	/**
	 * @return Returns the mTThreshold.
	 */
	public List getMTThreshold() {
		return MTThreshold;
	}
	/**
	 * @param threshold The mTThreshold to set.
	 */
	public void setMTThreshold(List threshold) {
		MTThreshold = threshold;
	}
	
	public void addMTThresholdValue(BigDecimal threshold) {
		this.MTThreshold.add(threshold);
	}
	
	/**
	 * @return Returns the pensionThreshold.
	 */
	public List getPensionThreshold() {
		return pensionThreshold;
	}
	/**
	 * @param pensionThreshold The pensionThreshold to set.
	 */
	public void setPensionThreshold(List pensionThreshold) {
		this.pensionThreshold = pensionThreshold;
	}
	
	public void addPensionThresholdValue(BigDecimal pensionThreshold) {
		this.pensionThreshold.add(pensionThreshold);
	}
	
	public void clearLists()
	{
		GMTThreshold = new ArrayList();
		MTThreshold = new ArrayList();
		pensionThreshold = new ArrayList();
		medicalDeductible = new ArrayList();
	}
	
}