package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;

import java.util.List;

/**
 * @author DNS   barryc
 */
public class RelaxationPercentageUpdateForm extends RelaxationPercentageAddForm {
	private static final long serialVersionUID = -4036869175404488171L;

	// --------------------------------- Fields

	private int incomeYear;

	private List allRelaxationPercentages;

	/**
	 * Whether to additionally run the retroactive process after updating the
	 * current year's value
	 */
	private boolean retroactiveProcess;

	// --------------------------------- Business Methods

	public boolean isNextIncomeYearDefined() {
		if (allRelaxationPercentages == null)
			return false;
		for (int i = 0; i < allRelaxationPercentages.size(); i++)
			if (((RelaxationPercentage) allRelaxationPercentages.get(i))
					.getIncomeYear() == getCurrentIncomeYear() + 1)
				return true;
		return false;
	}

	// --------------------------------- Accessor Methods

	public int getIncomeYear() {
		return incomeYear;
	}

	public void setIncomeYear(int incomeYear) {
		this.incomeYear = incomeYear;
	}

	public boolean isRetroactiveProcess() {
		return retroactiveProcess;
	}

	public void setRetroactiveProcess(boolean retroactiveProcess) {
		this.retroactiveProcess = retroactiveProcess;
	}

	public List getAllRelaxationPercentages() {
		return allRelaxationPercentages;
	}

	public void setAllRelaxationPercentages(List allRelaxationPercentages) {
		this.allRelaxationPercentages = allRelaxationPercentages;
	}

}
