/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java Classes

// Framework Classes
import java.math.BigDecimal;
import java.util.Date;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.esr.common.model.financials.IncomeTest;

// ESR Classes

/**
 * This is the form used in conjunction with the Financials Dependent Overview page.
 * 
 * @author Priya R.
 * @version 3.0
 */
public class FinancialsReviewImpactForm extends AbstractForm
{
	private static final long serialVersionUID = 1000642747068769408L;

    private String incomeYear;
	
	//current status
	private Person person;
	private IncomeTest incomeTest;
	
	private String primaryTestType = null;
    private String testStatus = null;
    private String testDeterminedStatus = null;
	private String testEffDate = null;
	private Date centralizedAnnDate = null;
	private BigDecimal totalIncome = null;
	private BigDecimal totalDeductibleExp = null;
	private BigDecimal networth = null;
	private BigDecimal totalIncomePlusNetworth = null;
	private String noOfDependents = null;
	private BigDecimal meansTestThreshold = null;
	private BigDecimal gmtThreshold = null;
	private BigDecimal networthThreshold = null;
	private BigDecimal basicPensionThreshold = null;
	private BigDecimal childIncomeExclusion = null;
	private BigDecimal aidnAttendance = null;
	private String editedBy = null;
	private Date editedDate = null;

	//proposed status
	private Person assesedPerson;
	private IncomeTest incomeTestProposed;
	
	private String primaryTestTypeProposed = null;
    private String testStatusProposed = null;
    private String testDeterminedStatusProposed = null;
	private String testEffDateProposed = null;
	private Date centralizedAnnDateProposed = null;
	private BigDecimal totalIncomeProposed = null;
	private BigDecimal totalDeductibleExpProposed = null;
	private BigDecimal networthProposed = null;
	private BigDecimal totalIncomePlusNetworthProposed = null;
	private String noOfDependentsProposed = null;
	private BigDecimal meansTestThresholdProposed = null;
	private BigDecimal gmtThresholdProposed = null;
	private BigDecimal networthThresholdProposed = null;
	private BigDecimal basicPensionThresholdProposed = null;
	private BigDecimal childIncomeExclusionProposed = null;
	private BigDecimal aidnAttendanceProposed = null;
	private String editedByProposed = null;
	private Date editedDateProposed = null;

	/**
     * Default constructor.
     */
    public FinancialsReviewImpactForm()
    {
        super();
    }

    /**
     * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject()
    {
        return null;
    }
	/**
	 * @return Returns the aidnAttendance.
	 */
	public BigDecimal getAidnAttendance() {
		return aidnAttendance;
	}
	/**
	 * @param aidnAttendance The aidnAttendance to set.
	 */
	public void setAidnAttendance(BigDecimal aidnAttendance) {
		this.aidnAttendance = aidnAttendance;
	}
	/**
	 * @return Returns the aidnAttendanceProposed.
	 */
	public BigDecimal getAidnAttendanceProposed() {
		return aidnAttendanceProposed;
	}
	/**
	 * @param aidnAttendanceProposed The aidnAttendanceProposed to set.
	 */
	public void setAidnAttendanceProposed(BigDecimal aidnAttendanceProposed) {
		this.aidnAttendanceProposed = aidnAttendanceProposed;
	}
	/**
	 * @return Returns the basicPensionThreshold.
	 */
	public BigDecimal getBasicPensionThreshold() {
		return basicPensionThreshold;
	}
	/**
	 * @param basicPensionThreshold The basicPensionThreshold to set.
	 */
	public void setBasicPensionThreshold(BigDecimal basicPensionThreshold) {
		this.basicPensionThreshold = basicPensionThreshold;
	}
	/**
	 * @return Returns the basicPensionThresholdProposed.
	 */
	public BigDecimal getBasicPensionThresholdProposed() {
		return basicPensionThresholdProposed;
	}
	/**
	 * @param basicPensionThresholdProposed The basicPensionThresholdProposed to set.
	 */
	public void setBasicPensionThresholdProposed(
			BigDecimal basicPensionThresholdProposed) {
		this.basicPensionThresholdProposed = basicPensionThresholdProposed;
	}
	/**
	 * @return Returns the centralizedAnnDate.
	 */
	public Date getCentralizedAnnDate() {
		return centralizedAnnDate;
	}
	/**
	 * @param centralizedAnnDate The centralizedAnnDate to set.
	 */
	public void setCentralizedAnnDate(Date centralizedAnnDate) {
		this.centralizedAnnDate = centralizedAnnDate;
	}
	/**
	 * @return Returns the centralizedAnnDateProposed.
	 */
	public Date getCentralizedAnnDateProposed() {
		return centralizedAnnDateProposed;
	}
	/**
	 * @param centralizedAnnDateProposed The centralizedAnnDateProposed to set.
	 */
	public void setCentralizedAnnDateProposed(Date centralizedAnnDateProposed) {
		this.centralizedAnnDateProposed = centralizedAnnDateProposed;
	}
	/**
	 * @return Returns the childIncomeExclusion.
	 */
	public BigDecimal getChildIncomeExclusion() {
		return childIncomeExclusion;
	}
	/**
	 * @param childIncomeExclusion The childIncomeExclusion to set.
	 */
	public void setChildIncomeExclusion(BigDecimal childIncomeExclusion) {
		this.childIncomeExclusion = childIncomeExclusion;
	}
	/**
	 * @return Returns the childIncomeExclusionProposed.
	 */
	public BigDecimal getChildIncomeExclusionProposed() {
		return childIncomeExclusionProposed;
	}
	/**
	 * @param childIncomeExclusionProposed The childIncomeExclusionProposed to set.
	 */
	public void setChildIncomeExclusionProposed(
			BigDecimal childIncomeExclusionProposed) {
		this.childIncomeExclusionProposed = childIncomeExclusionProposed;
	}
	/**
	 * @return Returns the editedBy.
	 */
	public String getEditedBy() {
		return editedBy;
	}
	/**
	 * @param editedBy The editedBy to set.
	 */
	public void setEditedBy(String editedBy) {
		this.editedBy = editedBy;
	}
	/**
	 * @return Returns the editedByProposed.
	 */
	public String getEditedByProposed() {
		return editedByProposed;
	}
	/**
	 * @param editedByProposed The editedByProposed to set.
	 */
	public void setEditedByProposed(String editedByProposed) {
		this.editedByProposed = editedByProposed;
	}
	/**
	 * @return Returns the editedDate.
	 */
	public Date getEditedDate() {
		return editedDate;
	}
	/**
	 * @param editedDate The editedDate to set.
	 */
	public void setEditedDate(Date editedDate) {
		this.editedDate = editedDate;
	}
	/**
	 * @return Returns the editedDateProposed.
	 */
	public Date getEditedDateProposed() {
		return editedDateProposed;
	}
	/**
	 * @param editedDateProposed The editedDateProposed to set.
	 */
	public void setEditedDateProposed(Date editedDateProposed) {
		this.editedDateProposed = editedDateProposed;
	}
	/**
	 * @return Returns the gmtThreshold.
	 */
	public BigDecimal getGmtThreshold() {
		return gmtThreshold;
	}
	/**
	 * @param gmtThreshold The gmtThreshold to set.
	 */
	public void setGmtThreshold(BigDecimal gmtThreshold) {
		this.gmtThreshold = gmtThreshold;
	}
	/**
	 * @return Returns the gmtThresholdProposed.
	 */
	public BigDecimal getGmtThresholdProposed() {
		return gmtThresholdProposed;
	}
	/**
	 * @param gmtThresholdProposed The gmtThresholdProposed to set.
	 */
	public void setGmtThresholdProposed(BigDecimal gmtThresholdProposed) {
		this.gmtThresholdProposed = gmtThresholdProposed;
	}
	/**
	 * @return Returns the meansTestThreshold.
	 */
	public BigDecimal getMeansTestThreshold() {
		return meansTestThreshold;
	}
	/**
	 * @param meansTestThreshold The meansTestThreshold to set.
	 */
	public void setMeansTestThreshold(BigDecimal meansTestThreshold) {
		this.meansTestThreshold = meansTestThreshold;
	}
	/**
	 * @return Returns the meansTestThresholdProposed.
	 */
	public BigDecimal getMeansTestThresholdProposed() {
		return meansTestThresholdProposed;
	}
	/**
	 * @param meansTestThresholdProposed The meansTestThresholdProposed to set.
	 */
	public void setMeansTestThresholdProposed(
			BigDecimal meansTestThresholdProposed) {
		this.meansTestThresholdProposed = meansTestThresholdProposed;
	}
	/**
	 * @return Returns the networth.
	 */
	public BigDecimal getNetworth() {
		return networth;
	}
	/**
	 * @param networth The networth to set.
	 */
	public void setNetworth(BigDecimal networth) {
		this.networth = networth;
	}
	/**
	 * @return Returns the networthProposed.
	 */
	public BigDecimal getNetworthProposed() {
		return networthProposed;
	}
	/**
	 * @param networthProposed The networthProposed to set.
	 */
	public void setNetworthProposed(BigDecimal networthProposed) {
		this.networthProposed = networthProposed;
	}
	/**
	 * @return Returns the networthThreshold.
	 */
	public BigDecimal getNetworthThreshold() {
		return networthThreshold;
	}
	/**
	 * @param networthThreshold The networthThreshold to set.
	 */
	public void setNetworthThreshold(BigDecimal networthThreshold) {
		this.networthThreshold = networthThreshold;
	}
	/**
	 * @return Returns the networthThresholdProposed.
	 */
	public BigDecimal getNetworthThresholdProposed() {
		return networthThresholdProposed;
	}
	/**
	 * @param networthThresholdProposed The networthThresholdProposed to set.
	 */
	public void setNetworthThresholdProposed(
			BigDecimal networthThresholdProposed) {
		this.networthThresholdProposed = networthThresholdProposed;
	}
	/**
	 * @return Returns the noOfDependents.
	 */
	public String getNoOfDependents() {
		return noOfDependents;
	}
	/**
	 * @param noOfDependents The noOfDependents to set.
	 */
	public void setNoOfDependents(String noOfDependents) {
		this.noOfDependents = noOfDependents;
	}
	/**
	 * @return Returns the noOfDependentsProposed.
	 */
	public String getNoOfDependentsProposed() {
		return noOfDependentsProposed;
	}
	/**
	 * @param noOfDependentsProposed The noOfDependentsProposed to set.
	 */
	public void setNoOfDependentsProposed(String noOfDependentsProposed) {
		this.noOfDependentsProposed = noOfDependentsProposed;
	}
	/**
	 * @return Returns the primaryTestType.
	 */
	public String getPrimaryTestType() {
		return primaryTestType;
	}
	/**
	 * @param primaryTestType The primaryTestType to set.
	 */
	public void setPrimaryTestType(String primaryTestType) {
		this.primaryTestType = primaryTestType;
	}
	/**
	 * @return Returns the primaryTestTypeProposed.
	 */
	public String getPrimaryTestTypeProposed() {
		return primaryTestTypeProposed;
	}
	/**
	 * @param primaryTestTypeProposed The primaryTestTypeProposed to set.
	 */
	public void setPrimaryTestTypeProposed(String primaryTestTypeProposed) {
		this.primaryTestTypeProposed = primaryTestTypeProposed;
	}
    /**
     * @return Returns the testStatus.
     */
    public String getTestStatus() {
        return testStatus;
    }
    /**
     * @param testStatus The testStatus to set.
     */
    public void setTestStatus(String testStatus) {
        this.testStatus = testStatus;
    }
    /**
	 * @return Returns the testDeterminedStatus.
	 */
	public String getTestDeterminedStatus() {
		return testDeterminedStatus;
	}
	/**
	 * @param testDeterminedStatus The testDeterminedStatus to set.
	 */
	public void setTestDeterminedStatus(String testDeterminedStatus) {
		this.testDeterminedStatus = testDeterminedStatus;
	}
    /**
     * @return Returns the testStatusProposed.
     */
    public String getTestStatusProposed() {
        return testStatusProposed;
    }
    /**
     * @param testStatusProposed The testStatusProposed to set.
     */
    public void setTestStatusProposed(String testStatusProposed) {
        this.testStatusProposed = testStatusProposed;
    }
    /**
	 * @return Returns the testDeterminedStatusProposed.
	 */
	public String getTestDeterminedStatusProposed() {
		return testDeterminedStatusProposed;
	}
	/**
	 * @param testDeterminedStatusProposed The testDeterminedStatusProposed to set.
	 */
	public void setTestDeterminedStatusProposed(
			String testDeterminedStatusProposed) {
		this.testDeterminedStatusProposed = testDeterminedStatusProposed;
	}
	/**
	 * @return Returns the totalDeductibleExp.
	 */
	public BigDecimal getTotalDeductibleExp() {
		return totalDeductibleExp;
	}
	/**
	 * @param totalDeductibleExp The totalDeductibleExp to set.
	 */
	public void setTotalDeductibleExp(BigDecimal totalDeductibleExp) {
		this.totalDeductibleExp = totalDeductibleExp;
	}
	/**
	 * @return Returns the totalDeductibleExpProposed.
	 */
	public BigDecimal getTotalDeductibleExpProposed() {
		return totalDeductibleExpProposed;
	}
	/**
	 * @param totalDeductibleExpProposed The totalDeductibleExpProposed to set.
	 */
	public void setTotalDeductibleExpProposed(
			BigDecimal totalDeductibleExpProposed) {
		this.totalDeductibleExpProposed = totalDeductibleExpProposed;
	}
	/**
	 * @return Returns the totalIncome.
	 */
	public BigDecimal getTotalIncome() {
		return totalIncome;
	}
	/**
	 * @param totalIncome The totalIncome to set.
	 */
	public void setTotalIncome(BigDecimal totalIncome) {
		this.totalIncome = totalIncome;
	}
	/**
	 * @return Returns the totalIncomePlusNetworth.
	 */
	public BigDecimal getTotalIncomePlusNetworth() {
		return totalIncomePlusNetworth;
	}
	/**
	 * @param totalIncomePlusNetworth The totalIncomePlusNetworth to set.
	 */
	public void setTotalIncomePlusNetworth(BigDecimal totalIncomePlusNetworth) {
		this.totalIncomePlusNetworth = totalIncomePlusNetworth;
	}
	/**
	 * @return Returns the totalIncomePlusNetworthProposed.
	 */
	public BigDecimal getTotalIncomePlusNetworthProposed() {
		return totalIncomePlusNetworthProposed;
	}
	/**
	 * @param totalIncomePlusNetworthProposed The totalIncomePlusNetworthProposed to set.
	 */
	public void setTotalIncomePlusNetworthProposed(
			BigDecimal totalIncomePlusNetworthProposed) {
		this.totalIncomePlusNetworthProposed = totalIncomePlusNetworthProposed;
	}
	/**
	 * @return Returns the totalIncomeProposed.
	 */
	public BigDecimal getTotalIncomeProposed() {
		return totalIncomeProposed;
	}
	/**
	 * @param totalIncomeProposed The totalIncomeProposed to set.
	 */
	public void setTotalIncomeProposed(BigDecimal totalIncomeProposed) {
		this.totalIncomeProposed = totalIncomeProposed;
	}
	/**
	 * @return Returns the assesedPerson.
	 */
	public Person getAssesedPerson() {
		return assesedPerson;
	}
	/**
	 * @param assesedPerson The assesedPerson to set.
	 */
	public void setAssesedPerson(Person assesedPerson) {
		this.assesedPerson = assesedPerson;
	}
	/**
	 * @return Returns the person.
	 */
	public Person getPerson() {
		return person;
	}
	/**
	 * @param person The person to set.
	 */
	public void setPerson(Person person) {
		this.person = person;
	}
	/**
	 * @return Returns the testEffDate.
	 */
	public String getTestEffDate() {
		return testEffDate;
	}
	/**
	 * @param testEffDate The testEffDate to set.
	 */
	public void setTestEffDate(String testEffDate) {
		this.testEffDate = testEffDate;
	}
	/**
	 * @return Returns the testEffDateProposed.
	 */
	public String getTestEffDateProposed() {
		return testEffDateProposed;
	}
	/**
	 * @param testEffDateProposed The testEffDateProposed to set.
	 */
	public void setTestEffDateProposed(String testEffDateProposed) {
		this.testEffDateProposed = testEffDateProposed;
	}
	/**
	 * @return Returns the incomeTest.
	 */
	public IncomeTest getIncomeTest() {
		return incomeTest;
	}
	/**
	 * @param incomeTest The incomeTest to set.
	 */
	public void setIncomeTest(IncomeTest incomeTest) {
		this.incomeTest = incomeTest;
	}
	/**
	 * @return Returns the incomeTestProposed.
	 */
	public IncomeTest getIncomeTestProposed() {
		return incomeTestProposed;
	}
	/**
	 * @param incomeTestProposed The incomeTestProposed to set.
	 */
	public void setIncomeTestProposed(IncomeTest incomeTestProposed) {
		this.incomeTestProposed = incomeTestProposed;
	}
	/**
	 * @return Returns the incomeYear.
	 */
	public String getIncomeYear() {
		return incomeYear;
	}
	/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(String incomeYear) {
		this.incomeYear = incomeYear;
	}
}
