/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.service.ServiceConfigurationException;

import java.util.Map;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework classes

// ESR classes
import gov.va.med.esr.ui.util.SessionManager;

/**
 * This struts action is used to support the financials dependent add page.
 *
 * @author Priya R.
 * @version 3.0
 */
public class FinancialsReviewImpactAction extends FinancialsAction
{

    /**
     * Default constructor.
     */
    public FinancialsReviewImpactAction()
    {
        super();
    }

    /**
     * Displays the Demographics Personal page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	FinancialsReviewImpactForm reviewForm = getFinancialsReviewImpactForm(form);
  		
  		// Get the Person object from the cache
        Person person = getSelectedPerson(request);
        reviewForm.setPerson( person );

    	// Get the calculated Person object from the cache
        Person assesedPerson = (Person)SessionManager.getCalculatedPerson( request);
        reviewForm.setAssesedPerson(assesedPerson);
        
    	// Get the income year from the cache and set it on the form
    	Integer incomeYear = getSelectedIncomeYear(request);
    	reviewForm.setIncomeYear(String.valueOf(incomeYear));

        
		if(conversionService != null)
		{
			conversionService.convert(person,reviewForm);
		}

    	return mapping.findForward(FORWARD_FINANCIAL_REVIEW_IMPACT);
    }

    /**
     * Handles an optimistic lock exception by resetting the form and redisplaying the page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	form.reset(mapping,request);
    	return display(mapping,form,request,response);
    }

    /**
     * Updates the personal information.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward complete(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get the income year from the cache and set it on the form
        Integer incomeYear = getSelectedIncomeYear(request);

  		// Get the Person object from the cache
        Person person = getUpdatedPerson(request);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        		
		// Call service layer here
        if (isAddAPerson){
        	 updateSelectedPerson(request, person );
        }
        else {
        	Person updatedPerson = getFinancialsService().updateFinancialAssessment(incomeYear,person);
	        if(updatedPerson != null)
			{
				setUpdatedPerson(request, null);
				SessionManager.setCalculatedPerson( request, null );
					
			    // Store updated person in the cache
			    updateSelectedPerson( request, updatedPerson );
			}
        }	
        return mapping.findForward(FORWARD_FINANCIALS_SUMMARY);
    }
    
    /**
     * Return to Financial Details screen.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward returnToFinancialDetail(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        return mapping.findForward(FORWARD_RETURN_TO_FINANCIAL_DETAILS_EDIT);
    }

    /**
     * Review the impact to finacial information.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward saveInProcess(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
		return mapping.findForward(FORWARD_FINANCIALS_SUMMARY);
    } 
    
    /**
     * Cancels this page and goes to the demographics overview screen.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward cancel(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
		return mapping.findForward(FORWARD_FINANCIALS_SUMMARY);
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     * @return the method map
     */
   protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.completeAssessment", "complete");
        map.put("button.discardChanges", "cancel");
        map.put("button.returnToFinancialDetails", "returnToFinancialDetail");
        map.put("button.saveInProcess", "saveInProcess");
        map.put("button.display","display");
        map.put("button.reviewImpact", "display");
        return map;
    }
   
   /**
    * Checks to ensure the passed in ActionForm is not null and of the correct type.
    *
    * @param form The struts form to check
    * @return The passed in form type-casted to a DemographicPersonalForm
    * @throws gov.va.med.fw.service.ServiceConfigurationException if the form is null or of an incorrect type.
    */
   protected FinancialsReviewImpactForm getFinancialsReviewImpactForm(ActionForm form) throws ServiceConfigurationException
   {
   	FinancialsReviewImpactForm personalForm =
           (form instanceof FinancialsReviewImpactForm) ? (FinancialsReviewImpactForm)form : null;
       if (personalForm == null)
       {
           throw new ServiceConfigurationException("FinancialsReviewImpactForm not properly configured.");
       }
       return personalForm;
   }
}