/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;

import java.util.Date;

/**
 * A UI specific implementation of the conversion service.
 * 
 * @author Priya R.
 * @version 1.0
 */
public class FinancialsReviewConversionService extends UIConversionServiceImpl {

    /**
     * Default constructor.
     */
    public FinancialsReviewConversionService() {}

    /**
     * Converts between a Person object that contains the financial information
     * and the FinancialDetailsForm.
     * 
     * @param source
     *            the source object
     * @param target
     *            the target object
     * 
     * @throws gov.va.med.fw.conversion.ConversionServiceException
     *             if any errors were encountered during the conversion.
     */
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        FinancialsReviewImpactForm form = null;

        if (source instanceof Person) {
            person = (Person) source;
            if (target instanceof FinancialsReviewImpactForm) {
                form = (FinancialsReviewImpactForm) target;
            } else {
                throw new ConversionServiceException("Target object is of type "
                        + target.getClass().getName() + " and must be of type FinancialsReviewImpactForm.");
            }

            // Convert from the Person to the form
            convertPersonToForm(person, form);
        }
    }

    /**
     * Converts the financial data from the Person object to the form.
     * 
     * @param person
     *            The person
     * @param form
     *            The form
     * 
     * @throws ConversionServiceException
     *             If there were any problems converting the person to the form.
     */
    protected void convertPersonToForm(Person person, FinancialsReviewImpactForm form)
            throws ConversionServiceException {
        try {
            IncomeTest test = person.getIncomeTest(new Integer(form.getIncomeYear()));
            if (test != null) {
                form.setIncomeTest(test);

                if (test.getStatus() != null)
                    form.setTestStatus(test.getStatus().getDescription());

                if (test.getDeterminedStatus() != null)
                    form.setTestDeterminedStatus(test.getDeterminedStatus().getDescription());

                // totalIncomePlusNetworth
                if (test.getTotalIncome() != null && test.getNetWorth() != null)
                    form.setTotalIncomePlusNetworth(test.getTotalIncome().add(test.getNetWorth()));
            }

            if (form.getAssesedPerson() != null) {
                IncomeTest testProposed = form.getAssesedPerson().getIncomeTest(
                        new Integer(form.getIncomeYear()));
                if (testProposed != null) {
                    form.setIncomeTestProposed(testProposed);

                    // test determined status
                    if (testProposed.getStatus() != null)
                        form.setTestStatusProposed(testProposed.getStatus().getDescription());

                    if (testProposed.getDeterminedStatus() != null)
                        form.setTestDeterminedStatusProposed(testProposed.getDeterminedStatus()
                                .getDescription());

                    // totalIncomePlusNetworth
                    if (testProposed.getTotalIncome() != null && testProposed.getNetWorth() != null)
                        form.setTotalIncomePlusNetworthProposed(testProposed.getTotalIncome().add(
                                testProposed.getNetWorth()));

                    Date today = new Date();
                    form.setEditedDateProposed(today);

                }
            }
        } catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert Person to FinancialsReviewImpactForm.",
                    ex);
        }
    }
}
