/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java classes
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

// Framework classes
import gov.va.med.fw.ui.struts.AbstractForm;

// ESR classes
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;

/**
 * This is the struts action form for the financials overview screen.
 *
 * @author DNS   ZHENGH
 */
public class FinancialsForm extends AbstractForm
{
    private static final long serialVersionUID = 5987986774876447775L;
    private FinancialStatement financialstatement = null;
    private IncomeTest incometest = null;
    private IncomeTestStatus meansTest = null;
    private List assets = null;
    private List incomes = null;
    private List expenses = null;
    private List debts = null;
    private DependentFinancials dependentFinancials = null;
    private SpouseFinancials spouseFinancials = null;
    private PatientVisitSummary patientVisitSummary = null;
    private List patientVisitSummaries = null;
    private Integer totalInpatientDays;
    private Integer totalOutpatientVisits;
    private String rxCopayStatus;
    private String ltcCopayStatus;
    private BigDecimal calculatedTotalIncome = null;
    private BigDecimal calculatedNetWorth = null;
    private BigDecimal ajustedMedicalExp = null;
    private List dependentInfoList = null;
    private boolean canFinancialsBeAdded = true;
    private boolean isCurrentIncomeTest = false;
    private boolean previousYearInd = false;
    private String incomeYear;
    private String testCompletedDate;
    private String testDeterminedStatus;
    private String testStatus;
    private String focusButton;
    private Collection beneficiaryTravels;
    private int beneficiaryTravelsSize;
    private Boolean btFinancialInd;
    
    

    /**
     * Default constructor.
     */
    public FinancialsForm()
    {
        super();
    }

    public void setFinancialStatement(FinancialStatement fsmt)
    {
        financialstatement = fsmt;
    }

    public FinancialStatement getFinancialStatement()
    {
        return this.financialstatement;
    }
    
    //set focus button
    public String getFocusButton()
    {
    	return focusButton;
    }
      
    public void setFocusButton(String focusButton) {
    	this.focusButton = focusButton;
    }

    /**
     * @return Returns Incometest
     */
    public IncomeTest getIncometest()
    {

        return incometest;
    }

    /**
     * @param incometest The incometest to set.
     */
    public void setIncometest(IncomeTest incometest)
    {
        this.incometest = incometest;
    }

    /**
     * @return Returns the meansTest.
     */
    public IncomeTestStatus getMeansTest()
    {
        return meansTest;
    }

    /**
     * @param meansTest The meansTest to set.
     */
    public void setMeansTest(IncomeTestStatus meansTest)
    {
        this.meansTest = meansTest;
    }

    /**
     * @return Returns the assests.
     */
    public List getAssets()
    {
        return assets;
    }

    /**
     * @param assets The assests to set.
     */
    public void setAssets(List assets)
    {
        this.assets = assets;
    }

    /**
     * @return Returns the incomes.
     */
    public List getIncomes()
    {
        return incomes;
    }

    /**
     * @param incomes The incomes to set.
     */
    public void setIncomes(List incomes)
    {
        this.incomes = incomes;
    }

    /**
     * @return Returns the expenses.
     */
    public List getExpenses()
    {
        return expenses;
    }

    /**
     * @param expenses The expenses to set.
     */
    public void setExpenses(List expenses)
    {
        this.expenses = expenses;
    }

    /**
     * @return Returns the dependentFinancials.
     */
    public DependentFinancials getDependentFinancials()
    {
        return dependentFinancials;
    }

    /**
     * @param dependentFinancials The dependentFinancials to set.
     */
    public void setDependentFinancials(DependentFinancials dependentFinancials)
    {
        this.dependentFinancials = dependentFinancials;
    }

    /**
     * @return Returns the spouseFinancials.
     */
    public SpouseFinancials getSpouseFinancials()
    {
        return spouseFinancials;
    }

    /**
     * @param spouseFinancials The spouseFinancials to set.
     */
    public void setSpouseFinancials(SpouseFinancials spouseFinancials)
    {
        this.spouseFinancials = spouseFinancials;
    }

    /**
     * @return Returns the patientVisitSummary.
     */
    public PatientVisitSummary getPatientVisitSummary()
    {
        return patientVisitSummary;
    }

    /**
     * @param patientVisitSummary The patientVisitSummary to set.
     */
    public void setPatientVisitSummary(PatientVisitSummary patientVisitSummary)
    {
        this.patientVisitSummary = patientVisitSummary;
    }

    /**
     * @return Returns the calculatedNetWorth.
     */
    public BigDecimal getCalculatedNetWorth()
    {
        return calculatedNetWorth;
    }

    /**
     * @param calculatedNetWorth The calculatedNetWorth to set.
     */
    public void setCalculatedNetWorth(BigDecimal calculatedNetWorth)
    {
        this.calculatedNetWorth = calculatedNetWorth;
    }

    /**
     * @return Returns the calculatedTotalIncome.
     */
    public BigDecimal getCalculatedTotalIncome()
    {
        return calculatedTotalIncome;
    }

    /**
     * @param calculatedTotalIncome The calculatedTotalIncome to set.
     */
    public void setCalculatedTotalIncome(BigDecimal calculatedTotalIncome)
    {
        this.calculatedTotalIncome = calculatedTotalIncome;
    }

    /**
     * @return Returns the patientVisitSummaries.
     */
    public List getPatientVisitSummaries()
    {
        return patientVisitSummaries;
    }

    /**
     * @param patientVisitSummaries The patientVisitSummaries to set.
     */
    public void setPatientVisitSummaries(List patientVisitSummaries)
    {
        this.patientVisitSummaries = patientVisitSummaries;
    }

    /**
     * @return Returns the previousYearInd.
     */
    public boolean getPreviousYearInd()
    {
        return previousYearInd;
    }

    /**
     * @param previousYearInd The previousYearInd to set.
     */
    public void setPreviousYearInd(boolean previousYearInd)
    {
        this.previousYearInd = previousYearInd;
    }

    /**
     * @return Returns the debts.
     */
    public List getDebts()
    {
        return debts;
    }

    /**
     * @param debts The debts to set.
     */
    public void setDebts(List debts)
    {
        this.debts = debts;
    }

    /**
     * @return Returns the dependentInfoList.
     */
    public List getDependentInfoList()
    {
        return dependentInfoList;
    }

    /**
     * @param dependentInfoList The dependentInfoList to set.
     */
    public void setDependentInfoList(List dependentInfoList)
    {
        this.dependentInfoList = dependentInfoList;
    }

    /**
     * @return Returns the incomeYear.
     */
    public String getIncomeYear()
    {
        return incomeYear;
    }

    /**
     * @param incomeYear The incomeYear to set.
     */
    public void setIncomeYear(String incomeYear)
    {
        this.incomeYear = incomeYear;
    }

    /**
     * @return Returns the totalInpatientDays.
     */
    public Integer getTotalInpatientDays()
    {
        return totalInpatientDays;
    }

    /**
     * @param totalInpatientDays The totalInpatientDays to set.
     */
    public void setTotalInpatientDays(Integer totalInpatientDays)
    {
        this.totalInpatientDays = totalInpatientDays;
    }

    /**
     * @return Returns the totalOutpatientVisits.
     */
    public Integer getTotalOutpatientVisits()
    {
        return totalOutpatientVisits;
    }

    /**
     * @param totalOutpatientVisits The totalOutpatientVisits to set.
     */
    public void setTotalOutpatientVisits(Integer totalOutpatientVisits)
    {
        this.totalOutpatientVisits = totalOutpatientVisits;
    }

    /**
     * @return Returns the canFinancialsBeAdded.
     */
    public boolean getCanFinancialsBeAdded()
    {
        return canFinancialsBeAdded;
    }

    /**
     * @param canFinancialsBeAdded The canFinancialsBeAdded to set.
     */
    public void setCanFinancialsBeAdded(boolean canFinancialsBeAdded)
    {
        this.canFinancialsBeAdded = canFinancialsBeAdded;
    }

    /**
     * @return Returns the ltcCopayStatus.
     */
    public String getLtcCopayStatus()
    {
        return ltcCopayStatus;
    }

    /**
     * @param ltcCopayStatus The ltcCopayStatus to set.
     */
    public void setLtcCopayStatus(String ltcCopayStatus)
    {
        this.ltcCopayStatus = ltcCopayStatus;
    }

    /**
     * @return Returns the rxCopayStatus.
     */
    public String getRxCopayStatus()
    {
        return rxCopayStatus;
    }

    /**
     * @param rxCopayStatus The rxCopayStatus to set.
     */
    public void setRxCopayStatus(String rxCopayStatus)
    {
        this.rxCopayStatus = rxCopayStatus;
    }

    /**
     * Determines if this income test is the current income test or not.
     * @return True if the income test is current or false if not.
     */
    public boolean getIsCurrentIncomeTest()
    {
        return isCurrentIncomeTest;
    }

    /**
     * Sets if the income test is the current one or not.
     * @param currentIncomeTest True if the income test is current or false if not.
     */
    public void setIsCurrentIncomeTest(boolean currentIncomeTest)
    {
        isCurrentIncomeTest = currentIncomeTest;
    }
	/**
	 * @return Returns the testCompletedDate.
	 */
	public String getTestCompletedDate() {
		return testCompletedDate;
	}
	/**
	 * @param testCompletedDate The testCompletedDate to set.
	 */
	public void setTestCompletedDate(String testCompletedDate) {
		this.testCompletedDate = testCompletedDate;
	}
	/**
	 * @return Returns the testDeterminedStatus.
	 */
	public String getTestDeterminedStatus() {
		return testDeterminedStatus;
	}
	/**
	 * @param testDeterminedStatus The testDeterminedStatus to set.
	 */
	public void setTestDeterminedStatus(String testDeterminedStatus) {
		this.testDeterminedStatus = testDeterminedStatus;
	}
	/**
	 * @return Returns the beneficiaryTravels.
	 */
	public Collection getBeneficiaryTravels() {
		return beneficiaryTravels;
	}
	/**
	 * @param beneficiaryTravels The beneficiaryTravels to set.
	 */
	public void setBeneficiaryTravels(Collection beneficiaryTravels) {
		this.beneficiaryTravels = beneficiaryTravels;
	}
	/**
	 * @return Returns the beneficiaryTravelsSize.
	 */
	public int getBeneficiaryTravelsSize() {
		return beneficiaryTravelsSize;
	}
	/**
	 * @param beneficiaryTravelsSize The beneficiaryTravelsSize to set.
	 */
	public void setBeneficiaryTravelsSize(int beneficiaryTravelsSize) {
		this.beneficiaryTravelsSize = beneficiaryTravelsSize;
	}
	/**
	 * @return Returns the testStatus.
	 */
	public String getTestStatus() {
		return testStatus;
	}
	/**
	 * @param testStatus The testStatus to set.
	 */
	public void setTestStatus(String testStatus) {
		this.testStatus = testStatus;
	}
	/**
	 * @return Returns the ajustedMedicalExp.
	 */
	public BigDecimal getAjustedMedicalExp() {
		return ajustedMedicalExp;
	}
	/**
	 * @param ajustedMedicalExp The ajustedMedicalExp to set.
	 */
	public void setAjustedMedicalExp(BigDecimal ajustedMedicalExp) {
		this.ajustedMedicalExp = ajustedMedicalExp;
	}

	public Boolean getBtFinancialInd() {
		return btFinancialInd;
	}

	public void setBtFinancialInd(Boolean btFinancialInd) {
		this.btFinancialInd = btFinancialInd;
	}

	
	
	
}