/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java Classes
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.fw.ui.struts.AbstractForm;

import java.util.ArrayList;
import java.util.List;

/**
 * This is the form used in conjunction with the Financials Dependent Overview page.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class FinancialsDependentOverviewForm extends AbstractForm
{
    private static final long serialVersionUID = -4570760355883138897L;
    private boolean spouseAvaliableInd = false;
    private List dependentList = new ArrayList();

	/**
     * Default constructor.
     */
    public FinancialsDependentOverviewForm()
    {
        super();
    }

	/**
	 * @return Returns the dependentList.
	 */
	public List getDependentList() {
		return dependentList;
	}
	/**
	 * @param dependentList The dependentList to set.
	 */
	public void setDependentList(List dependentList) {
		this.dependentList = dependentList;
	}
	
	/**
	 * @param dependent The dependent to add.
	 */
	public void addDependent(DependentFinancialInfoBean dependent) {
		dependentList.add(dependent);
	}

	/**
	 * @param spouse The dependent to add.
	 */
	public void addSpouse(SpouseFinancialInfoBean spouse) {
		dependentList.add(spouse);
        //Set the spouse indicator to true when atleast one active spouse is found.
        if(spouse.isActive()) {
            setSpouseAvaliableInd(true);
        }
	}

    /**
     * Returns whether the dependent list is empty or not.
     *
     * @return True if the dependent list is empty or false if not.
     */
    public boolean getIsDependentListEmpty()
    {
        return dependentList.isEmpty();
    }

	/**
	 * @return Returns the spouseAvaliableInd.
	 */
	public boolean getSpouseAvaliableInd() {
		return spouseAvaliableInd;
	}
	/**
	 * @param spouseAvaliableInd The spouseAvaliableInd to set.
	 */
	public void setSpouseAvaliableInd(boolean spouseAvaliableInd) {
		this.spouseAvaliableInd = spouseAvaliableInd;
	}
}
