/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java Classes

// Framework Classes
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.esr.ui.common.action.AddressForm;


/**
 * This is the form used in conjunction with the Financials Dependent pages.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class FinancialsDependentForm extends AddressForm
{
    private static final long serialVersionUID = 8187496881788953507L;
    
    private Person person = null;
    //dependent financials id
    private String dependentId;
    private String relationship;
    private boolean spouseInd = true;
    private String incomeYear;
    private SpouseFinancialInfoBean spouseInfo = new SpouseFinancialInfoBean();
    private DependentFinancialInfoBean dependentInfo = new DependentFinancialInfoBean();
    public final static String ERRORS_REQUIRED2 = "errors.required2";
    public final static String EMPLOYERINFO = "Employer";
    /**
     * Default constructor.
     */
    public FinancialsDependentForm()
    {
        super();
    }

    // ***** REVISIT *****
    // We don't need Person in this form
    /**
     * @return Returns the person.
     */
    public Person getPerson()
    {
        return (Person)getVO();
    }

    /**
     * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject()
    {
        return new Person();
    }

	/**
	 * @return Returns the spouse.
	 */
	public boolean getSpouseInd() {
		return spouseInd;
	}
	/**
	 * @param spouse The spouse to set.
	 */
	public void setSpouseInd(boolean spouse) {
		this.spouseInd = spouse;
	}
	/**
	 * @return Returns the dependentInfo.
	 */
	public DependentFinancialInfoBean getDependentInfo() {
		return dependentInfo;
	}
	/**
	 * @param dependentInfo The dependentInfo to set.
	 */
	public void setDependentInfo(DependentFinancialInfoBean dependentInfo) {
		this.dependentInfo = dependentInfo;
	}
	/**
	 * @return Returns the spouseInfo.
	 */
	public SpouseFinancialInfoBean getSpouseInfo() {
		return spouseInfo;
	}
	/**
	 * @param spouseInfo The spouseInfo to set.
	 */
	public void setSpouseInfo(SpouseFinancialInfoBean spouseInfo) {
		this.spouseInfo = spouseInfo;
	}
	/**
	 * @return Returns the dependentId.
	 */
	public String getDependentId() {
		return dependentId;
	}
	/**
	 * @param dependentId The dependentId to set.
	 */
	public void setDependentId(String dependentId) {
		this.dependentId = dependentId;
	}
	/**
	 * @return Returns the relationship.
	 */
	public String getRelationship() {
		return relationship;
	}
	/**
	 * @param relationship The relationship to set.
	 */
	public void setRelationship(String relationship) {
		this.relationship = relationship;
		if(StringUtils.equalsIgnoreCase(relationship, "Spouse"))
			this.spouseInd = true;
	}
	/**
	 * @return Returns the incomeYear.
	 */
	public String getIncomeYear() {
		return incomeYear;
	}
	/**
	 * @param incomeYear The incomeYear to set.
	 */
	public void setIncomeYear(String incomeYear) {
		this.incomeYear = incomeYear;
	}
    
    /**
     * Is User added/entered spouse has inactive date.
     */
    public boolean isSpouseHasInactiveDate() {
        return (spouseInfo != null && StringUtils.isNotEmpty(spouseInfo.getInactiveDate())) ? true : false;
    }
    
    public ActionErrors validate(ActionMapping mapping,
            HttpServletRequest request) {
    	ActionErrors validationErrors = super.validate(mapping, request);
    	if(getSpouseInd() && this.isAddAPerson()) 
    		return validateOptionalAddressIncludingCountry(mapping, request, validationErrors);
        // TODO need to validate employer phone if entered as well here
    	return validationErrors;
 }
}
