/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Person;

// Java classes

// Library classes

// Framework classes

// ESR classes

/**
 * This struts action is used to support the financials dependent pages.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class FinancialsDependentAction extends FinancialsAction
{
	// Struts forwards
    public static final String FORWARD_FINANCIALS_DEPENDENT_OVERVIEW = "financialsDependentOverview";
    public static final String FORWARD_FINANCIALS_DEPENDENT_OVERVIEW_WITH_MSG = "financialsDependentOverviewWithMsg";

    /**
     * Default constructor.
     */
    public FinancialsDependentAction()
    {
        super();
    }
    
    protected boolean isPersonHasActiveSpouse(Integer incomeYear, Person person) {
        return (getActiveSpouse(incomeYear,person) != null) ? true : false;
    }
    
    protected SpouseFinancials getActiveSpouse(Integer incomeYear, Person person) {
        FinancialStatement finStmt = person.getFinancialStatement(incomeYear);
        return (finStmt != null) ? finStmt.getActiveSpouseFinancials() : null;
    }
}