/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.FinancialDetailsData;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.esr.common.ui.conversion.CommonFinancialDetailsConversionService;
import gov.va.med.esr.common.ui.conversion.CommonFinancialsDependentConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.ui.UIConstants;
import gov.va.med.fw.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import sun.security.util.Debug;

/**
 * A UI specific implementation of the conversion service.
 * 
 * @author Priya R.
 * @version 1.0
 */
public class FinancialDetailsConversionService extends UIConversionServiceImpl {

    private CommonFinancialDetailsConversionService commonDetailsConversionService;
    private FinancialsDependentConversionService dependentConversionService;
         
    public FinancialDetailsConversionService() {}

    /**
     * Converts between a Person object that contains the financial information
     * and the FinancialDetailsForm.
     * 
     * @param source
     *            the source object
     * @param target
     *            the target object
     * 
     * @throws gov.va.med.fw.conversion.ConversionServiceException
     *             if any errors were encountered during the conversion.
     */
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        // TODO need to account for pre and post 2005 formats when converting
        // the financial amounts
        
        Person person = null;
        FinancialDetailsForm form = null;

        if (source instanceof FinancialDetailsForm) {
            form = (FinancialDetailsForm) source;
            if (target instanceof Person) {
                person = (Person) target;
            } else {
                throw new ConversionServiceException("Target object is of type "
                        + target.getClass().getName() + " and must be of type Person.");
            }

            // Convert from the Form to Person
            convertFormToPerson(form, person);
         } else {
            // convert from Person to Form -- delegate to the implementation in common package
             getCommonDetailsConversionService().convert(source, target);
         }
    }

    /**
     * Converts the financial data from the Person object to the form.
     * 
     * @param person
     *            The person
     * @param form
     *            The form
     * 
     * @throws ConversionServiceException
     *             If there were any problems converting the person to the form.
     */
    protected void convertPersonToForm(Person person, FinancialDetailsForm form)
            throws ConversionServiceException {
        getCommonDetailsConversionService().convert(person, form);
    }

    /**
     * Converts the form data to the Person object.
     * 
     * @param form
     *            The form
     * @param person
     *            The person
     * 
     * @throws ConversionServiceException
     *             If there were any problems converting the form to the person.
     */
    protected void convertFormToPerson(FinancialDetailsForm form, Person person)
            throws ConversionServiceException {

        try {
        	
        	boolean isAddAPerson = form.isAddAPerson();
            String year = form.getIncomeYear();

            if (year == null)
                throw new ConversionServiceException(
                        "Unable to convert FinancialDetailsForm to Person, no IncomeYear selected");

            Integer incomeYear = new Integer(year);

            FinancialStatement ftmt = person.getFinancialStatement(new Integer(year));

            if (ftmt == null) {
                ftmt = new FinancialStatement();
                ftmt.setIsPost2005Format(Boolean.TRUE);
                person.setFinancialStatement(incomeYear, ftmt);
            }

            ftmt.setMarriedLastCalendarYear(getBoolean(form.getMarriedLastCalendarYear()));

            IncomeTest test = person.getIncomeTest(incomeYear);
            // Date today = new Date();
            if (test == null && form.getNewIncomeTestInd()) {
                test = new IncomeTest();
                test.setIncomeYear(incomeYear);
                person.setIncomeTest(incomeYear, test);

                test.setEffectiveDate(DateUtils.getDate(form.getTestEffDate()));
            }

            IncomeTestSource testSource = (IncomeTestSource) getLookupCacheService().getByCodeFromCache(
                    IncomeTestSource.class, IncomeTestSource.CODE_HEC.getName());
            test.setSource(testSource);

            // test.setLastEditedDate(today);
            
            
            test.setSendForAdjudication(getBoolean(form.getSendForAdjudication()));
            test.setAgreesToPayDeductible(getBoolean(form.getAgreeToPayDeductible()));
            test.setDiscloseFinancialInformation(getBoolean(form.getDiscloseFinIncome()));

            // veteran financial amounts
            convertFormToVeteranFinancialAmounts(form, ftmt);

            // spouse financials
            SpouseFinancials sf = ftmt.getRecentSpouseFinancials();
            if (sf != null) {
                convertFormToSpouseFinancials(form, sf);
            }

            // dependent financials
            List depIds = form.getDepFinacialsIdList();
            if (depIds != null && !depIds.isEmpty()) {
                for (int i = 0; i < depIds.size(); i++) {
                    String id = form.getDepFinacialsId(i);
                    Set dependentFinancials = ftmt.getDependentFinancials();
                    for (Iterator iter = dependentFinancials.iterator(); iter.hasNext();) {
                        DependentFinancials df = (DependentFinancials) iter.next();
                        if (isAddAPerson){
                        	if (df !=null)
                        		convertFormToDependentFinancials(form, i, df);
                        }
                        else {
                        	if (df != null && id.equals(df.getEntityKey().getKeyValueAsString()))
                            convertFormToDependentFinancials(form, i, df);
                        }
                    }
                }
            }
        } catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert FinancialDetailsForm to Person.", ex);
        }
    }

    // --------------- Form to Person
    // ----------------------------------------------------------------
    private void convertFormToVeteranFinancialAmounts(FinancialDetailsForm form, FinancialStatement ftmt)
            throws Exception {

        // Income
        setIncome(form.getTotalEmploymentIncome(), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT
                .getName(), ftmt);
        setIncome(form.getOtherIncome(), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), ftmt);
        setIncome(form.getNetIncomeFromFarmRanchOrBusiness(),
                IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), ftmt);
        setIncome(form.getUSCivilServiceIncome(), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), ftmt);
        setIncome(form.getInterestDividentAnuityIncome(), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY
                .getName(), ftmt);
        setIncome(form.getUnemploymentIncome(), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(),
                ftmt);
        setIncome(form.getSocialSecurityIncome(), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), ftmt);
        setIncome(form.getMilitaryRetirementIncome(), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(),
                ftmt);
        setIncome(form.getRailroadRetirementIncome(), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(),
                ftmt);
        setIncome(form.getOtherRetirementIncome(), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), ftmt);
        setIncome(form.getWorkersCompIncome(), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), ftmt);

        // Expense
        setExpense(form.getEducationExpense(), ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getName(), ftmt);
        setExpense(form.getNonReimbMedicalExpense(), ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL
                .getName(), ftmt);
        setExpense(form.getFuneralBurialExpense(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName(),
                ftmt);
        // setExpense(form.getAdjustedMedicalExpense(),
        // ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName(), ftmt);

        // Asset
        setAsset(form.getCashAndBankAccountAsset(), AssetType.CODE_CASH.getName(), ftmt);
        setAsset(form.getRealPropertyAsset(), AssetType.CODE_REAL_ESTATE.getName(), ftmt);
        setAsset(form.getOtherPropertyAsset(), AssetType.CODE_OTHER.getName(), ftmt);
        setAsset(form.getStocksAsset(), AssetType.CODE_STOCKS_AND_BONDS.getName(), ftmt);

        // Debt
        if (StringUtils.isNotEmpty(form.getDebt())) {
            Debt debt = ftmt.getDebt();
            if (debt == null) {
                debt = new Debt();
                ftmt.setDebt(debt);
            }
            debt.setAmount(new BigDecimal(form.getDebt()));
        } else {
            ftmt.setDebt(null);
        }
    }

    private void convertFormToSpouseFinancials(FinancialDetailsForm form, SpouseFinancials ftmt)
            throws Exception {
        SpouseFinancialInfoBean bean = form.getSpouseInfo();
        convertFormToSpouseFinancialAmounts(form, ftmt);

        ftmt.setLivedWithPatient(getBoolean(bean.getLivedWithVeteran()));
        
        // contributed to spouse indicator
        FinancialStatement statement = ftmt.getFinancialStatement();
        if (statement != null){
            statement.setContributedToSpouseInd(getBoolean(bean.getContributedToSpouseInd()));
        }
        
        // spousal support amt
        if (StringUtils.isNotEmpty(bean.getContributedToSupport())) {            
            if (statement != null)
                statement.setContributionToSpouse(new BigDecimal(bean.getContributedToSupport()));
        } else {
            
            if (statement != null)
                statement.setContributionToSpouse(null);
        }

        Spouse spouse = ftmt.getReportedOn();
        if (spouse != null) {
            spouse.setEndDate(DateUtils.getDate(bean.getInactiveDate()));

            if (StringUtils.isNotEmpty(bean.getMarriageDate()))
                spouse.setMarriageDate(DateUtils.getImpreciseDate(bean.getMarriageDate()));
            else
                spouse.setMarriageDate(null);

        }
    }

    private void setExpense(String amount, String expTypeCode, FinancialInformation ftmt) throws Exception {
        LookupCacheService lookupCacheService = getLookupCacheService();
        ExpenseType expType = (ExpenseType) lookupCacheService.getByCodeFromCache(ExpenseType.class,
                expTypeCode);
        if (StringUtils.isEmpty(amount)) {
            ftmt.setExpense(expType, null);
            return;
        }
        Expense exp = ftmt.getExpense(expType);
        if (exp == null) {
            exp = new Expense();
            ftmt.setExpense(expType, exp);
        }
        exp.setAmount(new BigDecimal(amount));
    }

    private void setIncome(String amount, String incomeTypeCode, FinancialInformation ftmt) throws Exception {
        LookupCacheService lookupCacheService = getLookupCacheService();
        IncomeType incomeType = (IncomeType) lookupCacheService.getByCodeFromCache(IncomeType.class,
                incomeTypeCode);
        if (StringUtils.isEmpty(amount)) {
            ftmt.setIncome(incomeType, null);
            return;
        }
        Income income = ftmt.getIncome(incomeType);
        if (income == null) {
            income = new Income();
            ftmt.setIncome(incomeType, income);
        }
        income.setAmount(new BigDecimal(amount));
    }

    private void setAsset(String amount, String assetTypeCode, FinancialInformation ftmt) throws Exception {
        LookupCacheService lookupCacheService = getLookupCacheService();
        AssetType assetType = (AssetType) lookupCacheService.getByCodeFromCache(AssetType.class,
                assetTypeCode);
        if (StringUtils.isEmpty(amount)) {
            ftmt.setAsset(assetType, null);
            return;
        }
        Asset asset = ftmt.getAsset(assetType);
        if (asset == null) {
            asset = new Asset();
            ftmt.setAsset(assetType, asset);
        }
        asset.setAmount(new BigDecimal(amount));
    }

    public void convertFormToSpouseFinancialAmounts(FinancialDetailsForm form, SpouseFinancials ftmt)
            throws Exception {
       // SpouseFinancialInfoBean bean = form.getSpouseInfo();
    	SpouseFinancialInfoBean bean = new SpouseFinancialInfoBean();
        boolean isAddAPerson = form.isAddAPerson();
        if (isAddAPerson){    
        	 setIncome(form.getSpouseTotalIncome(0), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT
                     .getName(), ftmt);
             setIncome(form.getSpouseOtherIncome(0), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), ftmt);
             setIncome(form.getSpouseIncomeFromRanch(0),
                     IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), ftmt);
             setIncome(form.getSpouseUSCivilServiceIncome(0), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), ftmt);
             setIncome(form.getSpouseInterestDividentAnuityIncome(0), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY
                     .getName(), ftmt);
             setIncome(form.getSpouseUnemploymentIncome(0), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(),
                     ftmt);
             setIncome(form.getSpouseSocialSecurityIncome(0), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), ftmt);
             setIncome(form.getSpouseMilitaryRetirementIncome(0), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(),
                     ftmt);
             setIncome(form.getSpouseRailroadRetirementIncome(0), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(),
                     ftmt);
             setIncome(form.getSpouseOtherRetirementIncome(0), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), ftmt);
             setIncome(form.getSpouseWorkersCompIncome(0), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), ftmt);

             // Asset
             setAsset(form.getSpouseCashAsset(0), AssetType.CODE_CASH.getName(), ftmt);
             setAsset(form.getSpouseRealAsset(0), AssetType.CODE_REAL_ESTATE.getName(), ftmt);
             setAsset(form.getSpouseOtherAsset(0), AssetType.CODE_OTHER.getName(), ftmt);
             setAsset(form.getSpouseStocksAsset(0), AssetType.CODE_STOCKS_AND_BONDS.getName(), ftmt);    
        }
        else { 
        	
	        bean = form.getSpouseInfo();
	        	
	        // Income
	        setIncome(bean.getTotalEmploymentIncome(), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT
	                .getName(), ftmt);
	        setIncome(bean.getOtherIncome(), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), ftmt);
	        setIncome(bean.getNetIncomeFromFarmRanchOrBusiness(),
	                IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), ftmt);
	        setIncome(bean.getUSCivilServiceIncome(), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), ftmt);
	        setIncome(bean.getInterestDividentAnuityIncome(), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY
	                .getName(), ftmt);
	        setIncome(bean.getUnemploymentIncome(), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(),
	                ftmt);
	        setIncome(bean.getSocialSecurityIncome(), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), ftmt);
	        setIncome(bean.getMilitaryRetirementIncome(), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(),
	                ftmt);
	        setIncome(bean.getRailroadRetirementIncome(), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(),
	                ftmt);
	        setIncome(bean.getOtherRetirementIncome(), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), ftmt);
	        setIncome(bean.getWorkersCompIncome(), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), ftmt);
	
	        // Asset
	        setAsset(bean.getCashAndBankAccountAsset(), AssetType.CODE_CASH.getName(), ftmt);
	        setAsset(bean.getRealPropertyAsset(), AssetType.CODE_REAL_ESTATE.getName(), ftmt);
	        setAsset(bean.getOtherPropertyAsset(), AssetType.CODE_OTHER.getName(), ftmt);
	        setAsset(bean.getStocksAsset(), AssetType.CODE_STOCKS_AND_BONDS.getName(), ftmt);
        }
        // Debt
        if (StringUtils.isNotEmpty(bean.getDebt())) {
            Debt debt = ftmt.getDebt();
            if (debt == null) {
                debt = new Debt();
                ftmt.setDebt(debt);
            }
            debt.setAmount(new BigDecimal(bean.getDebt()));
        } else {
            ftmt.setDebt(null);
        }
    }

    private void convertFormToDependentFinancials(FinancialDetailsForm form, int index,
            DependentFinancials ftmt) throws Exception {
        convertFormToDependentFinancialAmounts(form, index, ftmt);

        form.setDepFinacialsHashCode(index, String.valueOf(ftmt.hashCode()));

        ftmt.setLivedWithPatient(ConvertUtils.convertBoolean(form.getDepLivedWithPatient(index)));

        ftmt.setIncapableOfSelfSupport(ConvertUtils.convertBoolean(form.getDepIncapableOfSelfSupport(index)));

        ftmt.setHasIncome(ConvertUtils.convertBoolean(form.getDepHasIncome(index)));

        ftmt.setContributedToSupport(ConvertUtils.convertBoolean(form.getDepContributedToSupport(index)));

        ftmt.setAttendedSchool(ConvertUtils.convertBoolean(form.getDepAttendedSchool(index)));

        ftmt.setIncomeAvailableToPatient(ConvertUtils.convertBoolean(form
                .getDepIncomeAvailableToPatient(index)));

        if (StringUtils.isNotEmpty(form.getDepAmtContributed(index))) {
            ftmt.setAmountContributedToSupport(new BigDecimal(form.getDepAmtContributed(index)));
        } else {
            ftmt.setAmountContributedToSupport(null);
        }

        // TODO: read-only can not be changed by user?
        // ftmt.setValidDependent(ConvertUtils.convertBoolean(form.getDepValid(index)));

        Dependent dependent = ftmt.getReportedOn();
        if (dependent != null) {
            dependent.setEndDate(DateUtils.getDate(form.getDepInactiveDate(index)));

            if (StringUtils.isNotEmpty(form.getDepEffectiveDate(index)))
                dependent.setStartDate(DateUtils.getImpreciseDate(form.getDepEffectiveDate(index)));
            else
                dependent.setStartDate(null);

        }

    }

    private void convertFormToDependentFinancialAmounts(FinancialDetailsForm form, int index,
            DependentFinancials ftmt) throws Exception {
        // Income
        setIncome(form.getDepTotalIncome(index), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT
                .getName(), ftmt);
        setIncome(form.getDepOtherIncome(index), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(),
                ftmt);
        setIncome(form.getDepIncomeFromRanch(index),
                IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), ftmt);
        setIncome(form.getDepUSCivilServiceIncome(index), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(),
                ftmt);
        setIncome(form.getDepInterestDividentAnuityIncome(index),
                IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName(), ftmt);
        setIncome(form.getDepUnemploymentIncome(index), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION
                .getName(), ftmt);
        setIncome(form.getDepSocialSecurityIncome(index), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(),
                ftmt);
        setIncome(form.getDepMilitaryRetirementIncome(index), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT
                .getName(), ftmt);
        setIncome(form.getDepRailroadRetirementIncome(index), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT
                .getName(), ftmt);
        setIncome(form.getDepOtherRetirementIncome(index), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(),
                ftmt);
        setIncome(form.getDepWorkersCompIncome(index), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG
                .getName(), ftmt);

        // Expense
        setExpense(form.getDepEduExpenses(index), ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT
                .getName(), ftmt);

        // Asset
        setAsset(form.getDepCashAsset(index), AssetType.CODE_CASH.getName(), ftmt);
        setAsset(form.getDepRealAsset(index), AssetType.CODE_REAL_ESTATE.getName(), ftmt);
        setAsset(form.getDepOtherAsset(index), AssetType.CODE_OTHER.getName(), ftmt);
        setAsset(form.getDepStocksAsset(index), AssetType.CODE_STOCKS_AND_BONDS.getName(), ftmt);

        /*
         * Debt if(StringUtils.isNotEmpty(form.getDepDebts(index))) { Debt debt =
         * ftmt.getDebt(); if(debt == null) { debt = new Debt();
         * ftmt.setDebt(debt); } debt.setAmount(new
         * BigDecimal(form.getDepDebts(index))); }
         */
    }

    public List getDependentInfoList(FinancialStatement ftmt) throws Exception {
        List depInfoList = new ArrayList();
        Set spouseFinancials = ftmt.getSpouseFinancials();
        for(Iterator iter=spouseFinancials.iterator(); iter.hasNext();) {
            SpouseFinancials sf = (SpouseFinancials)iter.next();
            SpouseFinancialInfoBean sbean = new SpouseFinancialInfoBean();
            convertSpouseFinancialsToBean(sf, sbean);
            //If the SSN field is not present set it as unknown for displaying the link body.
            if(StringUtils.isEmpty(sbean.getDisplaySSN())) sbean.setDisplaySSN(UIConstants.UNKNOWN);
            
            // add contributed to spouse indicator for display.
            sbean.setContributedToSpouseInd(getYesNoNoData(ftmt.getContributedToSpouseInd()));
            depInfoList.add(sbean);
        }

        Set dependentFinancials = ftmt.getDependentFinancials();
        for(Iterator iter = dependentFinancials.iterator(); iter.hasNext();) {
            DependentFinancials df = (DependentFinancials) iter.next();
            DependentFinancialInfoBean bean = new DependentFinancialInfoBean();
            convertDependentFinancialsToBean(df, bean);
            //If the SSN field is not present set it as unknown for displaying the link body.
            if(StringUtils.isEmpty(bean.getDisplaySSN())) bean.setDisplaySSN(UIConstants.UNKNOWN);
            depInfoList.add(bean);
        }
        return depInfoList;
    }

    public CommonFinancialDetailsConversionService getCommonDetailsConversionService() {
        return commonDetailsConversionService;
    }

    public void setCommonDetailsConversionService(
            CommonFinancialDetailsConversionService commonDetailsConversionService) {
        this.commonDetailsConversionService = commonDetailsConversionService;
    }

    public FinancialsDependentConversionService getDependentConversionService() {
        return dependentConversionService;
    }

    public void setDependentConversionService(
            FinancialsDependentConversionService dependentConversionService) {
        this.dependentConversionService = dependentConversionService;
    }

    public void convertBeanToDependentFinancials(DependentFinancialInfoBean bean, DependentFinancials depFins)
    throws Exception {
        dependentConversionService.convertBeanToDependentFinancials(bean, depFins);
    }
    
    public void convertBeanToSpouseFinancials(SpouseFinancialInfoBean bean, SpouseFinancials spFins)
    throws Exception {
        dependentConversionService.convertBeanToSpouseFinancials(bean, spFins);
   }
    
    
    protected void convertSpouseFinancialsToBean(SpouseFinancials spFins, SpouseFinancialInfoBean bean) {
        getCommonDetailsConversionService().convertSpouseFinancialsToBean(spFins, bean);
    }

    protected void convertDependentFinancialsToBean(DependentFinancials depFin, DependentFinancialInfoBean bean) {
        getCommonDetailsConversionService().convertDependentFinancialsToBean(depFin, bean);
       
    }
}