/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.facility.beans;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * @author Madhu Katikala (@user)
 */
public class FeeBasisProgramBean extends AbstractEntity {
	private static final long serialVersionUID = -3928447047659109525L;
    
    private String name = null;
	private String treatmentType = null;
	private Date authorizationFrom = null;
	private Date authorizationTo = null;
    private Date reportDate = null;
	
	public Date getAuthorizationFrom() {
		return authorizationFrom;
	}
	public void setAuthorizationFrom(Date authorizationFrom) {
		this.authorizationFrom = authorizationFrom;
	}
	public Date getAuthorizationTo() {
		return authorizationTo;
	}
	public void setAuthorizationTo(Date authorizationTo) {
		this.authorizationTo = authorizationTo;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getTreatmentType() {
		return treatmentType;
	}
	public void setTreatmentType(String treatmentType) {
		this.treatmentType = treatmentType;
	}
    public Date getReportDate() {
        return this.reportDate;
    }
    public void setReportDate(Date date) {
        this.reportDate = date;
    }
	protected void buildToString(ToStringBuilder builder) {
		builder.append("Program Name: " + name);		
		builder.append("TreatmentType Name: " + treatmentType);
		builder.append("Authorization From: " + authorizationFrom);
		builder.append("Authorization To: " + authorizationTo);
        builder.append("Report Date: " + reportDate);
    }
}
