/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.facility.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractEntity;

/**
 * @author DNS   KATIKM
 */
public class FacilityBean extends AbstractEntity implements Serializable, Comparable{
	
	private static final long serialVersionUID = 6997222544997858141L;
    
    private Boolean primaryTestFacility = Boolean.FALSE;
    private Boolean preferredFacility = Boolean.FALSE; 
    private List feeBasisInfoList = null;
    private List patientVisitSummaries = null;
    private VAFacility vaFacility = null;
    
	public FacilityBean() {
		super();
	}
	
	public FacilityBean(VAFacility vaFacility) {
		super();
		this.vaFacility = vaFacility;
	}
	public List getFeeBasisInfo() {
		return feeBasisInfoList;
	}

	public void setFeeBasisInfo(List feeBasisInfoList) {
		this.feeBasisInfoList = feeBasisInfoList;
	}

	public void addFeeBasis(FeeBasisProgramBean feeBasisProgramBean) {
		if (this.feeBasisInfoList == null) {
			this.feeBasisInfoList = new ArrayList ();
		}
		this.feeBasisInfoList.add(feeBasisProgramBean);
	}
	
	public List getPatientVisitSummaries() {
		//Sort and return the summaries based on the income year and last visit date
		if (patientVisitSummaries != null && patientVisitSummaries.size()>1) {
			Comparator comparator = new Comparator() 
			{
				public int compare(Object obj1, Object obj2) 
				{
					PatientVisitSummary summary1 = (PatientVisitSummary) obj1;
					PatientVisitSummary summary2 = (PatientVisitSummary) obj2;
					
					//Compare Income Years
					int order = FacilityBean.this.compareTo(summary1.getIncomeYear(), 
							summary2.getIncomeYear());
					
					//Compare Last visit dates
					return order == 0 ? FacilityBean.this.compareTo(summary1.getLastVisitDate(),
							summary2.getLastVisitDate()) : order;

				}	
			};
			Collections.sort(patientVisitSummaries, comparator);
		}
		//return the sorted summaries
		return patientVisitSummaries;
	}
	
	public void setPatientVisitSummaries(List patientVisitSummaries) {
		this.patientVisitSummaries = patientVisitSummaries;
	}
	
	public void addPatientVisitSummary(PatientVisitSummary patientVisitSummary) {
		if (this.patientVisitSummaries == null) 
			this.patientVisitSummaries = new ArrayList ();
		this.patientVisitSummaries.add(patientVisitSummary);
	}

	public VAFacility getVaFacility() {
		return vaFacility;
	}

	public void setVaFacility(VAFacility vaFacility) {
		this.vaFacility = vaFacility;
	}
	public Boolean getPreferredFacility() {
		return preferredFacility;
	}

	public void setPreferredFacility(Boolean preferredFacility) {
		this.preferredFacility = preferredFacility;
	}

	public Boolean getPrimaryTestFacility() {
		return primaryTestFacility;
	}

	public void setPrimaryTestFacility(Boolean primaryTestFacility) {
		this.primaryTestFacility = primaryTestFacility;
	}
	
	//Some explicit checks for nulls are not implemented as this is mainly used
	//for sorting in UI layer
	
	public int compareTo(Object o) {

		if (o == null) return 1;
		
		//Preferred Facility is listed first
		if (Boolean.TRUE.equals(preferredFacility))
			return 1;			
		
		if (!(o instanceof FacilityBean ))
			return 1;
		FacilityBean targetBean = (FacilityBean) o;
			
		return compareTo(getLastVisitDate(),targetBean.getLastVisitDate());					

	}
	/**
	 * Assuming that the patient visit summaries are stored and returned
	 * @return
	 */
	protected Date getLastVisitDate() {
		if (patientVisitSummaries != null && patientVisitSummaries.size() > 0) {
			
			//get the first record and return the date
			List visitSummaries = getPatientVisitSummaries();
			PatientVisitSummary patientVisitSummary = 
				(PatientVisitSummary)visitSummaries.get(0);
			return patientVisitSummary.getLastVisitDate();
		}
		else
			return null;
	}
	
	protected void buildToString(ToStringBuilder arg0) {
		// TODO Auto-generated method stub

	}
	
	//Compare Integers
	private int compareTo(Integer obj1, Integer obj2) {
		if (obj1 != null) {
			if (obj2 != null) {
				return obj1.compareTo(obj2);
			}
			else
				return 1;
		}
		else
			return obj2 == null ? 0 : 1;
	}
	
	//Compare Dates
	protected int compareTo(Date date1, Date date2) {
		if (date1 != null) {
			if (date2 != null) {
				return date1.compareTo(date2);
			}
			else
				return 1;
		}
		else
			return date2 == null ? 0 : 1;
	}	
}
