/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.egt.action;

// Java Classes
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes

// ESR Classes
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.fw.util.StringUtils;

/**
 * This struts action is used to support the Update EGT Setting page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EGTSettingUpdateAction extends EGTSettingAction
{
    /**
     * Default constructor.
     */
    public EGTSettingUpdateAction()
    {
        super();
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Convert the form to the specific one we need
        EGTSettingInfoForm egtForm = getScreenSpecificForm(form);

        // Get the EGT Setting ID to update
        String egtSettingId = egtForm.getEgtSettingId();
        if (StringUtils.isEmpty(egtSettingId))
        {
            throw new Exception("EGT Setting ID must not be null.");
        }

        // Get the EGT Setting from the session based on the requested ID.
        EGTSetting egtSetting = getEGTSettingByEntityKey(request,
            CommonEntityKeyFactory.createEGTSettingEntityKey(egtSettingId));
        if (egtSetting == null)
        {
            throw new Exception("Unable to obtain EGT Setting from Session with ID: " + egtSettingId);
        }

        // Convert the EGT Setting data to the form
        conversionService.convert(egtSetting, egtForm);

        // Return to the Update EGT Setting screen
        return mapping.findForward(FORWARD_EGT_SETTING_DISPLAY);
    }

    /**
     * Performs update processing.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward updateEGTSetting(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        updateEGTSettingImpl(mapping, form, request, response, false);

        // Forward to the overview page
        return mapping.findForward(FORWARD_EGT_SETTING_OVERVIEW_WITH_UPDATE_MESSAGE);
    }

    /**
     * Performs delete processing.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward disableEGTSetting(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        updateEGTSettingImpl(mapping, form, request, response, true);

        // Forward to the overview page
        return mapping.findForward(FORWARD_EGT_SETTING_OVERVIEW_WITH_DISABLE_MESSAGE);
    }

    /**
     * Performs update processing.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     * @param disableEgtSetting If true, the EGT Setting will be disabled.  Otherwise, it will be enabled.
     *
     * @throws Exception If there are any errors during processing.
     */
    public void updateEGTSettingImpl(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response, boolean disableEgtSetting) throws Exception
    {
        // Convert the form to the specific one we need
        EGTSettingInfoForm egtForm = getScreenSpecificForm(form);

        // Get the EGT Setting ID to update
        String egtSettingId = egtForm.getEgtSettingId();
        if (StringUtils.isEmpty(egtSettingId))
        {
            throw new Exception("EGT Setting ID must not be null.");
        }

        // Get the EGT Setting from the session based on the requested ID.
        EGTSetting egtSetting = getEGTSettingByEntityKey(request,CommonEntityKeyFactory.createEGTSettingEntityKey(egtSettingId));
        if (egtSetting == null)
        {
            throw new Exception("Unable to obtain EGT Setting from Session with ID: " + egtSettingId);
        }
        EGTSetting updatedEGTSetting = (EGTSetting)egtSetting.clone();

        // Convert the EGT Setting data from the form onto the Business Object when we're not
        // disabling the setting.
        if (!disableEgtSetting)
        {
            this.getConversionService().convert(egtForm, updatedEGTSetting);
        }
        updatedEGTSetting.setDisable(new Boolean(disableEgtSetting));

        // Update the setting
        getEgtService().updateEGTSetting(updatedEGTSetting);
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = super.getKeyMethodMap();
        map.put("button.update", "updateEGTSetting");
        map.put("button.disable", "disableEGTSetting");
        map.put("button.display", "display");
        return map;
    }
}