/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.egt.action;

// Java Classes
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import net.mlw.vlh.ValueList;

// Framework Classes

// ESR Classes

/**
 * This struts action is used to support the EGT Setting Overview page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EGTSettingOverviewAction extends EGTSettingAction
{
    /**
     * Default constructor.
     */
    public EGTSettingOverviewAction()
    {
        super();
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        return displayImpl(mapping, form, request, response, true);
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward displayWithoutRefresh(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        return displayImpl(mapping, form, request, response, true);
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     * @param refreshData If true, the EGT setting data will be refreshed.  Otherwise, not.
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    protected ActionForward displayImpl(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response, boolean refreshData) throws Exception
    {
        // Get the current EGT Settings from the session
        EGTSetting currentEGTSetting = getCurrentEGTSetting(request);

        // Refresh the data if needed or requested and place it in the session
        if ((currentEGTSetting == null) || (refreshData))
        {
            refreshEGTSettings(request);
        }

        // Get the value list information from the future EGT Settings list
        ValueList valueList = ValueListActionUtils.getValueList(form,
            request, "futureEGTSettingsTableId", "futureEGTSettingsAdapter", getFutureEGTSettings(request));

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils.setValueList(request, valueList, "vlhlist");

        // Return to the EGT Setting Overview screen
        return mapping.findForward(FORWARD_EGT_SETTING_DISPLAY);
    }

    /**
     * Stops EGT batch job processing.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward stopEGTProcessing(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Stop the EGT batch processing with a newly added EGT Setting
        EGTSetting currentEGTSetting = getEgtService().stopEGTProcessing();

        // Store the updated current EGT Setting in the session.  This version contains any
        // updated statistics
        setCurrentEGTSetting(request, currentEGTSetting);

        // Return to the EGT Setting Overview screen with a stop message
        return mapping.findForward(FORWARD_EGT_SETTING_OVERVIEW_WITH_STOP_MESSAGE);
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = super.getKeyMethodMap();
        map.put("button.display", "display");
        map.put("button.egt.displayWithoutRefresh", "displayWithoutRefresh");
        map.put("button.egt.stopEGTProcessing", "stopEGTProcessing");
        return map;
    }
}