/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.egt.action;

// Java Classes
import javax.servlet.http.HttpServletRequest;

// Library Classes
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;

// ESR Classes

/**
 * This is the form used in conjunction with the EGT Setting pages.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EGTSettingInfoForm extends AbstractForm
{
    private static final long serialVersionUID = -731313370593345717L;
    
    private String egtSettingId;
    private String egtType;
    private String egtPriorityGroup;
    private String egtPrioritySubGroup;
    private String egtEffectiveDate;
    private String federalRegisterDate;
    private String comments;

    /**
     * Default constructor.
     */
    public EGTSettingInfoForm()
    {
        super();
        initialize();
    }

    /**
     * Resets all the form data to null.
     */
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }

    /**
     * Initializes the data on this form.
     */
    protected void initialize()
    {
        egtSettingId = null;
        egtType = null;
        egtPriorityGroup = null;
        egtPrioritySubGroup = null;
        egtEffectiveDate = null;
        federalRegisterDate = null;
        comments = null;
    }

    public String getEgtSettingId()
    {
        return egtSettingId;
    }

    public void setEgtSettingId(String egtSettingId)
    {
        this.egtSettingId = egtSettingId;
    }

    public String getEgtType()
    {
        return EGTSettingType.CODE_ENROLLMENT_DECISION.getCode();
    }

    public void setEgtType(String egtType)
    {
        //this.egtType = egtType;
    }

    public String getEgtPriorityGroup()
    {
        return egtPriorityGroup;
    }

    public void setEgtPriorityGroup(String egtPriorityGroup)
    {
        this.egtPriorityGroup = egtPriorityGroup;
    }

    /**
     * Returns the EGT Priority Sub Group.  However, if the EGT Type is 'Enrollment Decision' and the
     * EGT Priority is 7 or 8, then this method will always return a value of 'c'.  This is being
     * enforced on the GUI, but is also enforced here since the Javascript may be disabled.
     * @return the EGT Priority Sub Group
     */
    public String getEgtPrioritySubGroup()
    {
    	String prioritySubGroup=egtPrioritySubGroup;
        if ((egtType != null) && (egtType.equals(EGTSettingType.CODE_ENROLLMENT_DECISION.getName())) &&
            (egtPriorityGroup != null)){
        	if((egtPriorityGroup.equals(EnrollmentPriorityGroup.GROUP_7.getName()))){ 
        		prioritySubGroup= EnrollmentPrioritySubGroup.SUBGROUP_C.getName();
        	}else if(egtPriorityGroup.equals(EnrollmentPriorityGroup.GROUP_8.getName())){
        		prioritySubGroup= EnrollmentPrioritySubGroup.SUBGROUP_D.getName();	
        	}
        }
        return prioritySubGroup;
    }

    public void setEgtPrioritySubGroup(String egtPrioritySubGroup)
    {
        this.egtPrioritySubGroup = egtPrioritySubGroup;
    }

    // Used for JSP hidden field
    public String getEgtPrioritySubGroupHidden()
    {
        return getEgtPrioritySubGroup();
    }

    // Used for JSP hidden field
    public void setEgtPrioritySubGroupHidden(String egtPrioritySubGroup)
    {
        setEgtPrioritySubGroup(egtPrioritySubGroup);
    }

    public String getEgtEffectiveDate()
    {
        return egtEffectiveDate;
    }

    public void setEgtEffectiveDate(String egtEffectiveDate)
    {
        this.egtEffectiveDate = egtEffectiveDate;
    }

    public String getFederalRegisterDate()
    {
        return federalRegisterDate;
    }

    public void setFederalRegisterDate(String federalRegisterDate)
    {
        this.federalRegisterDate = federalRegisterDate;
    }

    public String getComments()
    {
        return comments;
    }

    public void setComments(String comments)
    {
        this.comments = comments;
    }
}
