/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.egt.action;

// Java Classes
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes

// ESR Classes
import gov.va.med.esr.common.model.ee.EGTSetting;

/**
 * This struts action is used to support the Add EGT Setting page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EGTSettingAddAction extends EGTSettingAction
{
    /**
     * Default constructor.
     */
    public EGTSettingAddAction()
    {
        super();
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Return to the Add EGT Setting screen
        return mapping.findForward(FORWARD_EGT_SETTING_DISPLAY);
    }

    /**
     * Performs add processing.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward addEGTSetting(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Convert the form to the specific one we need
        EGTSettingInfoForm egtForm = getScreenSpecificForm(form);

        // Create a new egt setting and populate it with the data from the form
        EGTSetting egtSetting = new EGTSetting();
        this.getConversionService().convert(egtForm, egtSetting);

        // Persist the new EGT Setting
        this.getEgtService().updateEGTSetting(egtSetting);

        // Forward to the overview page
        return mapping.findForward(FORWARD_EGT_SETTING_OVERVIEW_WITH_ADD_MESSAGE);
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = super.getKeyMethodMap();
        map.put("button.add", "addEGTSetting");
        map.put("button.display", "display");
        return map;
    }
}