package gov.va.med.esr.ui.ee.action;

// Java Classes
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.util.StringUtils;

// ESR Classes
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.ui.common.action.AbstractAction;

/**
 * Looks up a disability description based on a code.
 *
 * @author DNS   CHENB
 * @author Andrew Pach
 */
public class RatedDisabilityCodeLookupAction extends AbstractAction
{
    public static final String DISABILITY_CODE = "disabilityCode";
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String CODE_LOOKUP_START = "<codeLookup>";
    public static final String CODE_LOOKUP_END = "</codeLookup>";
    public static final String CODE_START = "<key>";
    public static final String CODE_END = "</key>";
    public static final String FIELD_START = "<field>";
    public static final String FIELD_END = "</field>";
    public static final String INVALID_START = "<codeNotFound>";
    public static final String INVALID_END = "</codeNotFound>";
    public static final String DESC_START = "<value>";
    public static final String DESC_END = "</value>";

    /**
     * Default constructor.
     */
    public RatedDisabilityCodeLookupAction()
    {
        super();
    }

    /**
     * Performs the disability code description lookup.
     * @param mapping The ActionMapping.
     * @param form The ActionForm.
     * @param request The HttpServletRequest.
     * @param response The HttpServletResponse
     * @return The ActionForward
     * @throws Exception if any problems were encountered.
     */
    public ActionForward lookup(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception
    {
        String param = request.getParameter(DISABILITY_CODE);
        int div = param.indexOf(":");
        String disabilityCode = param.substring(0, div);
        String field = param.substring(div + 1);

        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);

        if (StringUtils.isNotEmpty(disabilityCode))
        {
            // Default to an invalid code
            String name = "Invalid Rated Disability Code";
            boolean invalid = true;

            // Lookup the code and see if it is valid
            Disability dis = (Disability)getLookupCacheService().getByCodeFromCache(Disability.class, disabilityCode);
            if (dis != null)
            {
                name = dis.getName();
                invalid = false;
            }

            // Build the response details
            xml.append(CODE_LOOKUP_START);
            xml.append(FIELD_START);
            xml.append(field);
            xml.append(FIELD_END);
            xml.append(CODE_START);
            xml.append(disabilityCode);
            xml.append(CODE_END);
            xml.append(DESC_START);
            xml.append(name);
            xml.append(DESC_END);
            if (invalid)
            {
                xml.append(INVALID_START);
                xml.append(INVALID_END);
            }
            xml.append(CODE_LOOKUP_END);
        }

        xml.append(ROOT_ELEMENT_END);

        // Write the XML to response
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml.toString());
        out.flush();

        return null;
    }

    /**
     * Called after Spring properties have been set.
     * @throws Exception if any problems were encountered.
     */
    public void afterPropertiesSet() throws Exception
    {
    }
}
