/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.ee.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

import gov.va.med.fw.ui.struts.AbstractForm;

public class PurpleHeartForm extends AbstractForm {

    private static final long serialVersionUID = 7657844502527612219L;
    //person update status
    private boolean identityTraitUpdatePending = false;
    private String returnLink = null;
    //common fields
    private String facility = null;
    private String statusUpdateDate = null;    
    private String statusEffectiveDate = null; //?? screen only has update date
    private String assignedContactUser = null; //user id
    private String assignedContactUserName = null; //user name to be displayed
    private String rejectionRemark = null;
    private String purpleHeartStatus = null;
    //this is only set while adding a new document
    private String newAssignedContactUser = null;
        
    /* UI items for VOA Attachments */
    private String voaHiddenId;

    private String activeVOARowID;
    
    //current document - we are expected to have only one current document
    private String currentDocId = null;
    private String currentDocDocumentType = null;
    private String currentDocDataSource = null;
    private String currentDocReceivedDate = null;
    private String currentDocLoginDate = null;
    private String currentDocloggedInUser = null;
    private String currentDocAcceptable = null;
    private String currentDocUnacceptableRemarks = null;
    
    //new document
    private Boolean newDocument = null;
    private String newDocDocumentType = null;
    private String newDocDataSource = null;
    private String newDocReceivedDate = null;
    private String newDocLoginDate = null;
    private String newDocloggedInUser = null;
    private String newDocAcceptable = null;
    private String newDocUnacceptableRemarks = null;
    
    private String lastUpdateUserId = null;
    private String lastUpdateDate = null;
    
    private List voaAttachments = new ArrayList();  
    
    public PurpleHeartForm() {
        super();
        initialize();
    }
        
    public boolean getIdentityTraitUpdatePending() {
        return identityTraitUpdatePending;
    }

    public void setIdentityTraitUpdatePending(boolean identityTraitUpdatePending) {
        this.identityTraitUpdatePending = identityTraitUpdatePending;
    }

    public String getAssignedContactUser() {
        return assignedContactUser;
    }

    public String getAssignedContactUserName() {
        return assignedContactUserName;
    }

    public String getCurrentDocAcceptable() {
        return currentDocAcceptable;
    }
    
    public String getCurrentDocDataSource() {
        return currentDocDataSource;
    }

    public String getCurrentDocDocumentType() {
        return currentDocDocumentType;
    }

    public String getCurrentDocId() {
        return currentDocId;
    }

    public String getCurrentDocloggedInUser() {
        return currentDocloggedInUser;
    }

    public String getCurrentDocLoginDate() {
        return currentDocLoginDate;
    }

    public String getCurrentDocReceivedDate() {
        return currentDocReceivedDate;
    }

    public String getCurrentDocUnacceptableRemarks() {
        return currentDocUnacceptableRemarks;
    }

    public String getFacility() {
        return facility;
    }

    public String getNewDocAcceptable() {
        return newDocAcceptable;
    }

    public String getNewDocDataSource() {
        return newDocDataSource;
    }

    public String getNewDocDocumentType() {
        return newDocDocumentType;
    }

    public String getNewDocloggedInUser() {
        return newDocloggedInUser;
    }

    public String getNewDocLoginDate() {
        return newDocLoginDate;
    }

    public String getNewDocReceivedDate() {
        return newDocReceivedDate;
    }

    public String getNewDocUnacceptableRemarks() {
        return newDocUnacceptableRemarks;
    }

    public String getPurpleHeartStatus() {
        return purpleHeartStatus;
    }

    public String getRejectionRemark() {
        return rejectionRemark;
    }

    public String getStatusEffectiveDate() {
        return statusEffectiveDate;
    }

    public String getStatusUpdateDate() {
        return statusUpdateDate;
    }

    public void setAssignedContactUser(String assignedContactUser) {
        this.assignedContactUser = assignedContactUser;
    }

    public void setAssignedContactUserName(String assignedContactUserName) {
        this.assignedContactUserName = assignedContactUserName;
    }

    public void setCurrentDocAcceptable(String currentDocAcceptable) {
        this.currentDocAcceptable = currentDocAcceptable;
    }

    public void setCurrentDocDataSource(String currentDocDataSource) {
        this.currentDocDataSource = currentDocDataSource;
    }

    public void setCurrentDocDocumentType(String currentDocDocumentType) {
        this.currentDocDocumentType = currentDocDocumentType;
    }

    public void setCurrentDocId(String currentDocId) {
        this.currentDocId = currentDocId;
    }

    public void setCurrentDocloggedInUser(String currentDocloggedInUser) {
        this.currentDocloggedInUser = currentDocloggedInUser;
    }

    public void setCurrentDocLoginDate(String currentDocLoginDate) {
        this.currentDocLoginDate = currentDocLoginDate;
    }

    public void setCurrentDocReceivedDate(String currentDocReceivedDate) {
        this.currentDocReceivedDate = currentDocReceivedDate;
    }

    public void setCurrentDocUnacceptableRemarks(
            String currentDocUnacceptableRemarks) {
        this.currentDocUnacceptableRemarks = currentDocUnacceptableRemarks;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public void setNewDocAcceptable(String newDocAcceptable) {
        this.newDocAcceptable = newDocAcceptable;
    }

    public void setNewDocDataSource(String newDocDataSource) {
        this.newDocDataSource = newDocDataSource;
    }

    public void setNewDocDocumentType(String newDocDocumentType) {
        this.newDocDocumentType = newDocDocumentType;
    }

    public void setNewDocloggedInUser(String newDocloggedInUser) {
        this.newDocloggedInUser = newDocloggedInUser;
    }

    public void setNewDocLoginDate(String newDocLoginDate) {
        this.newDocLoginDate = newDocLoginDate;
    }

    public void setNewDocReceivedDate(String newDocReceivedDate) {
        this.newDocReceivedDate = newDocReceivedDate;
    }

    public void setNewDocUnacceptableRemarks(String newDocUnacceptableRemarks) {
        this.newDocUnacceptableRemarks = newDocUnacceptableRemarks;
    }

    public void setPurpleHeartStatus(String purpleHeartStatus) {
        this.purpleHeartStatus = purpleHeartStatus;
    }

    public void setRejectionRemark(String rejectionRemark) {
        this.rejectionRemark = rejectionRemark;
    }

    public void setStatusEffectiveDate(String statusEffectiveDate) {
        this.statusEffectiveDate = statusEffectiveDate;
    }

    public void setStatusUpdateDate(String statusUpdateDate) {
        this.statusUpdateDate = statusUpdateDate;
    }

    public String getReturnLink() {
        return returnLink;
    }

    public void setReturnLink(String returnLink) {
        this.returnLink = returnLink;
    }

    public Boolean getNewDocument() {
        return newDocument;
    }

    public void setNewDocument(Boolean newDocumentStatus) {
        this.newDocument = newDocumentStatus;
    }

    public String getNewAssignedContactUser() {
        return newAssignedContactUser;
    }

    public void setNewAssignedContactUser(String newAssignedContactUserName) {
        this.newAssignedContactUser = newAssignedContactUserName;
    }

	public String getLastUpdateDate() {
		return this.lastUpdateDate;
	}
	
	public void setLastUpdateDate(String lastUpdateDate) {
		this.lastUpdateDate = lastUpdateDate;
	}

	public String getLastUpdateUserId() {
		return this.lastUpdateUserId;
	}
	
	public void setLastUpdateUserId(String lastUpdateUserId) {
		this.lastUpdateUserId = lastUpdateUserId;
	}

	private void initialize() {
        
        returnLink = null;
        identityTraitUpdatePending = false;
        facility = null;
        statusUpdateDate = null;    
        statusEffectiveDate = null; //?? screen only has update date
        assignedContactUser = null; //user id
        assignedContactUserName = null; //user name to be displayed
        rejectionRemark = null;
        purpleHeartStatus = null;
        newAssignedContactUser = null;
            
        //current document - we are expected to have only one current document
        currentDocId = null;
        currentDocDocumentType = null;
        currentDocDataSource = null;
        currentDocReceivedDate = null;
        currentDocLoginDate = null;
        currentDocloggedInUser = null;
        currentDocAcceptable = null;
        currentDocUnacceptableRemarks = null;
        
        //new document
        newDocument = null;
        newDocDocumentType = null;
        newDocDataSource = null;
        newDocReceivedDate = null;
        newDocLoginDate = null;
        newDocloggedInUser = null;
        newDocAcceptable = null;
        newDocUnacceptableRemarks = null;
        
        lastUpdateUserId = null;
        lastUpdateDate = null;
    }

    //form custom validation    
    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request) {
         return super.validateForm(mapping, request);
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        initialize();
    }
    public VOAAttahmentEditActionForm getVoaAttachment(int index)
    {
        // make sure that orderList is not null
        if(this.voaAttachments == null)
        {
            this.voaAttachments = new ArrayList();
        }
  
        // indexes do not come in order, populate empty spots
        while(index >= this.voaAttachments.size())
        {
            this.voaAttachments.add(new VOAAttahmentEditActionForm());
        }
  
        // return the requested item
        return (VOAAttahmentEditActionForm) voaAttachments.get(index);
    }

    public List getVoaAttachments(){
          return voaAttachments;
     }
     
    public void setVoaAttachments(List voaAttachments) {
        this.voaAttachments = voaAttachments;
    }
    
    public String getVoaHiddenId() {
        return voaHiddenId;
    }

    public void setVoaHiddenId(String voaHiddenId) {
        this.voaHiddenId = voaHiddenId;
    }
    public String getActiveVOARowID() {
        return activeVOARowID;
        
    }

    public void setActiveVOARowID(String activeVOARowID) {
        this.activeVOARowID = activeVOARowID;
    }
}
