/*
 * Created on Dec 16, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.ee.action;

// Java Classes
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// ESR Classes
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.util.DateUtils;


/**
 * Action to computer the number of days in captivity.
 */
public class PowCaptivityDaysAction extends AbstractAction
{
    public static final String DAYS = "days";
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String DAYS_LOOKUP_START = "<captivityDays>";
    public static final String DAYS_LOOKUP_END = "</captivityDays>";
    public static final String DAYS_START = "<days>";
    public static final String DAYS_END = "</days>";
    public static final String FIELD_START = "<field>";
    public static final String FIELD_END = "</field>";

    /**
     * Default constructor.
     */
    public PowCaptivityDaysAction()
    {
        super();
    }

    /**
     * Gets the number of days in captivity
     * @param mapping The action mapping
     * @param form The form
     * @param request The HttpServletRequest
     * @param response The HttpServletResponse
     * @return The action forward
     * @throws Exception if any problems were countered
     */
    public ActionForward getPowCaptivityDays(ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception
    {
        // Parse the parameter which is in the form of "fromDays:toDays;returnField"
        String param = request.getParameter(DAYS);
        int div = param.indexOf(":");
        String captureDate = param.substring(0, div);
        String rest = param.substring(div + 1);
        div = rest.indexOf(";");
        String releaseDate = rest.substring(0, div);
        String field = rest.substring(div + 1);

        // Build the return XML string
        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);

        try
        {
        	//ESR_CodeCR4764, Don't calculate days for any ImpreciseDate
            Date cDate = DateUtils.getDate(captureDate);
            Date rDate = DateUtils.getDate(releaseDate);
            Long totalDays = DateUtils.getDays(cDate, rDate);
            xml.append(DAYS_LOOKUP_START);
            xml.append(FIELD_START);
            xml.append(field);
            xml.append(FIELD_END);
            xml.append(DAYS_START);
            xml.append(totalDays);
            xml.append(DAYS_END);
            xml.append(DAYS_LOOKUP_END);
        }
        catch (Exception ex)
        {
            // Values may have been null or invalid since they just come from what
            // the user entered and no validation has yet occurred.  Just let this
            // go and don't return any days.
        }

        //Write the XML to response
        xml.append(ROOT_ELEMENT_END);

        // Output the response
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml.toString());
        out.flush();

        return null;
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception
    {
    }
}
