package gov.va.med.esr.ui.ee.action;

import gov.va.med.fw.ui.struts.AbstractForm;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

public class HealthBenefitPlanForm extends AbstractForm {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1863301786310782839L;

	// Available Health Benefit Plan list
	private List hbpCode = null;
	private List hbpDesc = null;
	private List hbpInd = null;
	private List hbpEditable = null;

	// Assigned Individual Health Benefit Plans
	private List assignedHbpCode = null;
	private List assignedHbpDesc = null;
	private List assignedHbpInd = null;
	private List assignedHbpLastUpdatedDate = null;
	private List assignedHbpEditable = null;

	public HealthBenefitPlanForm() {
		super();
		initialize();
	}

	private void initialize() {

		// Assigned Health Benefit Plans
		assignedHbpCode = new ArrayList();
		assignedHbpDesc = new ArrayList();
		assignedHbpInd = new ArrayList();
		assignedHbpLastUpdatedDate = new ArrayList();
		assignedHbpEditable = new ArrayList();

		// Available Health Benefit Plans
		hbpCode = new ArrayList();
		hbpDesc = new ArrayList();
		hbpInd = new ArrayList();
		hbpEditable = new ArrayList();
	}

	// form custom validation
	public ActionMessages validateForm(ActionMapping mapping,
			HttpServletRequest request) {
		return super.validateForm(mapping, request);
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		initialize();
	}

	public List getHbpCodeList() {
		return hbpCode;
	}

	public void setHbpCodeList(List hbpCode) {
		this.hbpCode = hbpCode;
	}

	public List getHbpDescList() {
		return hbpDesc;
	}

	public void setHbpDescList(List hbpDesc) {
		this.hbpDesc = hbpDesc;
	}

	public List getHbpIndList() {
		return hbpInd;
	}

	public List getHbpEditableList() {
		return hbpEditable;
	}

	public void setHbpIndList(List hbpInd) {
		this.hbpInd = hbpInd;
	}

	// index based access for the hbp list
	public String getHbpCode(int index) {
		return (String) hbpCode.get(index);
	}

	public void setHbpCode(int index, String value) {
		setElement(this.hbpCode, index, value);
		// Increase the size of the list for the check boxes
	}

	public String getHbpDesc(int index) {
		return (String) hbpDesc.get(index);
	}

	public void setHbpDesc(int index, String value) {
		setElement(this.hbpDesc, index, value);
	}

	public Boolean getHbpInd(int index) {
		// Increase the checkbox list size if it is not initialized
		setSize(this.hbpInd, index, Boolean.FALSE);
		return (Boolean) hbpInd.get(index);
	}

	public void setHbpInd(int index, Boolean value) {
		setSize(this.hbpInd, index, Boolean.FALSE);
		setElement(this.hbpInd, index, value);
	}

	public void setHbpEditable(int index, Boolean value) {
		setSize(this.hbpEditable, index, Boolean.TRUE);
		setElement(this.hbpEditable, index, value);
	}

	// Assigned List
	public List getAssignedHbpCodeList() {
		return assignedHbpCode;
	}

	public void setAssignedHbpCodeList(List assignedHbpCode) {
		this.assignedHbpCode = assignedHbpCode;
	}

	public List getAssignedHbpDescList() {
		return assignedHbpDesc;
	}

	public void setAssignedHbpDescList(List assignedHbpDesc) {
		this.assignedHbpDesc = assignedHbpDesc;
	}

	public List getAssignedHbpIndList() {
		return assignedHbpInd;
	}

	public void setAssignedHbpIndList(List assignedHbpInd) {
		this.assignedHbpInd = assignedHbpInd;
	}

	public List getAssignedHbpLastUpdatedDateList() {
		return assignedHbpLastUpdatedDate;
	}

	public List getAssignedHbpEditableList() {
		return assignedHbpEditable;
	}

	public void setAssignedHbpLastUpdatedDateList(
			List assignedHbpLastUpdatedDate) {
		this.assignedHbpLastUpdatedDate = assignedHbpLastUpdatedDate;
	}

	public String getAssignedHbpCode(int index) {
		return (String) assignedHbpCode.get(index);
	}

	public void setAssignedHbpCode(int index, String value) {
		setElement(this.assignedHbpCode, index, value);
	}

	public Boolean getAssignedHbpInd(int index) {
		// Increase the checkbox list size if it is not initialized
		setSize(this.assignedHbpInd, index, Boolean.FALSE);
		return (Boolean) assignedHbpInd.get(index);
	}

	public void setAssignedHbpInd(int index, Boolean value) {
		setSize(this.assignedHbpInd, index, Boolean.FALSE);
		setElement(this.assignedHbpInd, index, value);
	}

	public String getAssignedHbpDesc(int index) {
		return (String) assignedHbpDesc.get(index);
	}

	public void setAssignedHbpDesc(int index, String value) {
		setElement(this.assignedHbpDesc, index, value);
	}

	public String getAssignedHbpLastUpdatedDate(int index) {
		return (String) assignedHbpLastUpdatedDate.get(index);
	}

	public void setAssignedHbpLastUpdatedDate(int index, String value) {
		setElement(this.assignedHbpLastUpdatedDate, index, value);
	}

	/**
	 * Default the value to TRUE, which is editable.
	 * 
	 * @param index
	 * @param value
	 */
	public void setAssignedHbpEditable(int index, Boolean value) {
		setSize(this.assignedHbpEditable, index, Boolean.TRUE);
		setElement(this.assignedHbpEditable, index, value);
	}

}
