package gov.va.med.esr.ui.ee.action;

// Java Classes
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.service.ServiceConfigurationException;

// ESR Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.demographic.action.PersonAssociationInfoForm;
import gov.va.med.esr.ui.util.SessionManager;

/**
 * This struts action is used to support the Health Benefit Plans page.
 */
public class HealthBenefitPlanAction extends PersonAbstractAction
{
    // Struts forwards
    public static final String FORWARD_HEALTH_BENEFIT_EDIT = "editHealthBenefit";
 
    /**
     * Default constructor.
     */
    public HealthBenefitPlanAction()
    {
        super();
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
    }

    /**
     * Displays the Health Benefit Plans page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get a health benefit plans specific form
    	HealthBenefitPlanForm hbpForm = getHealthBenefitPlanForm(form);

        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        hbpForm.setAddAPerson(isAddAPerson);
        
        // Get the Person object from the cache
        Person person = getSelectedPerson(request);

        // Convert all the health benefit profile data to the form
        conversionService.convert(person, hbpForm);

        // Return to the health benefit plans screen
        return mapping.findForward(FORWARD_HEALTH_BENEFIT_EDIT);
    }

    /**
     * Handles an optimistic lock exception by resetting the form and redisplaying the page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	form.reset(mapping,request);
    	return display(mapping,form,request,response);
    }

    /**
     * Updates the contact number information.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward update(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	HealthBenefitPlanForm hbpForm = getHealthBenefitPlanForm(form);

        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        hbpForm.setAddAPerson(isAddAPerson);
        
        // Get the Person object from the cache
        Person person = getSelectedPerson(request);

        // Clone the person to make updates
        Person updatedPerson = (Person)person.clone();

        // Create some action forwards
        ActionForward successForward =
            new ActionForward(mapping.findForward(FWD_DISPLAY_UPDATE_MSG));

        // Convert the form data onto the updated Person object
        conversionService.convert(hbpForm, updatedPerson);

        if (!isAddAPerson)
        // Call service layer here
        	updatedPerson = getHealthBenefitPlanService().updateHealthBenefitPlan(updatedPerson);

        // Store updated person in the cache
        updateSelectedPerson(request, updatedPerson);

        // Return to the overview screen
        return successForward;

    }


    /**
     * Resets the data to its original state.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward clear(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	HealthBenefitPlanForm hbpForm = getHealthBenefitPlanForm(form);
    	hbpForm.reset(mapping, request);
        return display(mapping, form, request, response);
    }
    

    /**
     * Cancels screen.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward cancel(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
    	return mapping.findForward(FWD_CANCEL);
    }

    /**
     * Checks to ensure the passed in ActionForm is not null and of the correct type.
     *
     * @param form The struts form to check
     *
     * @return The passed in form type-casted to a HealthBenefitPlanForm
     * @throws ServiceConfigurationException if the form is null or of an incorrect type.
     */
    protected HealthBenefitPlanForm getHealthBenefitPlanForm(ActionForm form) throws ServiceConfigurationException
    {
        HealthBenefitPlanForm hbpForm =
            (form instanceof HealthBenefitPlanForm) ? (HealthBenefitPlanForm) form : null;
 
        if (hbpForm == null)
        {
            throw new ServiceConfigurationException("HealthBenefitPlanForm not properly configured.");
        }
        return hbpForm; 
    }

    
    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("title.displayHealthBenefitPlan", "display");
        map.put("button.cancel", "cancel");
        map.put("button.clear", "clear");
        map.put("button.update", "update");
        return map;
    }
} 