/*
 * Created on Nov 16, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.ee.action;

// Java Classes
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

// Library Classes
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.util.SessionManager;

/**
 * The struts form for the enrollment screen.
 *
 * @author DNS   chenb
 * @author Andrew Pach
 * @author Manvinder Singh
 */
public class EnrollmentForm extends AbstractForm
{
    private static final long serialVersionUID = -4795273810345133741L;

    private Person person = null;

    //validation support data
    private String birthDate;
    private String todayDate;
    private String deathDate;

    //Enrollment Module
    private EnrollmentCategory enrollCategory = null;
    private Date enrollmentDate = null; //  04/03/2001
    private EnrollmentStatus enrollmentStatus = null; //  Verified
    private EnrollmentSource enrollmentSource = null; //  HEC
    private String enrollmentPriority = null;
    private String initialEnrollmentPriority=null;
    private VAFacility facilityReceived = null; // St. Louis
    private VAFacility preferredFacility = null; //  St. Louis
    private Date enrollmentEffDate = null; //  04/03/2003
    private Date enrollmentEndDate = null; //  04/02/2003
    private String EGTPrioritySub = null; //  3a
    private String initialPrioritySub=null;
    private String EGTType = null; // Verified

    //Edit panel
    private String applicationDate = null;

    private String enrollCategoryCode = null;
    private String canceledDeclinedIndicator; //Yes, No, No data
    private String canceledDeclinedIndicatorCurrent; //Yes, No, No data
    private String canceledDeclinedEffectiveDate;
    private String canceledDeclinedReason;
    private String canceledDeclinedNotProcessedReason;
    private String canceledDeclinedRemarks;

    private String enrollmentOverride = null; //Yes, No
    private String enrollmentOverrideCurrent = null; //Yes, No
    private String enrollmentOverrideReason = null;
    private String enrollmentOverrideComment = null;

    //Additional ones for History Page
    private Date lastUpdate = null;
    private String sourceUpdate = null;

    private String signatureDate;
    private String applicationMethod;
    
    /**
     * @return Returns the birthDate.
     */
    public String getBirthDate()
    {
        return birthDate;
    }

    /**
     * @param birthDate The birthDate to set.
     */
    public void setBirthDate(String birthDate)
    {
        this.birthDate = birthDate;
    }

    /**
     * @return Returns the todayDate.
     */
    public String getTodayDate()
    {
        return todayDate;
    }

    /**
     * @param todayDate The todayDate to set.
     */
    public void setTodayDate(String todayDate)
    {
        this.todayDate = todayDate;
    }

    /**
     * @return Returns the deathDate.
     */
    public String getDeathDate()
    {
        return deathDate;
    }

    /**
     * @param deathDate The deathDate to set.
     */
    public void setDeathDate(String deathDate)
    {
        this.deathDate = deathDate;
    }

    /**
     * @return Returns the applicationDate.
     */
    public String getApplicationDate()
    {
        return applicationDate;
    }

    /**
     * @param applicationDate The applicationDate to set.
     */
    public void setApplicationDate(String applicationDate)
    {
        this.applicationDate = applicationDate;
    }

    /**
     * @return Returns the canceledDeclinedEffectiveDate.
     */
    public String getCanceledDeclinedEffectiveDate()
    {
        return canceledDeclinedEffectiveDate;
    }

    /**
     * @param canceledDeclinedEffectiveDate The canceledDeclinedEffectiveDate to set.
     */
    public void setCanceledDeclinedEffectiveDate(
        String canceledDeclinedEffectiveDate)
    {
        this.canceledDeclinedEffectiveDate = canceledDeclinedEffectiveDate;
    }

    /**
     * @return Returns the enrollCategoryCode.
     */
    public String getEnrollCategoryCode()
    {
        return enrollCategoryCode;
    }

    /**
     * @param enrollCategoryCode The enrollCategoryCode to set.
     */
    public void setEnrollCategoryCode(String enrollCategoryCode)
    {
        this.enrollCategoryCode = enrollCategoryCode;
    }

    /**
     * @return Returns the canceledDeclinedIndicatorCurrent.
     */
    public String getCanceledDeclinedIndicatorCurrent()
    {
        return canceledDeclinedIndicatorCurrent;
    }

    /**
     * @param canceledDeclinedIndicatorCurrent The canceledDeclinedIndicatorCurrent to set.
     */
    public void setCanceledDeclinedIndicatorCurrent(
        String canceledDeclinedIndicatorCurrent)
    {
        this.canceledDeclinedIndicatorCurrent = canceledDeclinedIndicatorCurrent;
    }

    /**
     * @return Returns the canceledDeclinedIndicator.
     */
    public String getCanceledDeclinedIndicator()
    {
        return canceledDeclinedIndicator;
    }

    /**
     * @param canceledDeclinedIndicator The canceledDeclinedIndicator to set.
     */
    public void setCanceledDeclinedIndicator(String canceledDeclinedIndicator)
    {
        this.canceledDeclinedIndicator = canceledDeclinedIndicator;
    }

    /**
     * @return Returns the canceledDeclinedNotProcessedReason.
     */
    public String getCanceledDeclinedNotProcessedReason()
    {
        return canceledDeclinedNotProcessedReason;
    }

    /**
     * @param canceledDeclinedNotProcessedReason The canceledDeclinedNotProcessedReason to set.
     */
    public void setCanceledDeclinedNotProcessedReason(
        String canceledDeclinedNotProcessedReason)
    {
        this.canceledDeclinedNotProcessedReason = canceledDeclinedNotProcessedReason;
    }

    /**
     * @return Returns the canceledDeclinedReason.
     */
    public String getCanceledDeclinedReason()
    {
        return canceledDeclinedReason;
    }

    /**
     * @param canceledDeclinedReason The canceledDeclinedReason to set.
     */
    public void setCanceledDeclinedReason(String canceledDeclinedReason)
    {
        this.canceledDeclinedReason = canceledDeclinedReason;
    }

    /**
     * @return Returns the canceledDeclinedRemarks.
     */
    public String getCanceledDeclinedRemarks()
    {
        return canceledDeclinedRemarks;
    }

    /**
     * @param canceledDeclinedRemarks The canceledDeclinedRemarks to set.
     */
    public void setCanceledDeclinedRemarks(String canceledDeclinedRemarks)
    {
        this.canceledDeclinedRemarks = canceledDeclinedRemarks;
    }

    /**
     * @return Returns the eGTPrioritySub.
     */
    public String getEGTPrioritySub()
    {
        return EGTPrioritySub;
    }

    /**
     * @param prioritySub The eGTPrioritySub to set.
     */
    public void setEGTPrioritySub(String prioritySub)
    {
        EGTPrioritySub = prioritySub;
    }

    /**
     * @return Returns the eGTType.
     */
    public String getEGTType()
    {
        return EGTType;
    }

    /**
     * @param type The eGTType to set.
     */
    public void setEGTType(String type)
    {
        EGTType = type;
    }

    /**
     * @return Returns the enrollCategory.
     */
    public EnrollmentCategory getEnrollCategory()
    {
        return enrollCategory;
    }

    /**
     * @param enrollCategory The enrollCategory to set.
     */
    public void setEnrollCategory(EnrollmentCategory enrollCategory)
    {
        this.enrollCategory = enrollCategory;
    }

    /**
     * @return Returns the enrollmentDate.
     */
    public Date getEnrollmentDate()
    {
        return enrollmentDate;
    }

    /**
     * @param enrollmentDate The enrollmentDate to set.
     */
    public void setEnrollmentDate(Date enrollmentDate)
    {
        this.enrollmentDate = enrollmentDate;
    }

    /**
     * @return Returns the enrollmentEffDate.
     */
    public Date getEnrollmentEffDate()
    {
        return enrollmentEffDate;
    }

    /**
     * @param enrollmentEffDate The enrollmentEffDate to set.
     */
    public void setEnrollmentEffDate(Date enrollmentEffDate)
    {
        this.enrollmentEffDate = enrollmentEffDate;
    }

    /**
     * @return Returns the enrollmentEndDate.
     */
    public Date getEnrollmentEndDate()
    {
        return enrollmentEndDate;
    }

    /**
     * @param enrollmentEndDate The enrollmentEndDate to set.
     */
    public void setEnrollmentEndDate(Date enrollmentEndDate)
    {
        this.enrollmentEndDate = enrollmentEndDate;
    }

    /**
     * @return Returns the enrollmentOverride.
     */
    public String getEnrollmentOverride()
    {
        return enrollmentOverride;
    }

    /**
     * @param enrollmentOverride The enrollmentOverride to set.
     */
    public void setEnrollmentOverride(String enrollmentOverride)
    {
        this.enrollmentOverride = enrollmentOverride;
    }

    /**
     * @return Returns the enrollmentOverrideCurrent.
     */
    public String getEnrollmentOverrideCurrent()
    {
        return enrollmentOverrideCurrent;
    }

    /**
     * @param enrollmentOverrideCurrent The enrollmentOverrideCurrent to set.
     */
    public void setEnrollmentOverrideCurrent(String enrollmentOverrideCurrent)
    {
        this.enrollmentOverrideCurrent = enrollmentOverrideCurrent;
    }

    /**
     * @return Returns the enrollmentOverrideComment.
     */
    public String getEnrollmentOverrideComment()
    {
        return enrollmentOverrideComment;
    }

    /**
     * @param enrollmentOverrideComment The enrollmentOverrideComment to set.
     */
    public void setEnrollmentOverrideComment(String enrollmentOverrideComment)
    {
        this.enrollmentOverrideComment = enrollmentOverrideComment;
    }

    /**
     * @return Returns the enrollmentOverrideReason.
     */
    public String getEnrollmentOverrideReason()
    {
        return enrollmentOverrideReason;
    }

    /**
     * @param enrollmentOverrideReason The enrollmentOverrideReason to set.
     */
    public void setEnrollmentOverrideReason(String enrollmentOverrideReason)
    {
        this.enrollmentOverrideReason = enrollmentOverrideReason;
    }

    /**
     * @return Returns the enrollmentPriority.
     */
    public String getEnrollmentPriority()
    {
        return enrollmentPriority;
    }

    /**
     * @param enrollmentPriority The enrollmentPriority to set.
     */
    public void setEnrollmentPriority(String enrollmentPriority)
    {
        this.enrollmentPriority = enrollmentPriority;
    }

    /**
     * @return Returns the enrollmentSource.
     */
    public EnrollmentSource getEnrollmentSource()
    {
        return enrollmentSource;
    }

    /**
     * @param enrollmentSource The enrollmentSource to set.
     */
    public void setEnrollmentSource(EnrollmentSource enrollmentSource)
    {
        this.enrollmentSource = enrollmentSource;
    }

    /**
     * @return Returns the enrollmentStatus.
     */
    public EnrollmentStatus getEnrollmentStatus()
    {
        return enrollmentStatus;
    }

    /**
     * @param enrollmentStatus The enrollmentStatus to set.
     */
    public void setEnrollmentStatus(EnrollmentStatus enrollmentStatus)
    {
        this.enrollmentStatus = enrollmentStatus;
    }

    /**
     * @return Returns the facilityReceived.
     */
    public VAFacility getFacilityReceived()
    {
        return facilityReceived;
    }

    /**
     * @param facilityReceived The facilityReceived to set.
     */
    public void setFacilityReceived(VAFacility facilityReceived)
    {
        this.facilityReceived = facilityReceived;
    }

    /**
     * @return Returns the person.
     */
    public Person getPerson()
    {
        return person;
    }

    /**
     * @param person The person to set.
     */
    public void setPerson(Person person)
    {
        this.person = person;
    }

    /**
     * @return Returns the preferredFacility.
     */
    public VAFacility getPreferredFacility()
    {
        return preferredFacility;
    }

    /**
     * @param preferredFacility The preferredFacility to set.
     */
    public void setPreferredFacility(VAFacility preferredFacility)
    {
        this.preferredFacility = preferredFacility;
    }


    /**
     * @return Returns the lastUpdate.
     */
    public Date getLastUpdate()
    {
        return lastUpdate;
    }

    /**
     * @param lastUpdate The lastUpdate to set.
     */
    public void setLastUpdate(Date lastUpdate)
    {
        this.lastUpdate = lastUpdate;
    }

    /**
     * @return Returns the sourceUpdate.
     */
    public String getSourceUpdate()
    {
        return sourceUpdate;
    }

    /**
     * @param sourceUpdate The sourceUpdate to set.
     */
    public void setSourceUpdate(String sourceUpdate)
    {
        this.sourceUpdate = sourceUpdate;
    }

    /**
     * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject()
    {
        return new Person();
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request)
    {
    	boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        
        ActionMessages messages = new ActionMessages();
        
        if(isAddAPerson){
        	if(StringUtils.isBlank(getApplicationDate())){
        		messages.add("applicationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Application Date is required"));        		
        	}
        	else{
        		if (!StringUtils.isBlank(getApplicationDate()) && (!StringUtils.isBlank(getDeathDate())) &&
        	            !DateUtils.isDateBetween(new ImpreciseDate(getApplicationDate()), null, new ImpreciseDate(getDeathDate())))
        	            messages.add("applicationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Application Date must be equal to or prior to the Date of Death"));        		
        	}
        }
        else{
        	if (!StringUtils.isBlank(getApplicationDate()) && (!StringUtils.isBlank(getDeathDate())) &&
                    !DateUtils.isDateBetween(new ImpreciseDate(getApplicationDate()), null, new ImpreciseDate(getDeathDate())))
                    messages.add("applicationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Application Date must be equal to or prior to the Date of Death"));
        	
        }
        return messages;
    }

    /**
     * Getter for Initial Enrollment Priority
     * @return
     */
	public String getInitialEnrollmentPriority() {
		return initialEnrollmentPriority;
	}

	/**
	 * Setter for Initial Enrollment Priority
	 * @param initialEnrollmentPriority
	 */
	public void setInitialEnrollmentPriority(String initialEnrollmentPriority) {
		this.initialEnrollmentPriority = initialEnrollmentPriority;
	}

	public void setSignatureDate(String date) {
		signatureDate = date;
	}
	
	public String getSignatureDate() {
		return signatureDate;
	}
	
	public void setApplicationMethod(String appMethod) {
		applicationMethod = appMethod;
	}
	
	public String getApplicationMethod() {
		return applicationMethod;
	}
	
}
