/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.ee.action;

import java.util.Date;

import gov.va.med.fw.conversion.ConversionServiceException;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonHelperService;

import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.common.service.LookupCacheService;


/**
 * @author DNS   KATIKM Conversion service for PersonOverviewForm and Person Object
 */
public class EnrollmentConversionService extends EligibilityEnrollmentConversionService
{
    public EnrollmentConversionService()
    {
        super();
    }

    protected void convertBean(Object source, Object target)
        throws ConversionServiceException
    {
        log.trace("EnrollmentConversionService postProcessConvert() is called.");
        PersonHelperService helper = getPersonHelperService();

        //convert the objects
        if (source instanceof Person && target instanceof EnrollmentForm)
        {
            Person person = (Person)source;
            EnrollmentForm formBean = (EnrollmentForm)target;

            formBean.setTodayDate(JspUtils.displayValue(new Date(), null));
            formBean.setDeathDate(JspUtils.displayValue(
                ((person.getDeathRecord() == null) ? null : person.getDeathRecord().getDeathDate()), null));
            formBean.setBirthDate(JspUtils.displayValue(
                ((person.getBirthRecord() == null) ? null : person.getBirthRecord().getBirthDate()), null));

            try
            {
                //populate data from the Person object
                //enrollment
            	EnrollmentCategory category = helper.getEnrollmentCategory(person);
                EnrollmentDetermination enroll = helper.getEnrollmentDetermination(person);
                formBean.setEnrollCategory(category);
                formBean.setEnrollmentStatus(helper.getEnrollmentStatus(person));

                formBean.setEnrollmentDate(getEnrollDate(enroll));
                formBean.setEnrollmentEffDate(getEnrollEffDate(enroll));
                formBean.setEnrollmentPriority(getEnrollmentPriority(enroll));
                formBean.setInitialEnrollmentPriority(getInitialEnrollmentPriority(enroll));
                formBean.setEnrollmentEndDate(getEnrollEndDate(enroll));
                formBean.setPreferredFacility(person.getMostRecentPreferredFacility());
                formBean.setEnrollmentSource(getEnrollmentSource(enroll));
                formBean.setFacilityReceived(getFacilityReceived(enroll));
                formBean.setEGTPrioritySub(getEGTPriority(person));
                formBean.setEGTType(getEGTType(person));

                formBean.setApplicationDate(
                    JspUtils.displayValue(getApplicationDate(person), null));
                formBean.setCanceledDeclinedIndicator(getCancelDeclineIndicator(person));
                formBean.setCanceledDeclinedIndicatorCurrent(getCancelDeclineIndicator(person));
                formBean.setEnrollCategoryCode((category != null)? category.getCode() : null);
                formBean.setCanceledDeclinedEffectiveDate(
                    JspUtils.displayValue(getCancelDeclineEffectiveDate(person), null));
                formBean.setCanceledDeclinedReason(getCancelDeclineReason(person));
                formBean.setCanceledDeclinedNotProcessedReason(
                    getCancelDeclineNotProcessedReason(person));
                formBean.setCanceledDeclinedRemarks(getCancelDeclineRemarks(person));
                //if indicator not yes or Reason is not Other, then delete remarks
                //WI# 191335
                if (!getCancelDeclineIndicator(person).equalsIgnoreCase("Y") || !getCancelDeclineReason(person).equalsIgnoreCase("4")) {
                	formBean.setCanceledDeclinedRemarks("");
                }
                formBean.setEnrollmentOverride(getEnrollmentOverrideInd(person));
                formBean.setEnrollmentOverrideCurrent(getEnrollmentOverrideInd(person));
                formBean.setEnrollmentOverrideReason(getEnrollmentOverrideReason(person));
                formBean.setEnrollmentOverrideComment(getEnrollmentOverrideComment(person));
                formBean.setSignatureDate(JspUtils.displayValue(getSignatureDate(person), null));
                formBean.setApplicationMethod(getApplicationMethod(person));
            }
            catch (Exception ex)
            {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        }
        else
            if (target instanceof Person && source instanceof EnrollmentForm)
            {
                LookupCacheService lookupCacheService = getLookupCacheService();
                Person person = (Person)target;
                EnrollmentForm formBean = (EnrollmentForm)source;

                try
                {
                    setApplicationDate(person, formBean.getApplicationDate());

                    //Canceled/Declined, always process Indicator forst to set object
                    setCancelDeclineIndicator(person, formBean.getCanceledDeclinedIndicator());
                    setCancelDeclineEffectiveDate(person,
                        formBean.getCanceledDeclinedEffectiveDate());
                    setCancelDeclineReason(person, (CancelDeclineReason)lookupCacheService.getByCodeFromCache(
                        CancelDeclineReason.class, formBean.getCanceledDeclinedReason()));
                    setCancelDeclineNotProcessedReason(person,
                        (CancelDeclineNotProcessedReason)lookupCacheService.getByCodeFromCache(
                            CancelDeclineNotProcessedReason.class, formBean.getCanceledDeclinedNotProcessedReason()));
                    setCancelDeclineRemarks(person, formBean.getCanceledDeclinedRemarks());
                    //if indicator not yes or Reason is not Other, then delete remark
                    //WI# 191335
                    if (!getCancelDeclineIndicator(person).equalsIgnoreCase("Y") || !getCancelDeclineReason(person).equalsIgnoreCase("4")) {
                    	setCancelDeclineRemarks(person, "");
                    }
                    //EnrollmentOverride, always process indicator first to set object
                    setEnrollmentOverrideInd(person, lookupCacheService, formBean.getEnrollmentOverride(), formBean.getEnrollmentOverrideCurrent());
                    setEnrollmentOverrideReason(person,
                            (EnrollmentOverrideReason)lookupCacheService.getByCodeFromCache(
                            EnrollmentOverrideReason.class, formBean.getEnrollmentOverrideReason()));
                    setEnrollmentOverrideComment(person, formBean.getEnrollmentOverrideComment());
                    setSignatureDate(person, formBean.getSignatureDate());
                    setApplicationMethod(person,
                    		(ApplicationMethod)lookupCacheService.getLookupService().getApplicationMethodByCode(formBean.getApplicationMethod()));
                }
                catch (Exception ex)
                {
                    throw new ConversionServiceException("Conversion Failed", ex);
                }

            }
            else
            {
                throw new ConversionServiceException("Type mismatch: Expecting Person, EnrollmentForm Received " +
                    source.getClass().getName() + " and " + target.getClass().getName());
            }
    }

}
