/*
 * Created on Dec 2, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.ee.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;

//Framework classes
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.Resources;

/**
 * @author DNS   ZHENGH
 *
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class EligibilityEditActionForm extends AbstractForm {

    private static final long serialVersionUID = -5010494002166429488L;

    public static final String FIELD_NAME_INELIGIBILE_DATE = "ineligibleDate";
    public static final String FIELD_LABEL_INELIGIBILE_DATE = "label.ineligibleDate";
    public static final String MESSAGE_KEY_INELIGIBILE_DATE_NOT_ALLOWED = "error.ineligibleDateNotAllowed";
    public static final String MESSAGE_KEY_INELIGIBILE_PRIOR_TO_SERVICEENTRY_DATE = "error.invalidIneligibilityDate";

    private String focusButton;

    private String deathDate;

	private String birthDate;

	private String todayDate;

	private String nefHiddenId;

	private String rdHiddenId;

	private String nveHiddenId;

	private String powHiddenId;

	private Integer addPOWSource;

	private String veteranIndicator;
    private String oldVeteranIndicator;

	private String enrollmentCategoryCode;

	private String eligibilityStatus;

	private Collection eligibilityStatusList;

	private String eligibilityStatusDate;

	private String oldEligibilityStatusDate;

	private String verificationMethod;

	private String eligStatusPendingVerficationReason;
	
	private String eligStatusPendingVerfReasonExplain;

	private String totalCheckAmount;

	private String totalMonthlyCheckAmount;

	private String serviceConnected;

	private String effectiveDateCombinedRating;

	private String oldEffectiveDateCombinedRating;

	private String applicationDate;

	private String isReceivingCompensation;

	private String vaPension;
	private String oldvaPension;

	private String housebound;

	private String aidAttendance;

	private String phStatus;

    /* UI items for VOA Attachments */
    private String voaHiddenId;

    private String activeVOARowID;

	private String powInd;

	private List powId;

	private List powConfinementLocation;

	private List powCaptureDate;

	private List powReleaseDate;

	private List powCaptivityDays;

	private List powSource;

	private List powDateEntered;

	private List powDocumentType;

	private List powCampLocation;

	private List powCampCode;

	private List powCampName;

	private List powCampCity;

	private String agentOrangeExposure;

	private String agentOrangeLocation;

	private String environmentalContaminationExposure;

	private String radiationExposure;

	private String radiationExposureMethod;

	private String dischargeDueDisability;

	private String disabilityRetirementIndicator;

	private String unemployable;

	private String permanentTotal;

	private String permanentTotalEffDate;

	private String ratedIncompetent;

	private String civilDate;

	private String vaDate;

	private String eligibleForMedicaid;

	private String medicaidUpdatedDate;

	private String serviceEntryDate;

	private String ineligibleDate;

	private String ineligibleReason;

	private String ineligibleVARODecision;

	private String claimFolderNumber;

	private String claimFolderLocation;

	private String preferredFacility;

	private String canceledDeclinedIndicator;

	private String canceledDeclinedEffectiveDate;

	private String canceledDeclinedReason;

	private String canceledDeclinedNotProcessedReason;

	private String canceledDeclinedRemarks;

	//Non-veteran Eligibility Codes
    private String periodOfService;

	private String tricare;

	private String sharingAgreement;

	private String alliedVeteranCountry;

	private String champa;

	private String employee;

	private String collateralOfVet;

	private String otherFederalAgency;

	private String[] campLejeuneVerificationMethods = {};
	private String[] resetCampLejeuneVerificationMethods = {};

	private List disabilityId;
	private List disabilityIdStrings;
	private int[] selectedDisabilityIndexes;

	private List disabilityCodes;

	private List disDescription;

	private List percentage;

	private List diagnosticExtremity;

	private List originalEffectiveDate;

	private List currentEffectiveDate;

	private List oldOriginalEffectiveDate;

	//used to validate user input is precise if it's diffent from old HL7 value
	private List oldCurrentEffectiveDate;

    /* A Place holder for VOA Attachments */
    private List voaAttachments = new ArrayList();

    // pension data group
    private String pensionAwardEffectiveDate;
    private String oldPensionAwardEffectiveDate;
    private String pensionAwardReasonCode;
    private String pensionAwardTerminationDate;
    private String oldPensionAwardTerminationDate;
    private String pensionAwardTerminationReasonCode1;
    private String pensionAwardTerminationReasonCode2;
    private String pensionAwardTerminationReasonCode3;
    private String pensionAwardTerminationReasonCode4;

    private String spinalCordInjury;
    private String noseThroatRadium;

    private String addedRatedDisability = "n";
////////////CLV///////////////////////
	private String campLejeuneInd;
	private String campLejeuneVerificationMethod;
	private String campLejeuneVerificationComments;
	private String campLejeuneChangeDate;
	private String campLejeuneChangeSite;
	private String campLejeuneChangeSource;
	private boolean campLejeuneDisabled;
	///////////CLV///////////////////////

    //set focus button
    public String getFocusButton()
    {
    	return focusButton;
    }

    public void setFocusButton(String focusButton) {
    	this.focusButton = focusButton;
    }

    public Integer getAddPOWSource() {
    	return addPOWSource;
    }

    public void setAddPOWSource(Integer addPOWSource) {
    	this.addPOWSource = addPOWSource;
    }


    public String getAddedRatedDisability() {
		return addedRatedDisability;
	}

	public void setAddedRatedDisability(String addedRatedDisability) {
		this.addedRatedDisability = addedRatedDisability;
	}


	//used to validate user input is precise if it's diffent from old HL7 value
	public EligibilityEditActionForm() {
	}

	/**
	 * @return Returns the deathDate.
	 */
	public String getDeathDate() {
		return deathDate;
	}

	/**
	 * @param deathDate
	 *            The deathDate to set.
	 */

	public void setDeathDate(String deathDate) {
		this.deathDate = deathDate;
	}

	/**
	 * @return Returns the birthDate.
	 */
	public String getBirthDate() {
		return birthDate;
	}

	/**
	 * @param birthDate
	 *            The birthDate to set.
	 */
	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}

	/**
	 * @return Returns the todayDate.
	 */
	public String getTodayDate() {
		return todayDate;
	}

	/**
	 * @param todayDate
	 *            The todayDate to set.
	 */
	public void setTodayDate(String todayDate) {
		this.todayDate = todayDate;
	}


	/**
	 * @return Returns the nefHiddenId.
	 */
	public String getNefHiddenId() {
		return nefHiddenId;
	}
	/**
	 * @param nefHiddenId The nefHiddenId to set.
	 */
	public void setNefHiddenId(String nefHiddenId) {
		this.nefHiddenId = nefHiddenId;
	}
	/**
	 * @return Returns the nveHiddenId.
	 */
	public String getNveHiddenId() {
		return nveHiddenId;
	}
	/**
	 * @param nveHiddenId The nveHiddenId to set.
	 */
	public void setNveHiddenId(String nveHiddenId) {
		this.nveHiddenId = nveHiddenId;
	}


	/**
	 * @return Returns the powHiddenId.
	 */
	public String getPowHiddenId() {
		return powHiddenId;
	}
	/**
	 * @param powHiddenId The powHiddenId to set.
	 */
	public void setPowHiddenId(String powHiddenId) {
		this.powHiddenId = powHiddenId;
	}
	/**
	 * @return Returns the rdHiddenId.
	 */
	public String getRdHiddenId() {
		return rdHiddenId;
	}
	/**
	 * @param rdHiddenId The rdHiddenId to set.
	 */
	public void setRdHiddenId(String rdHiddenId) {
		this.rdHiddenId = rdHiddenId;
	}

    /**
     * @return Returns the voaHiddenId.
     */
    public String getVoaHiddenId() {
        return voaHiddenId;
    }
    /**
     * @param voaHiddenId The voaHiddenId to set.
     */
    public void setVoaHiddenId(String voaHiddenId) {
        this.voaHiddenId = voaHiddenId;
    }
	/**
	 * @return Returns the veteranIndicator.
	 */
	public String getVeteranIndicator() {
		return veteranIndicator;
	}
	/**
	 * @param veteranIndicator The veteranIndicator to set.
	 */
	public void setVeteranIndicator(String veteranIndicator) {
		this.veteranIndicator = veteranIndicator;
	}

    /**
     * @return Returns the oldVeteranIndicator.
     */
    public String getOldVeteranIndicator() {
        return oldVeteranIndicator;
    }
    /**
     * @param veteranIndicator The oldVeteranIndicator to set.
     */
    public void setOldVeteranIndicator(String oldVeteranIndicator) {
        this.oldVeteranIndicator = oldVeteranIndicator;
    }

	/**
	 * @return Returns the enrollmentCategory.
	 */
	public String getEnrollmentCategoryCode() {
		return enrollmentCategoryCode;
	}

	/**
	 * @param enrollmentCategoryCode
	 *            The enrollmentCategory to set.
	 */
	public void setEnrollmentCategoryCode(String enrollmentCategoryCode) {
		this.enrollmentCategoryCode = enrollmentCategoryCode;
	}

	public void setVerificationMethod(String verificationMethod) {
		this.verificationMethod = verificationMethod;
	}

	public String getVerificationMethod() {
		return this.verificationMethod;
	}

	public void setServiceConnected(String serviceConnected) {
		this.serviceConnected = serviceConnected;
	}

	public String getServiceConnected() {
		return this.serviceConnected;
	}
	/**
	 * @return Returns the effectiveDateCombinedRating.
	 */
	public String getEffectiveDateCombinedRating() {
		return effectiveDateCombinedRating;
	}
	/**
	 * @param effectiveDateCombinedRating The effectiveDateCombinedRating to set.
	 */
	public void setEffectiveDateCombinedRating(String effectiveDateCombinedRating) {
		this.effectiveDateCombinedRating = effectiveDateCombinedRating;
	}

	/**
	 * @return Returns the oldEffectiveDateCombinedRating.
	 */
	public String getOldEffectiveDateCombinedRating() {
		return oldEffectiveDateCombinedRating;
	}
	/**
	 * @param oldEffectiveDateCombinedRating The oldEffectiveDateCombinedRating to set.
	 */
	public void setOldEffectiveDateCombinedRating(String oldEffectiveDateCombinedRating) {
		this.oldEffectiveDateCombinedRating = oldEffectiveDateCombinedRating;
	}

	/**
	 * @return Returns the applicationDate.
	 */
	public String getApplicationDate() {
		return applicationDate;
	}

	/**
	 * @param applicationDate
	 *            The applicationDate to set.
	 */
	public void setApplicationDate(String applicationDate) {
		this.applicationDate = applicationDate;
	}

	public void setVaPension(String vaPension) {
		this.vaPension = vaPension;
	}

	public String getVaPension() {
		return this.vaPension;
	}

	public void setHousebound(String housebound) {
		this.housebound = housebound;
	}

	public String getHousebound() {
		return this.housebound;
	}

	public void setAidAttendance(String aidAttendance) {
		this.aidAttendance = aidAttendance;
	}

	public String getAidAttendance() {
		return this.aidAttendance;
	}

	/**
	 * @return Returns the phStatus.
	 */
	public String getPhStatus() {
		return phStatus;
	}

	/**
	 * @param phStatus
	 *            The phStatus to set.
	 */
	public void setPhStatus(String phStatus) {
		this.phStatus = phStatus;
	}

	public void setPowInd(String powInd) {
		this.powInd = powInd;
	}

	public String getPowInd() {
		return this.powInd;
	}

	public List getPowCaptureDateList() {
		return powCaptureDate;
	}
	public void setPowCaptureDateList(List powCaptureDate) {
		this.powCaptureDate = powCaptureDate;
	}
	public String getPowCaptureDate(int index) {
		return (String) powCaptureDate.get(index);
	}
	public void setPowCaptureDate(int index, String powCaptureDate) {
		setElement(this.powCaptureDate, index, powCaptureDate);
	}

	public List getPowConfinementLocationList() {
		return powConfinementLocation;
	}
	public void setPowConfinementLocationList(List powConfinementLocation) {
		this.powConfinementLocation = powConfinementLocation;
	}
	public String getPowConfinementLocation(int index) {
		return (String) powConfinementLocation.get(index);
	}
	public void setPowConfinementLocation(int index, String powConfinementLocation) {
		setElement(this.powConfinementLocation, index, powConfinementLocation);
	}

	public List getPowReleaseDateList() {
		return powReleaseDate;
	}
	public void setPowReleaseDateList(List powReleaseDate) {
		this.powReleaseDate = powReleaseDate;
	}
	public String getPowReleaseDate(int index) {
		return (String) powReleaseDate.get(index);
	}
	public void setPowReleaseDate(int index, String powReleaseDate) {
		setElement(this.powReleaseDate, index, powReleaseDate);
	}

	//powCaptivityDays
	public List getPowCaptivityDaysList() {
		return powCaptivityDays;
	}
	public void setPowCaptivityDaysList(List powCaptivityDays) {
		this.powCaptivityDays = powCaptivityDays;
	}
	public String getPowCaptivityDays(int index) {
		return (String) powCaptivityDays.get(index);
	}
	public void setPowCaptivityDays(int index, String powCaptivityDays) {
		setElement(this.powCaptivityDays, index, powCaptivityDays);
	}

	//powSource
	public List getPowSourceList() {
		return powSource;
	}
	public void setPowSourceList(List powSource) {
		this.powSource = powSource;
	}
	public String getPowSource(int index) {
		return (String) powSource.get(index);
	}
	public void setPowSource(int index, String powSource) {
		setElement(this.powSource, index, powSource);
	}

	//powDateEntered;
	public List getPowDateEnteredList() {
		return powDateEntered;
	}
	public void setPowDateEnteredList(List powDateEntered) {
		this.powDateEntered = powDateEntered;
	}
	public String getPowDateEntered(int index) {
		return (String) powDateEntered.get(index);
	}
	public void setPowDateEntered(int index, String powDateEntered) {
		setElement(this.powDateEntered, index, powDateEntered);
	}

	//powDocumentType;
	public List getPowDocumentTypeList() {
		return powDocumentType;
	}
	public void setPowDocumentTypeList(List powDocumentType) {
		this.powDocumentType = powDocumentType;
	}
	public String getPowDocumentType(int index) {
		return (String) powDocumentType.get(index);
	}
	public void setPowDocumentType(int index, String powDocumentType) {
		setElement(this.powDocumentType, index, powDocumentType);
	}

	//powCampLocation;
	public List getPowCampLocationList() {
		return powCampLocation;
	}
	public void setPowCampLocationList(List powCampLocation) {
		this.powCampLocation = powCampLocation;
	}
	public String getPowCampLocation(int index) {
		return (String) powCampLocation.get(index);
	}
	public void setPowCampLocation(int index, String powCampLocation) {
		setElement(this.powCampLocation, index, powCampLocation);
	}

	//powCampCode;
	public List getPowCampCodeList() {
		return powCampCode;
	}
	public void setPowCampCodeList(List powCampCode) {
		this.powCampCode = powCampCode;
	}
	public String getPowCampCode(int index) {
		return (String) powCampCode.get(index);
	}
	public void setPowCampCode(int index, String powCampCode) {
		setElement(this.powCampCode, index, powCampCode);
	}

	//powCampName;
	public List getPowCampNameList() {
		return powCampName;
	}
	public void setPowCampNameList(List powCampName) {
		this.powCampName = powCampName;
	}
	public String getPowCampName(int index) {
		return (String) powCampName.get(index);
	}
	public void setPowCampName(int index, String powCampName) {
		setElement(this.powCampName, index, powCampName);
	}

	//powCampCity;
	public List getPowCampCityList() {
		return powCampCity;
	}
	public void setPowCampCityList(List powCampCity) {
		this.powCampCity = powCampCity;
	}
	public String getPowCampCity(int index) {
		return (String) powCampCity.get(index);
	}
	public void setPowCampCity(int index, String powCampCity) {
		setElement(this.powCampCity, index, powCampCity);
	}



	public void setUnemployable(String unemployable) {
		this.unemployable = unemployable;
	}

	public String getUnemployable() {
		return this.unemployable;
	}

	public void setPermanentTotal(String permanentTotal) {
		this.permanentTotal = permanentTotal;
	}

	public String getPermanentTotal() {
		return this.permanentTotal;
	}

	/**
	 * @return Returns the permanentTotalEffDate.
	 */
	public String getPermanentTotalEffDate() {
		return permanentTotalEffDate;
	}

	/**
	 * @param permanentTotalEffDate
	 *            The permanentTotalEffDate to set.
	 */
	public void setPermanentTotalEffDate(String permanentTotalEffDate) {
		this.permanentTotalEffDate = permanentTotalEffDate;
	}

	public void setRatedIncompetent(String ratedIncompetent) {
		this.ratedIncompetent = ratedIncompetent;
	}

	public String getRatedIncompetent() {
		return this.ratedIncompetent;
	}

	/**
	 * @return Returns the dischargeDueDisability.
	 */
	public String getDischargeDueDisability() {
		return dischargeDueDisability;
	}

	/**
	 * @param dischargeDueDisability
	 *            The dischargeDueDisability to set.
	 */
	public void setDischargeDueDisability(String dischargeDueDisability) {
		this.dischargeDueDisability = dischargeDueDisability;
	}

	public void setCivilDate(String civilDate) {
		this.civilDate = civilDate;
	}

	public String getCivilDate() {
		return this.civilDate;
	}

	public void setVaDate(String vaDate) {
		this.vaDate = vaDate;
	}

	public String getVaDate() {
		return this.vaDate;
	}

	public void setEligibleForMedicaid(String eligibleForMedicaid) {
		this.eligibleForMedicaid = eligibleForMedicaid;
	}

	public String getEligibleForMedicaid() {
		return this.eligibleForMedicaid;
	}

	public void setMedicaidUpdatedDate(String medicaidUpdatedDate) {
		this.medicaidUpdatedDate = medicaidUpdatedDate;
	}

	public String getMedicaidUpdatedDate() {
		return this.medicaidUpdatedDate;
	}

	/**
	 * @return Returns the serviceEntryDate.
	 */
	public String getServiceEntryDate() {
		return serviceEntryDate;
	}
	/**
	 * @param serviceEntryDate The serviceEntryDate to set.
	 */
	public void setServiceEntryDate(String serviceEntryDate) {
		this.serviceEntryDate = serviceEntryDate;
	}

	public void setIneligibleDate(String ineligibleDate) {
		this.ineligibleDate = ineligibleDate;
	}

	public String getIneligibleDate() {
		return this.ineligibleDate;
	}

	public void setIneligibleReason(String ineligibleReason) {
		this.ineligibleReason = ineligibleReason;
	}

	public String getIneligibleReason() {
		return this.ineligibleReason;
	}

	public void setIneligibleVARODecision(String ineligibleVARODecision) {
		this.ineligibleVARODecision = ineligibleVARODecision;
	}

	public String getIneligibleVARODecision() {
		return this.ineligibleVARODecision;
	}

	public void setClaimFolderNumber(String claimFolderNumber) {
		this.claimFolderNumber = claimFolderNumber;
	}

	public String getClaimFolderNumber() {
		return this.claimFolderNumber;
	}

	public void setClaimFolderLocation(String claimFolderLocation) {
		this.claimFolderLocation = claimFolderLocation;
	}

	public String getClaimFolderLocation() {
		return this.claimFolderLocation;
	}

	public void setPreferredFacility(String preferredFacility) {
		this.preferredFacility = preferredFacility;
	}

	public String getPreferredFacility() {
		return this.preferredFacility;
	}

	public void setCanceledDeclinedIndicator(String canceledDeclinedIndicator) {
		this.canceledDeclinedIndicator = canceledDeclinedIndicator;
	}

	public String getCanceledDeclinedIndicator() {
		return this.canceledDeclinedIndicator;
	}

	public void setCanceledDeclinedEffectiveDate(
			String canceledDeclinedEffectiveDate) {
		this.canceledDeclinedEffectiveDate = canceledDeclinedEffectiveDate;
	}

	public String getCanceledDeclinedEffectiveDate() {
		return this.canceledDeclinedEffectiveDate;
	}

	public void setCanceledDeclinedReason(String canceledDeclinedReason) {
		this.canceledDeclinedReason = canceledDeclinedReason;
	}

	public String getCanceledDeclinedReason() {
		return this.canceledDeclinedReason;
	}

	public void setCanceledDeclinedNotProcessedReason(
			String canceledDeclinedNotProcessedReason) {
		this.canceledDeclinedNotProcessedReason = canceledDeclinedNotProcessedReason;
	}

	public String getCanceledDeclinedNotProcessedReason() {
		return this.canceledDeclinedNotProcessedReason;
	}

	public void setCanceledDeclinedRemarks(String canceledDeclinedRemarks) {
		this.canceledDeclinedRemarks = canceledDeclinedRemarks;
	}

	public String getCanceledDeclinedRemarks() {
		return this.canceledDeclinedRemarks;
	}

	public void setEligibilityStatusDate(String eligibilityStatusDate) {
		this.eligibilityStatusDate = eligibilityStatusDate;
	}

	public String getEligibilityStatusDate() {
		return this.eligibilityStatusDate;
	}

	public void setTotalCheckAmount(String totalCheckAmount) {
		this.totalCheckAmount = totalCheckAmount;
	}

	public String getTotalCheckAmount() {
		return this.totalCheckAmount;
	}

	/**
	 * @return Returns the totalMonthlyCheckAmount.
	 */
	public String getTotalMonthlyCheckAmount() {
		return totalMonthlyCheckAmount;
	}

	/**
	 * @param totalMonthlyCheckAmount
	 *            The totalMonthlyCheckAmount to set.
	 */
	public void setTotalMonthlyCheckAmount(String totalMonthlyCheckAmount) {
		this.totalMonthlyCheckAmount = totalMonthlyCheckAmount;
	}

	public void setIsReceivingCompensation(String isReceivingCompensation) {
		this.isReceivingCompensation = isReceivingCompensation;
	}

	public String getIsReceivingCompensation() {
		return this.isReceivingCompensation;
	}

	public void setEligibilityStatus(String eligibilityStatus) {
		this.eligibilityStatus = eligibilityStatus;
	}

	public String getEligibilityStatus() {
		return this.eligibilityStatus;
	}

    public String getIsSpinalCordInjury() {
    	return spinalCordInjury;
    }

    public void setSpinalCordInjury(String spinalCordInjury) {
    	this.spinalCordInjury = spinalCordInjury;
    }

    public String getSpinalCordInjury() {
    	return spinalCordInjury;
    }

    public String getIsNoseThroatRadium() {
    	return noseThroatRadium;
     }
    public String getNoseThroatRadium() {
     	return noseThroatRadium;
    }

    public void setNoseThroatRadium(String radium) {
        noseThroatRadium = radium;
    }


    public String getAddAPerson() {
    	return "" + isAddAPerson();
    }

//	/**
//	 * @return Returns the eligibilityStatusList.
//	 */
//	public Collection getEligibilityStatusList() {
//		return eligibilityStatusList;
//	}
//
//	/**
//	 * @param eligibilityStatusList
//	 *            The eligibilityStatusList to set.
//	 */
//	public void setEligibilityStatusList(Collection eligibilityStatusList) {
//		this.eligibilityStatusList = eligibilityStatusList;
//	}

	public void setDisabilityCodesList(List disabilityCodes) {
		this.disabilityCodes = disabilityCodes;
	}
	public List getDisabilityCodesList() {
		return this.disabilityCodes;
	}
	public String getDisabilityCodes(int index) {
		return (String) disabilityCodes.get(index);
	}
	public void setDisabilityCodes(int index, String disabilityCodes) {
		setElement(this.disabilityCodes, index, disabilityCodes);
	}

	public List getDisDescriptionList() {
		return disDescription;
	}
	public void setDisDescriptionList(List disDescription) {
		this.disDescription = disDescription;
	}
	public String getDisDescription(int index) {
		return (String) disDescription.get(index);
	}
	public void setDisDescription(int index, String disDescription) {
		setElement(this.disDescription, index, disDescription);
	}

	public void setPercentageList(List percentage) {
		this.percentage = percentage;
	}
	public List getPercentageList() {
		return this.percentage;
	}
	public String getPercentage(int index) {
		return (String) percentage.get(index);
	}
	public void setPercentage(int index, String percentage) {
		setElement(this.percentage, index, percentage);
	}

	public List getDiagnosticExtremityList() {
		return diagnosticExtremity;
	}
	public void setDiagnosticExtremityList(List diagnosticExtremity) {
		this.diagnosticExtremity = diagnosticExtremity;
	}
	public String getDiagnosticExtremity(int index) {
		return (String)diagnosticExtremity.get(index);
	}
	public void setDiagnosticExtremity(int index, String diagnosticExtremity) {
        setElement(this.diagnosticExtremity, index, diagnosticExtremity);
	}

	public List getOriginalEffectiveDateList() {
		return originalEffectiveDate;
	}
	public void setOriginalEffectiveDateList(List originalEffectiveDate) {
		this.originalEffectiveDate = originalEffectiveDate;
	}
	public String getOriginalEffectiveDate(int index) {
		return (String)originalEffectiveDate.get(index);
	}
	public void setOriginalEffectiveDate(int index, String originalEffectiveDate) {
        setElement(this.originalEffectiveDate, index, originalEffectiveDate);
	}

	public List getOldOriginalEffectiveDateList() {
		return oldOriginalEffectiveDate;
	}
	public void setOldOriginalEffectiveDateList(List oldOriginalEffectiveDate) {
		this.oldOriginalEffectiveDate = oldOriginalEffectiveDate;
	}
	public String getOldOriginalEffectiveDate(int index) {
		return (String)oldOriginalEffectiveDate.get(index);
	}
	public void setOldOriginalEffectiveDate(int index, String oldOriginalEffectiveDate) {
        setElement(this.oldOriginalEffectiveDate, index, oldOriginalEffectiveDate);
	}

	public List getCurrentEffectiveDateList() {
		return currentEffectiveDate;
	}
	public void setCurrentEffectiveDateList(List currentEffectiveDate) {
		this.currentEffectiveDate = currentEffectiveDate;
	}
	public String getCurrentEffectiveDate(int index) {
		return (String)currentEffectiveDate.get(index);
	}
	public void setCurrentEffectiveDate(int index, String ratingDate) {
        setElement(this.currentEffectiveDate, index, ratingDate);
	}

	public List getOldCurrentEffectiveDateList() {
		return oldCurrentEffectiveDate;
	}
	public void setOldCurrentEffectiveDateList(List oldCurrentEffectiveDate) {
		this.oldCurrentEffectiveDate = oldCurrentEffectiveDate;
	}
	public String getOldCurrentEffectiveDate(int index) {
		return (String)oldCurrentEffectiveDate.get(index);
	}
	public void setOldCurrentEffectiveDate(int index, String oldCurrentEffectiveDate) {
        setElement(this.oldCurrentEffectiveDate, index, oldCurrentEffectiveDate);
	}

	/**
	 * @return Returns the agentOrangeExposure.
	 */
	public String getAgentOrangeExposure() {
		return agentOrangeExposure;
	}

	/**
	 * @param agentOrangeExposure
	 *            The agentOrangeExposure to set.
	 */
	public void setAgentOrangeExposure(String agentOrangeExposure) {
		this.agentOrangeExposure = agentOrangeExposure;
	}

	/**
	 * @return Returns the agentOrangeLocation.
	 */
	public String getAgentOrangeLocation() {
		return agentOrangeLocation;
	}

	/**
	 * @param agentOrangeLocation
	 *            The agentOrangeLocation to set.
	 */
	public void setAgentOrangeLocation(String agentOrangeLocation) {
		this.agentOrangeLocation = agentOrangeLocation;
	}

	/**
	 * @return Returns the environmentalContaminationExposure.
	 */
	public String getEnvironmentalContaminationExposure() {
		return environmentalContaminationExposure;
	}

	/**
	 * @param environmentalContaminationExposure
	 *            The environmentalContaminationExposure to set.
	 */
	public void setEnvironmentalContaminationExposure(
			String environmentalContaminationExposure) {
		this.environmentalContaminationExposure = environmentalContaminationExposure;
	}

	/**
	 * @return Returns the radiationExposure.
	 */
	public String getRadiationExposure() {
		return radiationExposure;
	}

	/**
	 * @param radiationExposure
	 *            The radiationExposure to set.
	 */
	public void setRadiationExposure(String radiationExposure) {
		this.radiationExposure = radiationExposure;
	}

	/**
	 * @return Returns the disabilityRetirementIndicator.
	 */
	public String getDisabilityRetirementIndicator() {
		return disabilityRetirementIndicator;
	}

	/**
	 * @param disabilityRetirementIndicator
	 *            The disabilityRetirementIndicator to set.
	 */
	public void setDisabilityRetirementIndicator(
			String disabilityRetirementIndicator) {
		this.disabilityRetirementIndicator = disabilityRetirementIndicator;
	}

	/**
	 * @return Returns the radiationExposureMethod.
	 */
	public String getRadiationExposureMethod() {
		return radiationExposureMethod;
	}

	/**
	 * @param radiationExposureMethod
	 *            The radiationExposureMethod to set.
	 */
	public void setRadiationExposureMethod(String radiationExposureMethod) {
		this.radiationExposureMethod = radiationExposureMethod;
	}

	/**
	 * @return Returns the alliedVeteranCountry.
	 */
	public String getAlliedVeteranCountry() {
		return alliedVeteranCountry;
	}

	/**
	 * @param alliedVeteranCountry
	 *            The alliedVeteranCountry to set.
	 */
	public void setAlliedVeteranCountry(String alliedVeteranCountry) {
		this.alliedVeteranCountry = alliedVeteranCountry;
	}

	/**
	 * @return Returns the champa.
	 */
	public String getChampa() {
		return champa;
	}

	/**
	 * @param champa
	 *            The champa to set.
	 */
	public void setChampa(String champa) {
		this.champa = champa;
	}

	/**
	 * @return Returns the collateralOfVet.
	 */
	public String getCollateralOfVet() {
		return collateralOfVet;
	}

	/**
	 * @param collateralOfVet
	 *            The collateralOfVet to set.
	 */
	public void setCollateralOfVet(String collateralOfVet) {
		this.collateralOfVet = collateralOfVet;
	}

	/**
	 * @return Returns the employee.
	 */
	public String getEmployee() {
		return employee;
	}

	/**
	 * @param employee
	 *            The employee to set.
	 */
	public void setEmployee(String employee) {
		this.employee = employee;
	}

	/**
	 * @return Returns the otherFederalAgency.
	 */
	public String getOtherFederalAgency() {
		return otherFederalAgency;
	}

	/**
	 * @param otherFederalAgency
	 *            The otherFederalAgency to set.
	 */
	public void setOtherFederalAgency(String otherFederalAgency) {
		this.otherFederalAgency = otherFederalAgency;
	}

	/**
	 * @return Returns the sharingAgreement.
	 */
	public String getSharingAgreement() {
		return sharingAgreement;
	}

	/**
	 * @param sharingAgreement
	 *            The sharingAgreement to set.
	 */
	public void setSharingAgreement(String sharingAgreement) {
		this.sharingAgreement = sharingAgreement;
	}

	/**
	 * @return Returns the tricare.
	 */
	public String getTricare() {
		return tricare;
	}

	/**
	 * @param tricare
	 *            The tricare to set.
	 */
	public void setTricare(String tricare) {
		this.tricare = tricare;
	}

	/**
	 * @return Returns the periodOfService.
	 */
	public String getPeriodOfService() {
		return periodOfService;
	}
	/**
	 * @param periodOfService The periodOfService to set.
	 */
	public void setPeriodOfService(String periodOfService) {
		this.periodOfService = periodOfService;
	}

	public List getDisabilityIdList() {
		return disabilityId;
	}
	public void setDisabilityIdList(List disabilityId) {
		this.disabilityId = disabilityId;
	}
	public EntityKey getDisabilityId(int index) {
		return (EntityKey) disabilityId.get(index);
	}
	public void setDisabilityId(int index, EntityKey disabilityId) {
		setElement(this.disabilityId, index, disabilityId);
	}

	public List getDisabilityIdStringsList() {
		return disabilityIdStrings;
	}
	public void setDisabilityIdStringsList(List disabilityIdStrings) {
		this.disabilityIdStrings = disabilityIdStrings;
	}
	public String getDisabilityIdStrings(int index) {
		return (String) disabilityIdStrings.get(index);
	}
	public void setDisabilityStringsId(int index, String disabilityIdStrings) {
        setElement(this.disabilityIdStrings, index, disabilityIdStrings);
	}

    public String getVoaHiddenIdList() {
        return voaHiddenId;
    }

    public void setVoaHiddenIdList(String voaHiddenId) {
        this.voaHiddenId = voaHiddenId;
    }

	public List getPowIdList() {
		return powId;
	}
	public int getPowIdListSize() {
		return powId.size();
	}

	public void setPowIdList(List powId) {
		this.powId = powId;
	}

	public EntityKey getPowId(int index) {
		return (EntityKey) powId.get(index);
	}

	public void setPowId(int index, EntityKey value) {
		setElement(this.powId, index, value);
	}

	public String getOldEligibilityStatusDate() {
		return this.oldEligibilityStatusDate;
	}

	public void setOldEligibilityStatusDate(String oldEligibilityStatusDate) {
		this.oldEligibilityStatusDate = oldEligibilityStatusDate;
	}

	/**
	 * @return Returns the selectedDisabilityIndexes.
	 */
	public int[] getSelectedDisabilityIndexes() {
		return selectedDisabilityIndexes;
	}

    public int getSelectedDisabilityIndexesLength()
    {
        return selectedDisabilityIndexes != null ? selectedDisabilityIndexes.length : 0;
    }

	/**
	 * @param selectedDisabilityIndexes The selectedDisabilityIndexes to set.
	 */
	public void setSelectedDisabilityIndexes(int[] selectedDisabilityIndexes) {
		this.selectedDisabilityIndexes = selectedDisabilityIndexes;
	}
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		setSelectedDisabilityIndexes(new int[0]);
	}

	public void init() {
		setSelectedDisabilityIndexes(new int[0]);
		initPow();
		initDisability();
		resetCampLejeune();

	}
	public void resetCampLejeune()
	{
		////////////////////CLV////////////////////////
		campLejeuneInd = "";
		//campLejeuneVerificationMethod = "";
		campLejeuneVerificationComments = "";
		campLejeuneChangeDate = "";
		campLejeuneChangeSite = "";
		campLejeuneChangeSource = "";
		campLejeuneDisabled = true;
		campLejeuneVerificationMethods = resetCampLejeuneVerificationMethods;
	}
	public void initPow() {
		powId = new ArrayList();
		powConfinementLocation = new ArrayList();
		powCaptureDate = new ArrayList();
		powReleaseDate = new ArrayList();
		powCaptivityDays = new ArrayList();
		powSource = new ArrayList();
		powDocumentType = new ArrayList();
		powCampLocation = new ArrayList();
		powCampCode = new ArrayList();
		powCampName = new ArrayList();
		powCampCity = new ArrayList();
		powDateEntered = new ArrayList();

	}

	public void addPow(EntityKey id, String loc, String cap, String rel, String days,
			String source, String documentType,
			String campLocation, String campCode, String campName, String campCity,
			String dateEntered) {
		powId.add(id);
		powConfinementLocation.add(loc);
		powCaptureDate.add(cap);
		powReleaseDate.add(rel);
		powCaptivityDays.add(days);
		powSource.add(source);
		powDocumentType.add(documentType);
		powCampLocation.add(campLocation);
		powCampCode.add(campCode);
		powCampName.add(campName);
		powCampCity.add(campCity);
		powDateEntered.add(dateEntered);
	}

	public void addNewPow() {
		addPow(null, "", "", "", "", "", "", "", "", "", "", "");
	}

	public void initDisability() {
		disabilityId = new ArrayList();
		disabilityIdStrings = new ArrayList();
		disabilityCodes = new ArrayList();
		disDescription = new ArrayList();
		percentage = new ArrayList();
		diagnosticExtremity = new ArrayList();
		originalEffectiveDate = new ArrayList();
		currentEffectiveDate = new ArrayList();
		oldOriginalEffectiveDate = new ArrayList();
		oldCurrentEffectiveDate = new ArrayList();
		setSelectedDisabilityIndexes(new int[0]);
	}

	public void addDisability(EntityKey id, String idString, String code, String desc, String perc,
			String extCode, String originalEffectiveDate, String currentEffectiveDate) {
		disabilityId.add(id);
		disabilityIdStrings.add(idString);
		disabilityCodes.add(code);
		disDescription.add(desc);
		percentage.add(perc);
		diagnosticExtremity.add(extCode);
		this.originalEffectiveDate.add(originalEffectiveDate);
		this.oldOriginalEffectiveDate.add(originalEffectiveDate);
		this.currentEffectiveDate.add(currentEffectiveDate);
		this.oldCurrentEffectiveDate.add(currentEffectiveDate);
	}

	//Added index, so timestamp string will be uniqe.
	public void addNewDisability(int index) {
		addDisability(null, String.valueOf(new Date().getTime() + index), "", "", "", "", "", "");
	}
	public void removeAllDisability() {
		initDisability();
	}

	private void validateTotalCheckAmount(MessageResources messageResources, ActionMessages messages)
	{
        String fieldLabel = messageResources.getMessage("label.totalCheckAmount");
        String fieldName = "totalCheckAmount";

    	Double minValue = new Double(0);
    	Double maxValue = new Double(99999.00);
        try
		{
        	if (getTotalCheckAmount() != null && getTotalCheckAmount().trim().length() > 0)
        	{
	        	Double d = new Double(getTotalCheckAmount());
	        	if(d.doubleValue() < 0 || d.doubleValue() > 99999.00)
	        	{
	        		messages.add(fieldName,new ActionMessage(MessageKeys.ERRORS_RANGE, fieldLabel, minValue, maxValue));
	        	}
        	}
		}
        catch(NumberFormatException e)
		{
        	messages.add(fieldName,new ActionMessage("errors.double",fieldLabel));
		}
	}

	private void validatePOW(MessageResources messageResources, ActionMessages messages)
	{
		String captureDateLabel = "Capture Date";
		String captureDateName = "powCaptureDate";
		String releaseDateLabel = "Release Date";
		String releaseDateName = "powReleaseDate";
		String confinementLocationLabel = "Confinement Location";
		String confinementLocationName = "powConfinementLocation";

		for (int i = 0; i < getPowIdList().size(); i++)
        {
            EntityKey id = getPowId(i);
            String loc = getPowConfinementLocation(i);
            ImpreciseDate capDate = null;
            ImpreciseDate relDate = null;

			//Validate Dates
			if (getPowCaptureDate(i) != null && getPowCaptureDate(i).trim().length() > 0)
            {
				//ESR_CodeCR4796, Not valid with year only
				if (getPowCaptureDate(i).trim().length() < 5)
                    messages.add(captureDateName+"["+i+"]", new ActionMessage("errors.imprecisedateWithMonth", captureDateLabel+"["+i+"]" + " value '" + getPowCaptureDate(i) + "'" ));

				try
                {
					capDate = DateUtils.getImpreciseDate(getPowCaptureDate(i));
					if (!capDate.isMonthPrecise())
	                    messages.add(captureDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Capture Date must be at least a Month and Year."));
                }
                catch (Exception ex)
                {
                    messages.add(captureDateName+"["+i+"]", new ActionMessage("errors.imprecisedateWithMonth", captureDateLabel+"["+i+"]" + " value '" + getPowCaptureDate(i) + "'" ));
                }
            }
			if (getPowReleaseDate(i) != null && getPowReleaseDate(i).trim().length() > 0)
            {
				//ESR_CodeCR4796, Not valid with year only
				if (getPowReleaseDate(i).trim().length() < 5)
                    messages.add(releaseDateName+"["+i+"]", new ActionMessage("errors.imprecisedateWithMonth", releaseDateLabel+"["+i+"]" + " value '" + getPowReleaseDate(i) + "'" ));

				try
                {
					relDate = DateUtils.getImpreciseDate(getPowReleaseDate(i));
					if (!relDate.isMonthPrecise())
	                    messages.add(releaseDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Release Date must be at least a Month and Year."));

                }
                catch (Exception ex)
                {
                    messages.add(releaseDateName+"["+i+"]", new ActionMessage("errors.imprecisedateWithMonth", releaseDateLabel+"["+i+"]" + " value '" + getPowReleaseDate(i) + "'" ));
                }
            }
			boolean hasData =
				(capDate != null || relDate != null
				|| (loc != null && loc.trim().length() > 0)
				|| (getPowSource(i) != null && getPowSource(i).trim().length() > 0)
				|| (getPowDocumentType(i) != null && getPowDocumentType(i).trim().length() > 0)
				|| (getPowCampLocation(i) != null && getPowCampLocation(i).trim().length() > 0)
				);
			if (hasData == false)
				continue;
			else if (loc == null || loc.trim().length() == 0)
		    	messages.add(confinementLocationName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Confinement Location is required information."));
			else if (capDate == null)
		    	messages.add(captureDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Capture Date is required information."));
			else if (relDate == null)
		    	messages.add(releaseDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Release Date is required information."));
			else if (!DateUtils.isDateBetween(capDate, null, relDate))
	    		messages.add(captureDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Capture Date cannot be after the Release Date."));
			else if (!DateUtils.isDateBetween(capDate, null, new ImpreciseDate(new Date())))
	    		messages.add(captureDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Capture Date cannot be a future date."));
			else if (!DateUtils.isDateBetween(relDate, null, new ImpreciseDate(new Date())))
	    		messages.add(releaseDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Release Date cannot be a future date."));
			else if (getDeathDate() != null && !DateUtils.isDateBetween(capDate, null, DateUtils.getImpreciseDate(getDeathDate())))
	    		messages.add(captureDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Capture Date cannot fall after Date of Death."));
			else if (getDeathDate() != null && !DateUtils.isDateBetween(relDate, null, DateUtils.getImpreciseDate(getDeathDate())))
	    		messages.add(releaseDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Release Date cannot fall after Date of Death."));
			else if (getBirthDate() != null && !DateUtils.isDateBetween(capDate, DateUtils.getImpreciseDate(getBirthDate()), null))
	    		messages.add(captureDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Capture Date cannot be prior to Date of Birth."));
			else if (getBirthDate() != null && !DateUtils.isDateBetween(relDate, DateUtils.getImpreciseDate(getBirthDate()), null))
	    		messages.add(releaseDateName+"["+i+"]", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Release Date cannot be prior to Date of Birth."));
        }
	}

	private void validateRatedDisability(MessageResources messageResources, ActionMessages messages)
	{
		String codeFieldLabel = "Rated Disability Code";
		String codeFieldName = "code";
		String percentageFieldLabel = "Service Connected Percentage";
		String percentageFieldName = "percentage";
		String originalEffectiveDateLabel = "Original Effective Date";
		String originalEffectiveDateName = "originalEffectiveDate";
		String currentEffectiveDateLabel = "Current Effective Date";
		String currentEffectiveDateName = "currentEffectiveDate";

		ImpreciseDate effectiveDateCombinedRatingDate = null;
		if (effectiveDateCombinedRating != null)
		{
			effectiveDateCombinedRatingDate = DateUtils.getImpreciseDate(effectiveDateCombinedRating);
		}

		for (int i = 0; i < getSelectedDisabilityIndexes().length; i++)
		{//getSelectedDisabilityIds
			int index = selectedDisabilityIndexes[i];
			if (index >= 0 && index < disabilityCodes.size())
			{
				String code = getDisabilityCodes(index);
				String percentage = getPercentage(index);

				if (code == null || code.trim().length() == 0)
				{
					messages.add(codeFieldName, new ActionMessage("errors.required", codeFieldLabel));
				}
				else if (percentage == null || percentage.trim().length() == 0)
				{
					messages.add(percentageFieldName, new ActionMessage("errors.integer", percentageFieldLabel + " for Code: " + code));
				}
				else
				{
			        try
					{
			        	Integer value = new Integer(percentage);
			        	if(value.intValue() < 0 || value.intValue() > 100)
			        	{
			        		messages.add(percentageFieldName,new ActionMessage(MessageKeys.ERRORS_RANGE, percentageFieldLabel + " for Code: " + code, new Integer(0), new Integer(100)));
			        	}
					}
			        catch(NumberFormatException e)
					{
						messages.add(percentageFieldName, new ActionMessage("errors.integer", percentageFieldLabel + " for Code: " + code));
					}
				}

				//Validate Dates
				//validate user input is precise if it's diffent from old HL7 value
                if (getOriginalEffectiveDate(index) != null && getOriginalEffectiveDate(index).trim().length() > 0)
                {
                    if (!getOriginalEffectiveDate(index).trim().equals(getOldOriginalEffectiveDate(index)))
                    {
                        try
                        {
                            DateUtils.getDate(getOriginalEffectiveDate(index));
                        }
                        catch (Exception ex)
                        {
                            messages.add(originalEffectiveDateName, new ActionMessage("errors.date", originalEffectiveDateLabel + " value '" + getOriginalEffectiveDate(index) + "'" ));
                            return;
                        }
                    }
					ImpreciseDate input = DateUtils.getImpreciseDate(getOriginalEffectiveDate(index));
                    if (input != null)
                    {
                    	if (!DateUtils.isDateBetween(input, null, new ImpreciseDate(new Date())))
                    		messages.add(originalEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Original Effective Date cannot be a future date."));
                    	//6024[UC33.17.11.25]  Date cannot be on or after the veterans Date of Death.
                    	if (getDeathDate() != null
                        	&& (!DateUtils.isDateBetween(input, null, DateUtils.getImpreciseDate(getDeathDate()))
                        		||(DateUtils.format(input, DateUtils.MMDDYYYY).equals(DateUtils.format(DateUtils.getImpreciseDate(getDeathDate()), DateUtils.MMDDYYYY)))))
                    		messages.add(originalEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Original Effective Date cannot be on or after a Date of Death."));
                    	if (getBirthDate() != null && !DateUtils.isDateBetween(input, DateUtils.getImpreciseDate(getBirthDate()), null))
                    		messages.add(originalEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Original Effective Date cannot be prior to Date of Birth."));
                    	//The Rated Disability Original Effective Date must fall on or prior to the Effective Date of Combined Evaluation.
                    	if (effectiveDateCombinedRatingDate != null
                    		&& !DateUtils.isDateBetween(input, null, effectiveDateCombinedRatingDate)
                    		&& !(DateUtils.format(input, DateUtils.MMDDYYYY).equals(DateUtils.format(effectiveDateCombinedRatingDate, DateUtils.MMDDYYYY))))
                    		messages.add(originalEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Original Effective Date must fall on or prior to the Effective Date of Combined Evaluation."));
                    }
                }
				//validate user input is precise if it's diffent from old HL7 value
                if (getCurrentEffectiveDate(index) != null && getCurrentEffectiveDate(index).trim().length() > 0)
                {
                    if (!getCurrentEffectiveDate(index).trim().equals(getOldCurrentEffectiveDate(index)))
                    {
                        try
                        {
                            DateUtils.getDate(getCurrentEffectiveDate(index));
                        }
                        catch (Exception ex)
                        {
                            messages.add(currentEffectiveDateName, new ActionMessage("errors.date", currentEffectiveDateLabel + " value '" + getCurrentEffectiveDate(index) + "'" ));
                            return;
                        }
                    }
					ImpreciseDate input = DateUtils.getImpreciseDate(getCurrentEffectiveDate(index));
                    if (input != null)
                    {
                    	if (!DateUtils.isDateBetween(input, null, new ImpreciseDate(new Date())))
	                		messages.add(currentEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Current Effective Date cannot be a future date."));
                    	//6029[UC33.17.11.30]  Date cannot be on or after the veterans Date of Death.
                    	if (getDeathDate() != null
                        	&& (!DateUtils.isDateBetween(input, null, DateUtils.getImpreciseDate(getDeathDate()))
                        		|| (DateUtils.format(input, DateUtils.MMDDYYYY).equals(DateUtils.format(DateUtils.getImpreciseDate(getDeathDate()), DateUtils.MMDDYYYY)))))
                    		messages.add(currentEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Current Effective Date cannot be on or after a Date of Death."));
	                	//REEG_00003715
	                	if (getBirthDate() != null && !DateUtils.isDateBetween(input, DateUtils.getImpreciseDate(getBirthDate()), null))
	                		messages.add(currentEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Current Effective Date cannot be prior to Date of Birth."));
                    	//The Rated Disability Current Effective Date must fall on or prior to the Effective Date of Combined Evaluation.
                    	//on the date is fine, ignore time
	                	if (effectiveDateCombinedRatingDate != null
                        	&& !DateUtils.isDateBetween(input, null, effectiveDateCombinedRatingDate)
                        	&& !(DateUtils.format(input, DateUtils.MMDDYYYY).equals(DateUtils.format(effectiveDateCombinedRatingDate, DateUtils.MMDDYYYY))))
                    		messages.add(currentEffectiveDateName, new ActionMessage(MessageKeys.ERRORS_DETAIL, "Rated Disability Current Effective Date must fall on or prior to the Effective Date of Combined Evaluation."));

                    }
                }
			}
		}
	}

    private void validateNonVeteranFields(MessageResources messageResources, ActionMessages messages)
    {
        // When the veteran indicator is "n", then at least one of the non-veteran eligibility codes or
        // the ineligible date must be present.
        if (("n".equals(getVeteranIndicator())) && ("n".equals(getTricare())) &&
            ("n".equals(getSharingAgreement())) && ("n".equals(getChampa())) &&
            ("n".equals(getEmployee())) && ("n".equals(getCollateralOfVet())) &&
            (StringUtils.isEmpty(getAlliedVeteranCountry())) &&
            (StringUtils.isEmpty(getOtherFederalAgency())) &&
            (StringUtils.isBlank(getIneligibleDate())))
        {
            // The state is invalid so display an error message
            messages.add("ineligibleDate", new ActionMessage("error.nonVeteranEligibilityCodeRequired", "label.ineligibleDate"));
            messages.add("nonVetEligibilityCodes", new ActionMessage("error.nonVeteranEligibilityCodeRequired", "label.nonVetEligibilityCodes"));
        }
   }

    public boolean getOtherEligibilityFactorsPresent()
    {
        return ((StringUtils.isNotBlank(getAgentOrangeLocation())) || (StringUtils.isNotBlank(getRadiationExposureMethod())) ||
            ("y".equals(getDischargeDueDisability())) || ("y".equals(getDisabilityRetirementIndicator())) ||
            ("y".equals(getEnvironmentalContaminationExposure()))  || ("y".equals(getCampLejeuneInd()))
            );
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request){
        MessageResources messageResources = getResources(request);

	    ActionMessages messages = new ActionMessages();

        validateNonVeteranFields(messageResources, messages);
        validateTotalCheckAmount(messageResources, messages);
	    validatePOW(messageResources, messages);

	    //REEG_00004697
	    ImpreciseDate oldDate = null;
    	ImpreciseDate newDate = null;
	    if (StringUtils.isNotEmpty(getOldEligibilityStatusDate()))  {
	    	oldDate = DateUtils.getImpreciseDate(getOldEligibilityStatusDate());
	    }
	    if (StringUtils.isNotEmpty(getEligibilityStatusDate())) {
	    	try {
	    		newDate = DateUtils.getImpreciseDate(getEligibilityStatusDate());

	    		//Required is already checked in struts form validation

	    	    //If both the dates are present and are different or the new date is entered
	    	    if (oldDate == null || !oldDate.equals(newDate)) {
	    	    	//If the date is modified or enetered it should be precise and should be on or after dob
	    	    	if (newDate.isImprecise()) {
	    			    messages.add("eligibilityStatusDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Eligibility Status Date requires a precise date mm/dd/yyyy"));
	    	    	}
	    		    //Validate with date of birth
	    		    ImpreciseDate dob = DateUtils.getImpreciseDate(getBirthDate());
	    		    if (dob.compareTo(newDate) > 0) {
	    			    messages.add("eligibilityStatusDate", new ActionMessage(MessageKeys.ERRORS_DETAIL,
	    			    		"Eligibility Status Date cannot be prior to the Date of Birth"));
	    		    }
	    	    }
	    	}catch (IllegalArgumentException e){
			    messages.add("eligibilityStatusDate", new ActionMessage(MessageKeys.ERRORS_DATE, getEligibilityStatusDate()));
	    	}
	    }

//	    REEG_00004087 remove validation between EligStatusDate and DOD
//	    if (getEligibilityStatusDate() != null && getDeathDate() != null &&
//		    	(!DateUtils.isDateBetween(DateUtils.getImpreciseDate(getEligibilityStatusDate()), null, DateUtils.getImpreciseDate(getDeathDate()))
//		    	 || getEligibilityStatusDate().equals(getDeathDate())))
//		    	messages.add("eligibilityStatusDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Eligibility Status Date must be prior to the Date of Death"));

	    //Need to validate EffectiveDateCombinedRating is entered as precise, but
	    //it's ok to keep the same old date as imprecise.
	    if (getEffectiveDateCombinedRating() != null
	    	&& getEffectiveDateCombinedRating().trim().length() > 0)
	    {
			if (!getEffectiveDateCombinedRating().trim().equals(getOldEffectiveDateCombinedRating()))
		    {
				try
				{
					Date date = DateUtils.getDate(getEffectiveDateCombinedRating().trim());
				    if (getDeathDate() != null &&
						    (!DateUtils.isDateBetween(DateUtils.getImpreciseDate(getEffectiveDateCombinedRating()), null, DateUtils.getImpreciseDate(getDeathDate()))
						    || getEffectiveDateCombinedRating().equals(getDeathDate())))
						    messages.add("effectiveDateCombinedRating", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Effective Date of Combined Evaluation must be prior to the Date of Death"));
				} catch (IllegalArgumentException e)
				{
		    		messages.add("effectiveDateCombinedRating", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Effective Date of Combined Evaluation must be entered as a precise date"));
		    		return messages;
				}
		    }
	    }
	    validateRatedDisability(messageResources, messages);

        // ChangeRequest:4664
        if((StringUtils.isNotEmpty(this.getIneligibleDate()) &&
           (StringUtils.equalsIgnoreCase("n",oldVeteranIndicator) && StringUtils.equalsIgnoreCase("y",veteranIndicator)) &&
           (!this.isIneligibleDateAllowedForVeteran()))) {
            String fieldLabel = messageResources.getMessage(FIELD_LABEL_INELIGIBILE_DATE);
            messages.add(FIELD_NAME_INELIGIBILE_DATE, new ActionMessage(MESSAGE_KEY_INELIGIBILE_DATE_NOT_ALLOWED,fieldLabel));
        }

        if(StringUtils.isNotEmpty(this.getIneligibleDate()) && StringUtils.isNotEmpty(this.getServiceEntryDate())){
            Date ineligibleDate = DateUtils.getDate(this.getIneligibleDate());
            Date serviceEntryDate = DateUtils.getDate(this.getServiceEntryDate());
            if (serviceEntryDate.after(ineligibleDate)){
                String fieldLabel = messageResources.getMessage(FIELD_LABEL_INELIGIBILE_DATE);
                messages.add(FIELD_NAME_INELIGIBILE_DATE, new ActionMessage(MESSAGE_KEY_INELIGIBILE_DATE_NOT_ALLOWED,fieldLabel));
            }
        }

        validatePensionGroupData(messageResources, messages);
        return messages;
    }

    private void validatePensionGroupData(MessageResources messageResources, ActionMessages messages)
    {
    		// validate pensionAwardEffectiveDate precise and past date
    		// System.out.println("OLD Pension Effective Date"+getOldPensionAwardEffectiveDate());
    		// System.out.println("Pension Effective Date"+getPensionAwardEffectiveDate());

    		String dateStr = getPensionAwardEffectiveDate();
    		String fieldLabel = messageResources.getMessage("label.pensionAwardEffectiveDate");
    		if (StringUtils.isNotEmpty(getPensionAwardEffectiveDate())) {
    			try {
    				CommonDateUtils.getDate(dateStr, true);
    				Date date = DateUtils.getDate(dateStr, true);
    	            Date current = DateUtils.getCurrentDateTime();
    	            if (date!=null && date.compareTo(current) > 0) {
    	            	messages.add("pensionAwardEffectiveDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" cannot be greater than the current system date"));
    	            	return;
    	            }
    	         }catch (Exception e){
    	        	 messages.add("pensionAwardEffectiveDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" must be a precise date."));
    	        	 return;
    		    	 // messages.add("pensionAwardEffectiveDate", new ActionMessage("errors.date", fieldLabel));
    			}
    		}
    		// termination date precise and past date
    		dateStr = getPensionAwardTerminationDate();
    		fieldLabel = messageResources.getMessage("label.pensionAwardTerminationDate");
    		if (StringUtils.isNotEmpty(getPensionAwardTerminationDate())) {
    			try {
    				CommonDateUtils.getDate(dateStr, true);
    				Date date = DateUtils.getDate(dateStr, true);
    	            Date current = DateUtils.getCurrentDateTime();
    	            if (date!=null && date.compareTo(current) > 0) {
    	            	messages.add("pensionAwardTerminationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" cannot be greater than the current system date"));
    	            	return;
    	            }
    	         }catch (Exception e){
    	        	 messages.add("pensionAwardTerminationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" must be a precise date."));
    	        	 return;
    		    	 // messages.add("pensionAwardTerminationDate", new ActionMessage("errors.date", fieldLabel));
    			}
    		}

    		// come here, both date should be precise and valid
    		// comparing between termination and effective dates
    		// if (StringUtils.isNotEmpty(getPensionAwardEffectiveDate()) && StringUtils.isNotEmpty(getOldPensionAwardTerminationDate())){
    		// effective date cannot be less than termination date
    		if ( StringUtils.isNotBlank(this.getVaPension()) && "y".equalsIgnoreCase(this.getVaPension()) &&StringUtils.isNotEmpty(getPensionAwardEffectiveDate()) && StringUtils.isNotEmpty(getPensionAwardTerminationDate())){
    			fieldLabel = messageResources.getMessage("label.pensionAwardEffectiveDate");
    			String fieldLabel2 = messageResources.getMessage("label.pensionAwardTerminationDate");
    			Date date1 = DateUtils.getDate(getPensionAwardEffectiveDate(), true);
	            Date date2 = DateUtils.getDate(getPensionAwardTerminationDate(), true);
	            if (date1!=null && date2!=null && date1.compareTo(date2) < 0) {
	            	messages.add("pensionAwardEffectiveDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" cannot be less than the "+fieldLabel2));
	            	return;
	            }
    		}

    		// if (StringUtils.isNotEmpty(getPensionAwardTerminationDate()) && StringUtils.isNotEmpty(getOldPensionAwardEffectiveDate())){
    		// termination Date cannot be less than effective date
    		if ( StringUtils.isNotBlank(this.getVaPension()) && "n".equalsIgnoreCase(this.getVaPension()) && StringUtils.isNotEmpty(getPensionAwardTerminationDate()) && StringUtils.isNotEmpty(getPensionAwardEffectiveDate())){
    			fieldLabel = messageResources.getMessage("label.pensionAwardTerminationDate");
    			String fieldLabel2 = messageResources.getMessage("label.pensionAwardEffectiveDate");
    			Date date1 = DateUtils.getDate(getPensionAwardTerminationDate(), true);
	            Date date2 = DateUtils.getDate(getPensionAwardEffectiveDate(), true);
	            if (date1!=null && date2!=null && date1.compareTo(date2) < 0) {
	            	messages.add("pensionAwardTerminationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" cannot be less than the "+fieldLabel2));
	            	return;
	            }
    		}
        	// messages.add("pensionAwardEffectiveDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Pension Award Effective Date must be a precise date me"));
    		// if pension indicator change to Yes, effective date & reason code are required
    		if ( StringUtils.isNotBlank(this.getVaPension()) && "y".equalsIgnoreCase(this.getVaPension()) && (StringUtils.isBlank(this.getOldvaPension()) || "n".equalsIgnoreCase(this.getOldvaPension()) ) )
    		{
    			if (StringUtils.isEmpty(getPensionAwardEffectiveDate()))
    			{
    				messages.add("pensionAwardEffectiveDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Pension Award Effective Date is required when VA pension changed to YES"));
    				return;
    			}
    			if (StringUtils.isEmpty(getPensionAwardReasonCode()))
    			{
    				messages.add("pensionAwardReasonCode", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Pension Award Reason Code is required when VA pension changed to YES"));
    				return;
    			}
    		}

    		// if pension indicator change to No, termination date is required
    		if ( StringUtils.isNotBlank(this.getVaPension()) && "n".equalsIgnoreCase(this.getVaPension()) && (StringUtils.isBlank(this.getOldvaPension()) || "y".equalsIgnoreCase(this.getOldvaPension()) ) )
    		{
    			if (StringUtils.isEmpty(getPensionAwardTerminationDate()))
    			{
    				messages.add("pensionAwardTerminationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Pension Award Termination Date is required when VA pension changed to NO"));
    				return;
    			}
    			else if ( StringUtils.isEmpty(getPensionAwardTerminationReasonCode1())&&
    					StringUtils.isEmpty(getPensionAwardTerminationReasonCode2()) &&
    					StringUtils.isEmpty(getPensionAwardTerminationReasonCode3()) &&
    					StringUtils.isEmpty(getPensionAwardTerminationReasonCode4()) ){
    				messages.add("PensionAwardTerminationReasonCode1", new ActionMessage(MessageKeys.ERRORS_DETAIL, "A Pension Award Termination Code is required when pension termination date is entered"));
    				return;
    			}
    		}

    		// if pension termination date is entered, termination code is required
    		if ( StringUtils.isNotBlank(this.getVaPension()) && "n".equalsIgnoreCase(this.getVaPension()))
    		{	if (StringUtils.isNotEmpty(getPensionAwardTerminationDate()) )
    			{
    				Date date1 = DateUtils.getDate(getPensionAwardTerminationDate(), true);
    				// Date date2 = DateUtils.getDate(getOldPensionAwardTerminationDate(), true);
    				// if (date1!=null && (date2 == null || (date2!=null && date1.compareTo(date2) != 0 ) ) )
    				// if (StringUtils.isNotEmpty(getPensionAwardTerminationDate()) && date1!=null && date2!=null &&  date1.compareTo(date2)!= 0 && (
    				if (date1!=null && StringUtils.isEmpty(getPensionAwardTerminationReasonCode1()) &&
    					StringUtils.isEmpty(getPensionAwardTerminationReasonCode2()) &&
    					StringUtils.isEmpty(getPensionAwardTerminationReasonCode3()) &&
    					StringUtils.isEmpty(getPensionAwardTerminationReasonCode4()) )
    				{
    						messages.add("PensionAwardTerminationReasonCode1", new ActionMessage(MessageKeys.ERRORS_DETAIL, "A Pension Award Termination Code is required when pension termination date is entered"));
    						return;
    				}
    			}
        		else  if ( StringUtils.isEmpty(getPensionAwardTerminationDate()) && ( StringUtils.isNotEmpty(getPensionAwardTerminationReasonCode1()) ||
    					StringUtils.isNotEmpty(getPensionAwardTerminationReasonCode2()) ||
    					StringUtils.isNotEmpty(getPensionAwardTerminationReasonCode3()) ||
    					StringUtils.isNotEmpty(getPensionAwardTerminationReasonCode4()) ) )
        			  {
    						messages.add("pensionAwardTerminationDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "A Pension Award Termination Date is required when a pension termination reason code is entered"));
    						return;
        			  }
        	}

    		// if pension award date is entered, award code is required
    		if ( StringUtils.isNotBlank(this.getVaPension()) && "y".equalsIgnoreCase(this.getVaPension()) )
    		{  	if ( StringUtils.isNotEmpty(getPensionAwardEffectiveDate()) )
    			{
    				Date date1 = DateUtils.getDate(getPensionAwardEffectiveDate(), true);
    				// Date date2 = DateUtils.getDate(getOldPensionAwardEffectiveDate(), true);
    				if (date1!=null && StringUtils.isEmpty(getPensionAwardReasonCode()))
    						messages.add("pensionAwardReasonCode", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Pension Award Reason Code is required when pension award effective date is entered"));
        		}
        		else if ( StringUtils.isEmpty(getPensionAwardEffectiveDate()) && StringUtils.isNotEmpty(getPensionAwardReasonCode()))
					messages.add("pensionAwardEffectiveDate", new ActionMessage(MessageKeys.ERRORS_DETAIL, "Pension Award Effective Date is required when pension award reason code is entered"));
        	}
   }
    /*
     *
     */
    public static boolean validatePreciseDate(String dateStr, String fieldName, String fieldLabel,
            ActionMessages errors) {
        // If no value was specified, assume that the field is valid
        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }
        boolean fieldValid = true;
        try {
            boolean timeSupported = false;
            // Validate the precise date
            CommonDateUtils.getDate(dateStr, timeSupported);
        } catch (Exception e) {
            // Field parsing exception so it isn't valid
            fieldValid = false;
        }
        // Add the error message if invalid
        if (!fieldValid) {
            errors.add(fieldName, new ActionMessage("errors.date", fieldLabel));
        }
        // Return whether the field is valid or not
        return fieldValid;
    }

    public static boolean validatePastDate(String dateStr, String fieldName, String fieldLabel,
            ActionMessages errors) {

        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }
		try
		{
            Date date = DateUtils.getDate(dateStr, true);
            //Need time also to compare.
            Date current = DateUtils.getCurrentDateTime();
            if (date.compareTo(current) <= 0) {
                return true;
            }
		}
		catch (Exception e)
		{
			//exception shouldn't be thrown as it should be a valid date here
		}
        //parsing error or future date
		errors.add(fieldName, new ActionMessage(MessageKeys.ERRORS_DETAIL, fieldLabel+" cannot be greater than the current system date"));
		return false;
	}

    private boolean isIneligibleDateAllowedForVeteran() {
        // IneligibleDate allowed if SC% = 0
        // IneligibleDate allowed if has at-least one rated disability and all rated disabilities have SC% = 0.
        Integer sc = this.getInteger(this.getServiceConnected());
        if((sc == null || sc.intValue() > 0 || this.getPercentageList() == null || this.getPercentageList().isEmpty())) {
            return false;
        } else {
            for(Iterator iter=this.getPercentageList().iterator(); iter.hasNext();) {
                Integer ratedSC = this.getInteger((String)iter.next());
                if(ratedSC != null && ratedSC.intValue() > 0) {
                    return false;
                }
            }
            return true;
        }
    }


    private Integer getInteger(String value) {
        Integer intValue = null;
        if(StringUtils.isNotEmpty(value) && StringUtils.isNumeric(value.trim())) {
            try {
                intValue = new Integer(value.trim());
            } catch(Exception ex) {
                //Ignore
            }
        }
        return intValue;
    }

	/**
	 * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
	 */
	protected AbstractEntity createValueObject() {
		return new Person();
	}

    public VOAAttahmentEditActionForm getVoaAttachment(int index)
    {
        // make sure that orderList is not null
        if(this.voaAttachments == null)
        {
            this.voaAttachments = new ArrayList();
        }

        // indexes do not come in order, populate empty spots
        while(index >= this.voaAttachments.size())
        {
            this.voaAttachments.add(new VOAAttahmentEditActionForm());
        }

        // return the requested item
        return (VOAAttahmentEditActionForm) voaAttachments.get(index);
    }

    public List getVoaAttachments(){
          return voaAttachments;
     }

    public void setVoaAttachments(List voaAttachments) {
        this.voaAttachments = voaAttachments;
    }

    public String getActiveVOARowID() {
        return activeVOARowID;

    }

    public void setActiveVOARowID(String activeVOARowID) {
        this.activeVOARowID = activeVOARowID;
    }

	public String getPensionAwardEffectiveDate() {
		return pensionAwardEffectiveDate;
	}

	public void setPensionAwardEffectiveDate(String pensionAwardEffectiveDate) {
		this.pensionAwardEffectiveDate = pensionAwardEffectiveDate;
	}

	public String getPensionAwardReasonCode() {
		return pensionAwardReasonCode;
	}

	public void setPensionAwardReasonCode(String pensionAwardReasonCode) {
		this.pensionAwardReasonCode = pensionAwardReasonCode;
	}

	public String getPensionAwardTerminationDate() {
		return pensionAwardTerminationDate;
	}

	public void setPensionAwardTerminationDate(String pensionAwardTerminationDate) {
		this.pensionAwardTerminationDate = pensionAwardTerminationDate;
	}

	public String getPensionAwardTerminationReasonCode1() {
		return pensionAwardTerminationReasonCode1;
	}

	public void setPensionAwardTerminationReasonCode1(
			String pensionAwardTerminationReasonCode1) {
		this.pensionAwardTerminationReasonCode1 = pensionAwardTerminationReasonCode1;
	}

	public String getPensionAwardTerminationReasonCode2() {
		return pensionAwardTerminationReasonCode2;
	}

	public void setPensionAwardTerminationReasonCode2(
			String pensionAwardTerminationReasonCode2) {
		this.pensionAwardTerminationReasonCode2 = pensionAwardTerminationReasonCode2;
	}

	public String getPensionAwardTerminationReasonCode3() {
		return pensionAwardTerminationReasonCode3;
	}

	public void setPensionAwardTerminationReasonCode3(
			String pensionAwardTerminationReasonCode3) {
		this.pensionAwardTerminationReasonCode3 = pensionAwardTerminationReasonCode3;
	}

	public String getPensionAwardTerminationReasonCode4() {
		return pensionAwardTerminationReasonCode4;
	}

	public void setPensionAwardTerminationReasonCode4(
			String pensionAwardTerminationReasonCode4) {
		this.pensionAwardTerminationReasonCode4 = pensionAwardTerminationReasonCode4;
	}

	public String getOldvaPension() {
		return oldvaPension;
	}

	public void setOldvaPension(String oldvaPension) {
		this.oldvaPension = oldvaPension;
	}

	public String getOldPensionAwardEffectiveDate() {
		return oldPensionAwardEffectiveDate;
	}

	public void setOldPensionAwardEffectiveDate(String oldPensionAwardEffectiveDate) {
		this.oldPensionAwardEffectiveDate = oldPensionAwardEffectiveDate;
	}

	public String getOldPensionAwardTerminationDate() {
		return oldPensionAwardTerminationDate;
	}

	public void setOldPensionAwardTerminationDate(
			String oldPensionAwardTerminationDate) {
		this.oldPensionAwardTerminationDate = oldPensionAwardTerminationDate;
	}

	public String getCampLejeuneInd() {
		return campLejeuneInd;
	}

	public void setCampLejeuneInd(String campLejeuneInd) {
		this.campLejeuneInd = campLejeuneInd;
	}

    public String[] getCampLejeuneVerificationMethods()
    {
        return campLejeuneVerificationMethods;
    }

    public void setCampLejeuneVerificationMethods(String[] campLejeuneVerificationMethods)
    {
        this.campLejeuneVerificationMethods = campLejeuneVerificationMethods;
    }

	public String getCampLejeuneVerificationMethod() {
		return campLejeuneVerificationMethod;
	}

	public void setCampLejeuneVerificationMethod(
			String campLejeuneVerificationMethod) {
		this.campLejeuneVerificationMethod = campLejeuneVerificationMethod;
	}

	public String getCampLejeuneVerificationComments() {
		return campLejeuneVerificationComments;
	}

	public void setCampLejeuneVerificationComments(
			String campLejeuneVerificationComments) {
		this.campLejeuneVerificationComments = campLejeuneVerificationComments;
	}

	public String getCampLejeuneChangeDate() {
		return campLejeuneChangeDate;
	}

	public void setCampLejeuneChangeDate(String campLejeuneChangeDate) {
		this.campLejeuneChangeDate = campLejeuneChangeDate;
	}

	public String getCampLejeuneChangeSite() {
		return campLejeuneChangeSite;
	}

	public void setCampLejeuneChangeSite(String campLejeuneChangeSite) {
		this.campLejeuneChangeSite = campLejeuneChangeSite;
	}

	public String getCampLejeuneChangeSource() {
		return campLejeuneChangeSource;
	}

	public void setCampLejeuneChangeSource(String campLejeuneChangeSource) {
		this.campLejeuneChangeSource = campLejeuneChangeSource;
	}

	public boolean isCampLejeuneDisabled() {
		return campLejeuneDisabled;
	}

	public void setCampLejeuneDisabled(boolean campLejeuneDisabled) {
		this.campLejeuneDisabled = campLejeuneDisabled;
	}

	//CCR13875
	public String getIsSelectedOtherCLVer(){
        String selectedOthers = "false";
        List<String> clvms=null;
        clvms = (campLejeuneVerificationMethods != null && campLejeuneVerificationMethods.length >0) ?  Arrays.asList(campLejeuneVerificationMethods):null;

        if (clvms != null) {
          Iterator clvmsIter = clvms.iterator();
          if(clvmsIter!=null)
          {
              while (clvmsIter.hasNext()) {
                  String clveficationMethod = (String)clvmsIter.next();
                  System.out.println(clveficationMethod);
                  if (clveficationMethod.equalsIgnoreCase("7")){
                      selectedOthers = "true";
                   }
              }
          }
        }
        System.out.println(selectedOthers);
        return selectedOthers;
    }

	public void reset() {
		this.campLejeuneVerificationMethods = resetCampLejeuneVerificationMethods;
	}

	public String getEligStatusPendingVerficationReason() {
		return eligStatusPendingVerficationReason;
	}

	public void setEligStatusPendingVerficationReason(String eligStatusPendingVerficationReason) {
		this.eligStatusPendingVerficationReason = eligStatusPendingVerficationReason;
	}

	public String getEligStatusPendingVerfReasonExplain() {
		return eligStatusPendingVerfReasonExplain;
	}

	public void setEligStatusPendingVerfReasonExplain(String eligStatusPendingVerfReasonExplain) {
		this.eligStatusPendingVerfReasonExplain = eligStatusPendingVerfReasonExplain;
	}

}