/*
 * Created on Jan 22, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.ee.action;

//Java classes
import java.util.*;

//Framework class
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.esr.common.infra.TriState;

// EDB Classes
import gov.va.med.esr.common.model.person.*;
import gov.va.med.esr.common.model.ee.*;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;

/**
 * @author DNS   CHENB
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ClinicalDeterConversionService extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target)
    throws ConversionServiceException
	{
    	if (source instanceof Person && target instanceof ClinicalDeterForm)
        {
            Person person = (Person)source;
            ClinicalDeterForm clinicalDeterForm = (ClinicalDeterForm)target;

			clinicalDeterForm.setConditions(getConditions(person));
			clinicalDeterForm.setProcetures(getProcedures(person));
			clinicalDeterForm.setDiagnosis(getDiagnosis(person));
			clinicalDeterForm.setDescriptors(getDescriptor(person));
			clinicalDeterForm.setCd(getCatastrophicDisability(person));
			clinicalDeterForm.setMst(getMilitarySexualTrauma(person));
			clinicalDeterForm.setNtr(getNoseThroatRadium(person));
			clinicalDeterForm.setNtrTreatment(receivedNTRTreatment(person));
            clinicalDeterForm.setSci(getSpinalCordInjury(person));
        }
        else
        {
            throw new ConversionServiceException("Type mismatch: Expecting Person, ClinicalDeterForm Received " +
                source.getClass().getName() + " and " + target.getClass().getName());
        }
	}

    //Util function for get data from Person
	public static Set getClinicalDeterminations(Person person)
	{
		return person.getClinicalDeterminations();
	}

	public static CatastrophicDisability getCatastrophicDisability(Person person)
	{
		return (CatastrophicDisability) person.getClinicalDeterminationByType(CatastrophicDisability.class);
	}
	public static MilitarySexualTrauma getMilitarySexualTrauma(Person person)
	{
		return (MilitarySexualTrauma) person.getClinicalDeterminationByType(MilitarySexualTrauma.class);
	}
	public static NoseThroatRadium getNoseThroatRadium(Person person)
	{
		return (NoseThroatRadium) person.getClinicalDeterminationByType(NoseThroatRadium.class);
	}
    
    public static SpinalCordInjury getSpinalCordInjury(Person person)
    {
        return (SpinalCordInjury) person.getClinicalDeterminationByType(SpinalCordInjury.class);
    }

	public static String receivedNTRTreatment(Person person)
	{
		NoseThroatRadium ntr = getNoseThroatRadium(person);
		
		if (ntr != null)
		{
			if (ntr.getReceivingTreatment() != null && ntr.getReceivingTreatment().equals(TriState.TRUE))
				return "Yes";
			else if (ntr.getReceivingTreatment() != null && ntr.getReceivingTreatment().equals(TriState.FALSE))
				return "No";
			else if (ntr.getReceivingTreatment() != null && ntr.getReceivingTreatment().equals(TriState.UNKNOWN))
				return "Unknown";
		}
		
		return null;
	}
	public static Vector getConditions(Person person)
	{
		CatastrophicDisability cd = getCatastrophicDisability(person);
		if (cd  != null && cd.getConditions() != null)
		{
			Vector ret =  new Vector();
			Object[] objs = cd.getConditions().toArray();
			for (int i = 0; i < objs.length; i++)
			{
				if ((objs[i] instanceof CDCondition) && ((CDCondition)objs[i]).getCondition() != null)
				ret.add(objs[i]);
			}
			return ret;
		}
		return null;
	}
	public static Vector getDiagnosis(Person person)
	{
		CatastrophicDisability cd = getCatastrophicDisability(person);
		if (cd != null && cd.getDiagnoses() != null)
		{
			Vector ret =  new Vector();
			Object[] objs = cd.getDiagnoses().toArray();
			for (int i = 0; i < objs.length; i++)
			{
				if ((objs[i] instanceof CDDiagnosis) && ((CDDiagnosis)objs[i]).getDiagnosis() != null)
				ret.add(objs[i]);
			}
			return ret;
		}
		return null;
	}
	public static Vector getDescriptor(Person person)
	{
		CatastrophicDisability cd = getCatastrophicDisability(person);
		if (cd != null && cd.getCDDescriptors() != null)
		{
			Vector ret =  new Vector();
			Object[] objs = cd.getCDDescriptors().toArray();
			for (int i = 0; i < objs.length; i++)
			{
				if ((objs[i] instanceof CDDescriptor) && ((CDDescriptor)objs[i]).getDescriptorType() != null)
				ret.add(objs[i]);
			}
			return ret;
		}
		return null;
	}
	public static Vector getProcedures(Person person)
	{
		CatastrophicDisability cd = getCatastrophicDisability(person);
		if (cd != null && cd.getProcedures() != null)
		{
			Vector ret =  new Vector();
			Object[] objs = cd.getProcedures().toArray();
			for (int i = 0; i < objs.length; i++)
			{
				if ((objs[i] instanceof CDProcedure) && ((CDProcedure)objs[i]).getProcedure() != null)
				ret.add(objs[i]);
			}
			return ret;
		}
		return null;
	}

}
