/*
 * Created on Jan 22, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.ee.action;

//Framework class
import gov.va.med.fw.conversion.ConversionServiceException;

// EDB Classes
import gov.va.med.esr.common.model.person.*;
import gov.va.med.esr.ui.admin.action.SearchActionForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.common.model.lookup.ApplicationStatus;

/**
 * @author DNS   PALANM
 *
 * 
 */
public class AddPersonHistoryConversionService extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target)
    throws ConversionServiceException
	{
    	if (source instanceof EnrollmentApplication && target instanceof SearchActionForm)
        {
    		EnrollmentApplication eap = (EnrollmentApplication)source;
            SearchActionForm searchActionForm = (SearchActionForm)target; 
            searchActionForm.setAppSignatureDate(getApplicationSignatureDate(eap));            
            searchActionForm.setAppMethod(getApplicationMethod(eap));              
            searchActionForm.setAppEntryDate(getApplicationDate(eap));            
            searchActionForm.setAppStatus(getApplicationStatus(eap));             
            searchActionForm.setAppStatusTimeStamp(getModifiedDate(eap));            
            searchActionForm.setAppCompletedDate(getCompletedDate(eap));            
            searchActionForm.setAppUser(getCompletedPersonInfo(eap));
            
            
        }
        else
        {
            throw new ConversionServiceException("Type mismatch: Expecting EnrollmentApplication, SearchActionForm Received " +
                source.getClass().getName() + " and " + target.getClass().getName());
        }
	}
    

	public String getCompletedPersonInfo(EnrollmentApplication eap)
	{		
		String completedPerson = "";
		
		if(eap.getApplicationStatus() != null){
			if(eap.getApplicationStatus().equals(ApplicationStatus.COMPLETE)){
				completedPerson = eap.getModifiedBy().getName();			
			}			
		}
		
		return completedPerson;
	}
	
	public String getCompletedDate(EnrollmentApplication eap)
	{
		String completedDate = "";
		if(eap.getApplicationStatus() != null){
			if(eap.getApplicationStatus().equals(ApplicationStatus.COMPLETE)){			
				completedDate = DateUtils.format(eap.getModifiedOn(),DateUtils.MMDDYYYY);			
			}			
		}		
				
		
		return completedDate;
	}
	
	public String getApplicationMethod(EnrollmentApplication eap)
	{
		String applicationMethod = "";
		
		if(eap.getApplicationMethod() != null){
			applicationMethod = eap.getApplicationMethod().getCode();
		}	
		
		return applicationMethod;
	}
	
	public String getApplicationStatus(EnrollmentApplication eap)
	{
		String applicationStatus = "";
		
		if(eap.getApplicationStatus() != null){
			applicationStatus = eap.getApplicationStatus().getCode();
		}	
		
		return applicationStatus;
	}
	
	public String getApplicationSignatureDate(EnrollmentApplication eap)
	{
		String applicationSignatureDate = "";
		
		if(eap.getSignatureDate() != null){
			applicationSignatureDate = DateUtils.format(eap.getSignatureDate(),DateUtils.MMDDYYYY);
		}	
		
		return applicationSignatureDate;
	}
	
	public String getApplicationDate(EnrollmentApplication eap)
	{
		String applicationDate = "";
		
		if(eap.getApplicationDate() != null){
			applicationDate = DateUtils.format(eap.getApplicationDate(),DateUtils.MMDDYYYY);
		}	
		
		return applicationDate;
	}
	
	public String getModifiedDate(EnrollmentApplication eap)
	{
		String modifiedDate = "";
		
		if(eap.getApplicationInProcess() != null){
			
			modifiedDate = DateUtils.format(eap.getApplicationInProcess().getModifiedOn(),DateUtils.MMDDYYYY);
		}	
		
		return modifiedDate;
	}

}
