/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.ui.common.action.AddressForm;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

import javax.servlet.http.HttpServletRequest;


/**
 * Action form for all the association actions.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class PersonAssociationInfoForm extends AddressForm
{
    private static final long serialVersionUID = -6516667374600653349L;
    
    private String associateId;
    private String relationship;
    private String role;
    private String organizationName;
    private String firstName;
    private String middleName;
    private String lastName;
    
    private String phone;
    private String phoneChangeDate;
    private String deactivationDate;
    
    private String createdBy;
    private String createdOn;
    private String modifiedBy;
    private String modifiedOn;

    public String getAssociateId()
    {
        return associateId;
    }

    public void setAssociateId(String associateId)
    {
        this.associateId = associateId;
    }

    public String getRelationship()
    {
        return relationship;
    }

    public void setRelationship(String relationship)
    {
        this.relationship = relationship;
    }

    
    public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getRole()
    {
        return role;
    }

    public void setRole(String role)
    {
        this.role = role;
    }

    public String getName()
    {
        return organizationName;
    }

    public String getOrganizationName()
    {
        return organizationName;
    }

    public void setOrganizationName(String organizationName)
    {
        this.organizationName = organizationName;
    }

    public String getPhone()
    {
        return phone;
    }

    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhoneChangeDate()
    {
        return phoneChangeDate;
    }

    public void setPhoneChangeDate(String phoneChangeDate)
    {
        this.phoneChangeDate = phoneChangeDate;
    }

    public String getCreatedBy()
    {
        return createdBy;
    }

    public void setCreatedBy(String createdBy)
    {
        this.createdBy = createdBy;
    }

    public String getCreatedOn()
    {
        return createdOn;
    }

    public void setCreatedOn(String createdOn)
    {
        this.createdOn = createdOn;
    }

    public String getModifiedBy()
    {
        return modifiedBy;
    }

    public void setModifiedBy(String modifiedBy)
    {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedOn()
    {
        return modifiedOn;
    }

    public void setModifiedOn(String modifiedOn)
    {
        this.modifiedOn = modifiedOn;
    }
 
    public void clearForm() {
    	super.clearForm();
    	associateId = null;
    	relationship = null;
    	role = null;
    	organizationName = null;
    	firstName = null;
    	middleName = null;
    	lastName = null;

    	phone = null;
    	phoneChangeDate = null;
    	deactivationDate = null;

    	createdBy = null;
    	createdOn = null;
    	modifiedBy = null;
    	modifiedOn = null;    	
    }
    
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
        ActionErrors validationErrors = super.validate(mapping, request);
        return validateOptionalAddress(mapping, request, validationErrors);
    }

    public String getDeactivationDate() {
        return deactivationDate;
    }

    public void setDeactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
    }
}
