/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;

import java.util.Date;


/**
 * Two conversion service for association add/update actions.
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class PersonAssociationConversionService extends AddressConversionService
{
	public Object convert(Object source, Class targetClass)
	throws ConversionServiceException
	{
	    return null;
	}
	
    protected void convertBean(Object source, Object target) 
	throws ConversionServiceException
	{
        // Convert PersonAssociationInfoForm to Association
        if(source instanceof PersonAssociationInfoForm && target instanceof Association)
        {
            try
            {
                PersonAssociationInfoForm form = (PersonAssociationInfoForm)source;
                Association association = (Association)target; 
                
                association.setRelationship(StringUtils.isBlank(form.getRelationship()) ? null : form.getRelationship());
                
                if(StringUtils.isNotEmpty(form.getRole()))
                {
                    AssociationType type = (AssociationType)getLookupCacheService().getByCodeFromCache(AssociationType.class,form.getRole());
                    association.setType(type);
                }
                else
                {
                    association.setType(null);
                }
                
                association.setOrganizationName(StringUtils.isBlank(form.getOrganizationName()) ? null : form.getOrganizationName());
                association.setFirstName(StringUtils.isBlank(form.getFirstName()) ? null : form.getFirstName());
                association.setMiddleName(StringUtils.isBlank(form.getMiddleName()) ? null : form.getMiddleName());
                association.setLastName(StringUtils.isBlank(form.getLastName()) ? null : form.getLastName());
                
                
                if (form.isAnyAddressFieldFilled())
                {
                    // Get the address methods
                    Address address = association.getAddress();
                    if (address == null)
                    {
                        address = new Address();
                        association.setAddress(address);
                    }

                    // Convert the standard address fields
                    convertFormToAddress(form, address);
                }
                else
                {
                    // If no address fields are filled, remove the address object
                    association.setAddress(null);
                }

                association.setPrimaryPhone(StringUtils.isBlank(form.getPhone()) ? null : Phone.getFormattedPhone(form.getPhone()));
                association.setDeactivationDate(DateUtils.getDate(form.getDeactivationDate()));
            }
            catch(Exception ex)
            {
                throw new ConversionServiceException("Error while converting PersonAssociationInfoForm to Association.",ex);
            }
        }
        // Convert Association to PersonAssociationInfoForm 
        else if(source instanceof Association && target instanceof PersonAssociationInfoForm)
        {
            try
            {
                Association association = (Association)source;
                PersonAssociationInfoForm form = (PersonAssociationInfoForm)target;
                
                form.setRelationship(association.getRelationship());
                
                if(association.getType() != null)
                {
                    form.setRole(association.getType().getCode());
                }
                
                form.setOrganizationName(association.getOrganizationName());
               	form.setFirstName(association.getFirstName());
               	form.setMiddleName(association.getMiddleName());
               	form.setLastName(association.getLastName());
            	
            	// Get the association address
                Address address = association.getAddress();
                if (address != null)
                {
                    // Convert the standard address fields
                    convertAddressToForm(address,form);
                }
                
                form.setPhone(Phone.getFormattedPhone(association.getPrimaryPhone()));
                Date phoneChangeDate = association.getPrimaryPhoneChangeDate();
                if(phoneChangeDate != null)
                {
                    form.setPhoneChangeDate(DateUtils.formatWithTime(phoneChangeDate, null));
                }
                form.setDeactivationDate(DateUtils.format(association.getDeactivationDate(), null));
            }
            catch(Exception ex)
            {
                throw new ConversionServiceException("Error while converting Association to PersonAssociationInfoForm.",ex);
            }
        }
	}
}