/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.ui.demographic.action;

// Java Classes
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.model.EntityKey;

// ESR Classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressValidationAction;

/**
 * Action handler for the association overview screen.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class PersonAssociationAction extends AddressValidationAction
{
	public static final String DISPLAY = "display";

	public static final String OVERVIEW = "overview";
	public static final String OVERVIEW_WITH_MESSAGE = "overviewWithMessage";

	public static final String ASSOCIATE_ID = "associateId";

	public static final String ASSOCIATE_KEY = "associateKey";
	public static final String ASSOCIATIONS = "associations";
	public static final String USER_ACTION = "userAction";

	public static final String MESSAGE_ASSOCIATE_NOT_FOUND = "message.associateNotFound";
	public final static String MESSAGE_ASSOCIATION_ADDED   = "message.association.added";
	public final static String MESSAGE_ASSOCIATION_UPDATED = "message.association.updated";
	
	public void afterPropertiesSet() 
	{
		Validate.notNull( this.getAssociationService(), "An association service is a required component" );
	}

	/**
	 * Displays the association overview screen.
	 * 
	 * @param mapping
	 *           Struts action mapping for this action
	 * @param actionForm
	 *           Struts form bean for this action
	 * @param request
	 *           The Http Request
	 * @param response
	 *           The Http Response
	 * @return A struts action forward for where we will go next.
	 * @throws Exception
	 *            If there are any errors during processing.
	 */
	public ActionForward overview(ActionMapping mapping, ActionForm actionForm,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception 
	{
		Person person = getSelectedPerson(request);
		List associations = getSortedAssociations(person);
		request.setAttribute(ASSOCIATIONS, associations);
		return mapping.findForward(DISPLAY);
	}

	/**
	 * Handler user action when he clicks on cancel button.
	 * 
	 * @param mapping
	 *           Struts action mapping for this action
	 * @param actionForm
	 *           Struts form bean for this action
	 * @param request
	 *           The Http Request
	 * @param response
	 *           The Http Response
	 * @return A struts action forward for where we will go next.
	 * @throws Exception
	 *            If there are any errors during processing.
	 */
	public ActionForward cancel(ActionMapping mapping, ActionForm actionForm,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception 
	{
		return mapping.findForward(OVERVIEW);
	}

	/**
	 * Gets the association from the person object by the id.
	 * 
	 * @param person
	 *           the person object
	 * @param associateId
	 *           the association id
	 * @return the association or null.
	 */
	protected Association getAssociationById(Person person, String associateId) 
	{
		EntityKey key = CommonEntityKeyFactory.createAssociationEntityKey(associateId);
		return person.getAssociationByEntityKey(key);
	}
	
	/**
	 * Sorts the associations on association type.
	 * 
	 * @param person the person object
	 * @return sorted association list.
	 */
	private List getSortedAssociations(Person person) 
	{
        List associations = new ArrayList(person.getAssociations());
        Collections.sort(associations);
        return associations;
    }
}
