/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.fw.util.StringUtils;

/**
 * @author DNS   KATIKM
 * 
 */
public class InsuranceMedicareForm extends AddressForm {

    private static final long serialVersionUID = -8481348593320569813L;

    public static final String INSURANCE_MEDICARE = "Medicare";

    public final static String Y = "y";

    public final static String N = "n";

    public final static String PartA = "Part A";

    public final static String PartB = "Part B";

    public final static String PartAB = "Part A and B";

    public final static String ERRORS_REQUIRED2 = "errors.required2";

    private List typeOfMedicareList;

    // Common Fields
    private String typeOfMedicare;

    private String insCompanyName;

    // Medicare Part A fields
    private String insuranceId;

    private String groupName;

    private String groupNumber;

    private String sourceOfUpdate;

    private String medicareClaimNbr;

    private String nameOnMedicareCard;

    private String partAEffectiveDate;

    private String phone;

    private String fax;

    // Medicare Part B fields
    private String partBInsuranceId;

    private String partBGroupName;

    private String partBGroupNumber;

    private String partBSourceOfUpdate;

    private String partBMedicareClaimNbr;

    private String partBNameOnMedicareCard;

    private String partBEffectiveDate;

    private String partBPhone;

    private String partBFax;
    
    private String dateOfBirth = null; //hidden

    //ccr 10116
    private String dateOfDeath = null; //hidden
    protected String addressLine12;

    protected String addressLine22;

    protected String addressLine32;

    protected String city2;

    protected String county2;

    protected String state2;

    protected String prevZip2;

    protected String zipCode2;

    protected String zipPlus42;

    protected String country2;

    protected String province2;

    protected String postalCode2;

    public InsuranceMedicareForm() {
        super();
        init();
    }

    public List getTypeOfMedicareList() {
        if (typeOfMedicareList == null) {
            List typeOfMedicareList = new ArrayList();
            typeOfMedicareList.add(new LabelValueBean("Part A", "Part A"));
            typeOfMedicareList.add(new LabelValueBean("Part A and B",
                    "Part A and B"));
        }
        return typeOfMedicareList;
    }

    public void reset(ActionMapping arg0, ServletRequest arg1) {
        super.reset(arg0, arg1);
        init();
    }

    public void init() {
        typeOfMedicare = PartA;
        insCompanyName = INSURANCE_MEDICARE;
        groupName = PartA;
        groupNumber = PartA;
        partBGroupName = PartB;
        partBGroupNumber = PartB;
        country = Country.CODE_USA.getName();
        country2 = Country.CODE_USA.getName();
    }

    public void copyPartAtoB() {
        partBSourceOfUpdate = sourceOfUpdate;
        partBMedicareClaimNbr = medicareClaimNbr;
        partBNameOnMedicareCard = nameOnMedicareCard;
        partBPhone = phone;
        partBFax = fax;
        addressLine12 = addressLine1;
        addressLine22 = addressLine2;
        addressLine32 = addressLine3;
        city2 = city;
        county2 = county;
        state2 = state;
        prevZip2 = prevZip;
        zipCode2 = zipCode;
        zipPlus42 = zipPlus4;
        country2 = country;
        /*Defect294787-Medicare-part A and B -copy A for B -update data will be shown - REEG_00012084*/
        partBEffectiveDate=partAEffectiveDate;
    }

    public String getAddressLine12() {
        return addressLine12;
    }

    public String getAddressLine22() {
        return addressLine22;
    }

    public String getAddressLine32() {
        return addressLine32;
    }

    public String getCity2() {
        return city2;
    }

    public String getCountry2() {
        return country2;
    }

    public String getCounty2() {
        return county2;
    }

    public String getFax() {
        return fax;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupNumber() {
        return groupNumber;
    }

    public String getInsCompanyName() {
        return insCompanyName;
    }

    public String getInsuranceId() {
        return insuranceId;
    }

    public String getMedicareClaimNbr() {
        return medicareClaimNbr;
    }

    public String getNameOnMedicareCard() {
        return nameOnMedicareCard;
    }

    public String getPartAEffectiveDate() {
        return partAEffectiveDate;
    }

    public String getPartBEffectiveDate() {
        return partBEffectiveDate;
    }

    public String getPartBFax() {
        return partBFax;
    }

    public String getPartBGroupName() {
        return partBGroupName;
    }

    public String getPartBGroupNumber() {
        return partBGroupNumber;
    }

    public String getPartBInsuranceId() {
        return partBInsuranceId;
    }

    public String getPartBMedicareClaimNbr() {
        return partBMedicareClaimNbr;
    }

    public String getPartBNameOnMedicareCard() {
        return partBNameOnMedicareCard;
    }

    public String getPartBPhone() {
        return partBPhone;
    }

    public String getPartBSourceOfUpdate() {
        return partBSourceOfUpdate;
    }

    public String getPhone() {
        return phone;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public String getPostalCode2() {
        return postalCode2;
    }

    public String getProvince() {
        return province;
    }

    public String getProvince2() {
        return province2;
    }

    public String getSourceOfUpdate() {
        return sourceOfUpdate;
    }

    public String getState() {
        return state;
    }

    public String getState2() {
        return state2;
    }

    public String getTypeOfMedicare() {
        return typeOfMedicare;
    }

    public String getPrevZip2() {
        return prevZip2;
    }

    public void setPrevZip2(String prevZip2) {
        this.prevZip2 = prevZip2;
    }

    public String getZipCode() {
        return zipCode;
    }

    public String getZipCode2() {
        return zipCode2;
    }

    public String getZipPlus4() {
        return zipPlus4;
    }

    public String getZipPlus42() {
        return zipPlus42;
    }

    public int getZipCode2Length() {
        return zipCode2 != null ? zipCode2.length() : 0;
    }

    public int getZipPlus42Length() {
        return zipPlus42 != null ? zipPlus42.length() : 0;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public void setAddressLine12(String addressLine12) {
        this.addressLine12 = addressLine12;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public void setAddressLine22(String addressLine22) {
        this.addressLine22 = addressLine22;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public void setAddressLine32(String addressLine32) {
        this.addressLine32 = addressLine32;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCity2(String city2) {
        this.city2 = city2;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setCountry2(String country2) {
        this.country2 = country2;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public void setCounty2(String county2) {
        this.county2 = county2;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    public void setInsCompanyName(String insCompanyName) {
        this.insCompanyName = insCompanyName;
    }

    public void setInsuranceId(String insuranceId) {
        this.insuranceId = insuranceId;
    }

    public void setMedicareClaimNbr(String medicareClaimNbr) {
        this.medicareClaimNbr = medicareClaimNbr;
    }

    public void setNameOnMedicareCard(String nameOnMedicareCard) {
        this.nameOnMedicareCard = nameOnMedicareCard;
    }

    public void setPartAEffectiveDate(String partAEffectiveDate) {
        this.partAEffectiveDate = partAEffectiveDate;
    }

    public void setPartBEffectiveDate(String partBEffectiveDate) {
        this.partBEffectiveDate = partBEffectiveDate;
    }

    public void setPartBFax(String partBFax) {
        this.partBFax = partBFax;
    }

    public void setPartBGroupName(String partBGroupName) {
        this.partBGroupName = partBGroupName;
    }

    public void setPartBGroupNumber(String partBGroupNumber) {
        this.partBGroupNumber = partBGroupNumber;
    }

    public void setPartBInsuranceId(String partBInsuranceId) {
        this.partBInsuranceId = partBInsuranceId;
    }

    public void setPartBMedicareClaimNbr(String partBMedicareClaimNbr) {
        this.partBMedicareClaimNbr = partBMedicareClaimNbr;
    }

    public void setPartBNameOnMedicareCard(String partBNameOnMedicareCard) {
        this.partBNameOnMedicareCard = partBNameOnMedicareCard;
    }

    public void setPartBPhone(String partBPhone) {
        this.partBPhone = partBPhone;
    }

    public void setPartBSourceOfUpdate(String partBSourceOfUpdate) {
        this.partBSourceOfUpdate = partBSourceOfUpdate;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setPostalCode2(String postalCode2) {
        this.postalCode2 = postalCode2;
    }

    public void setProvince2(String province2) {
        this.province2 = province2;
    }

    public void setSourceOfUpdate(String sourceOfUpdate) {
        this.sourceOfUpdate = sourceOfUpdate;
    }

    public void setState2(String state2) {
        this.state2 = state2;
    }

    public void setTypeOfMedicare(String typeOfMedicare) {
        this.typeOfMedicare = typeOfMedicare;
    }

    public void setTypeOfMedicareList(List typeOfMedicareList) {
        this.typeOfMedicareList = typeOfMedicareList;
    }

    public void setZipCode2(String zipCode2) {
        this.zipCode2 = zipCode2;
    }

    public void setZipPlus42(String zipPlus42) {
        this.zipPlus42 = zipPlus42;
    }
    public String getDateOfBirth()
    {
        return dateOfBirth;
    }
    public void setDateOfBirth(String dateOfBirth)
    {
        this.dateOfBirth = dateOfBirth;
    }
    //ccr 10116 Medicare Insurance (Part a & Part B) Effective Date cannot be after DOD
    public String getDateOfDeath()
    {
        return dateOfDeath;
    }
    public void setDateOfDeath(String dateOfDeath)
    {
        this.dateOfDeath = dateOfDeath;
    }
    public boolean isAnyAddress2FieldFilled() {
        if (StringUtils.isNotEmpty(addressLine12)
                || StringUtils.isNotEmpty(addressLine22)
                || StringUtils.isNotEmpty(addressLine32)
                || StringUtils.isNotEmpty(city2)
                || StringUtils.isNotEmpty(county2)
                || StringUtils.isNotEmpty(state2)
                || StringUtils.isNotEmpty(zipCode2)
                || StringUtils.isNotEmpty(zipPlus4)) {
            return true;
        }
        return false;
    }

    public ActionErrors validate(ActionMapping mapping,
            HttpServletRequest request) {
        ActionErrors validationErrors = super.validate(mapping, request);
        return validateInsuranceAddress2(mapping, request, validationErrors);
    }

    private ActionErrors validateInsuranceAddress2(ActionMapping mapping,
            HttpServletRequest request, ActionErrors errors) {
        MessageResources messageResources = this.getResources(request);

        // Part A
        if (isAnyAddressFieldFilled()) {
            if (StringUtils.isEmpty(this.getAddressLine1())) {
                errors.add(ADDRESS_LINE1,
                        new ActionMessage(ERRORS_REQUIRED2, messageResources
                                .getMessage(LABEL_ADDRESS_LINE1), PartA));
            }
            if (StringUtils.isEmpty(this.getZipCode())) {
                errors.add(ZIP_CODE, new ActionMessage(ERRORS_REQUIRED2,
                        messageResources.getMessage(LABEL_ZIP_CODE), PartA));
            }
            if (StringUtils.isEmpty(this.getCity())) {
                errors.add(CITY, new ActionMessage(ERRORS_REQUIRED2,
                        messageResources.getMessage(LABEL_CITY), PartA));
            }
            if (StringUtils.isEmpty(this.getState())) {
                errors.add(STATE, new ActionMessage(ERRORS_REQUIRED2,
                        messageResources.getMessage(LABEL_STATE), PartA));
            }
        }

        // Part B
        if (isAnyAddress2FieldFilled()) {
            if (StringUtils.isEmpty(this.getAddressLine12())) {
                errors.add(ADDRESS_LINE1 + "2", new ActionMessage(
                        ERRORS_REQUIRED2, messageResources
                                .getMessage(LABEL_ADDRESS_LINE1), PartB));
            }
            if (StringUtils.isEmpty(this.getZipCode2())) {
                errors.add(ZIP_CODE + "2", new ActionMessage(ERRORS_REQUIRED2,
                        messageResources.getMessage(LABEL_ZIP_CODE), PartB));
            }
            if (StringUtils.isEmpty(this.getCity2())) {
                errors.add(CITY + "2", new ActionMessage(ERRORS_REQUIRED2,
                        messageResources.getMessage(LABEL_CITY), PartB));
            }
            if (StringUtils.isEmpty(this.getState2())) {
                errors.add(STATE + "2", new ActionMessage(ERRORS_REQUIRED2,
                        messageResources.getMessage(LABEL_STATE), PartB));
            }
        }
        return errors;
    }
}
