/********************************************************************
 * Copyright  2004-2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

// Java Classes
import java.util.ArrayList;
import java.util.List;

// Library Classes
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;

// ESR Classes
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;

/**
 * The insurance information form.
 */
public class InsuranceInfoForm extends AddressForm
{
    private static final long serialVersionUID = -479648099832894889L;
    
    public final static String Y = "y";
    public final static String N = "n";

    public final static String PartA = "Part A";
    public final static String PartB = "Part B";
    public final static String PartAB = "Part A and B";

    private List hecInsurances = null;
    private List siteInsurances = null;

    private String insuranceId;
    private boolean medicareInd = false;

    private String insCompanyName;
    private String groupName;
    private String groupNumber;
    private String nameOfInsured;
    private String relationshipToVeteran;
    private String typeOfIns;
    private String typeOfMedicare;
    private List typeOfMedicareList;
    private String subscriberId;
    private String effDate;
    private String expDate;
    private String precertReq;
    private String sourceOfUpdate;
    private String policyNumber;

    private String medicareClaimNbr;
    private String nameOnMedicareCard;
    private String isEnrolledInPartA;
    private String isEnrolledInPartB;
    private String partAEffectiveDate;
    private String partBEffectiveDate;
    private String preCertificationPhone;
    private String phone;
    private String fax;
    private String dateOfDeath = null; //hidden
    private String dateOfBirth = null; //hidden
    /**
     * Default Constructor.
     */
    public InsuranceInfoForm()
    {
        super();
    }

    /**
     * @return medicareInsurance for hec
     */
    public List getHecInsurances()
    {
        return hecInsurances;
    }

    public void setHecInsurances(List insurances)
    {
        this.hecInsurances = insurances;
    }

    public void addHecInsurance(InsurancePolicy insurance)
    {
        if (this.hecInsurances == null)
        {
            this.hecInsurances = new ArrayList();
        }
        this.hecInsurances.add(insurance);
    }

    /**
     * @return medicareInsurance for site
     */
    public List getSiteInsurances()
    {
        return siteInsurances;
    }

    public void setSiteInsurances(List insurances)
    {
        this.siteInsurances = insurances;
    }

    public void addSiteInsurance(InsurancePolicy insurance)
    {
        if (this.siteInsurances == null)
        {
            this.siteInsurances = new ArrayList();
        }
        this.siteInsurances.add(insurance);
    }

    public boolean getHecInsurancePresent()
    {
        return ((this.hecInsurances != null) && (this.hecInsurances.size() > 0));
    }

    public boolean getSiteInsurancePresent()
    {
        return ((this.siteInsurances != null) && (this.siteInsurances.size() > 0));
    }

    public boolean getAnyInsurancePresent()
    {
        return getHecInsurancePresent() || getSiteInsurancePresent();
    }

    /**
     * @return Returns the insuranceId.
     */
    public String getInsuranceId()
    {
        return insuranceId;
    }

    /**
     * @param insuranceId The insuranceId to set.
     */
    public void setInsuranceId(String insuranceId)
    {
        this.insuranceId = insuranceId;
    }

    /**
     * @return Returns the carrier.
     */
    public String getInsCompanyName()
    {
        return insCompanyName;
    }

    /**
     * @param insCompanyName The carrier to set.
     */
    public void setInsCompanyName(String insCompanyName)
    {
        this.insCompanyName = insCompanyName;
    }

    /**
     * @return Returns the effDate.
     */
    public String getEffDate()
    {
        return effDate;
    }

    /**
     * @param effDate The effDate to set.
     */
    public void setEffDate(String effDate)
    {
        this.effDate = effDate;
    }

    /**
     * @return Returns the expDate.
     */
    public String getExpDate()
    {
        return expDate;
    }

    /**
     * @param expDate The expDate to set.
     */
    public void setExpDate(String expDate)
    {
        this.expDate = expDate;
    }

    /**
     * @return Returns the fax.
     */
    public String getFax()
    {
        return fax;
    }

    /**
     * @param fax The fax to set.
     */
    public void setFax(String fax)
    {
        this.fax = fax;
    }

    /**
     * @return Returns the groupName.
     */
    public String getGroupName()
    {
        return groupName;
    }

    /**
     * @param groupName The groupName to set.
     */
    public void setGroupName(String groupName)
    {
        this.groupName = groupName;
    }

    /**
     * @return Returns the groupNumber.
     */
    public String getGroupNumber()
    {
        return groupNumber;
    }

    /**
     * @param groupNumber The groupNumber to set.
     */
    public void setGroupNumber(String groupNumber)
    {
        this.groupNumber = groupNumber;
    }

    /**
     * @return Returns the medicareClaimNbr.
     */
    public String getMedicareClaimNbr()
    {
        return medicareClaimNbr;
    }

    /**
     * @param medicareNbr The medicareClaimNbr to set.
     */
    public void setMedicareClaimNbr(String medicareNbr)
    {
        medicareClaimNbr = medicareNbr;
    }

    /**
     * @return Returns the nameOfInsured.
     */
    public String getNameOfInsured()
    {
        return nameOfInsured;
    }

    /**
     * @param nameOfInsured The nameOfInsured to set.
     */
    public void setNameOfInsured(String nameOfInsured)
    {
        this.nameOfInsured = nameOfInsured;
    }

    /**
     * @return Returns the phone.
     */
    public String getPhone()
    {
        return phone;
    }

    /**
     * @param phone The phone to set.
     */
    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPreCertificationPhone()
    {
        return preCertificationPhone;
    }

    public void setPreCertificationPhone(String preCertificationPhone)
    {
        this.preCertificationPhone = preCertificationPhone;
    }

    /**
     * @return Returns the policyNumber.
     */
    public String getPolicyNumber()
    {
        return policyNumber;
    }

    /**
     * @param policyNumber The policyNumber to set.
     */
    public void setPolicyNumber(String policyNumber)
    {
        this.policyNumber = policyNumber;
    }

    /**
     * @return Returns the precertReq.
     */
    public String getPrecertReq()
    {
        return precertReq;
    }

    /**
     * @param precertReq The precertReq to set.
     */
    public void setPrecertReq(String precertReq)
    {
        this.precertReq = precertReq;
    }

    /**
     * @return Returns the relationshipToVeteran.
     */
    public String getRelationshipToVeteran()
    {
        return relationshipToVeteran;
    }

    /**
     * @param relationshipToVeteran The relationshipToVeteran to set.
     */
    public void setRelationshipToVeteran(String relationshipToVeteran)
    {
        this.relationshipToVeteran = relationshipToVeteran;
    }

    /**
     * @return Returns the sourceOfUpdate.
     */
    public String getSourceOfUpdate()
    {
        return sourceOfUpdate;
    }

    /**
     * @param sourceOfUpdate The sourceOfUpdate to set.
     */
    public void setSourceOfUpdate(String sourceOfUpdate)
    {
        this.sourceOfUpdate = sourceOfUpdate;
    }

    /**
     * @return Returns the subscriberId.
     */
    public String getSubscriberId()
    {
        return subscriberId;
    }

    /**
     * @param subscriberId The subscriberId to set.
     */
    public void setSubscriberId(String subscriberId)
    {
        this.subscriberId = subscriberId;
    }

    /**
     * @return Returns the typeOfIns.
     */
    public String getTypeOfIns()
    {
        return typeOfIns;
    }

    /**
     * @param typeOfIns The typeOfIns to set.
     */
    public void setTypeOfIns(String typeOfIns)
    {
        this.typeOfIns = typeOfIns;
    }

    /**
     * @return Returns the isEnrolledInPartA.
     */
    public String getIsEnrolledInPartA()
    {
        return isEnrolledInPartA;
    }

    /**
     * @param isEnrolledInPartA The isEnrolledInPartA to set.
     */
    public void setIsEnrolledInPartA(String isEnrolledInPartA)
    {
        this.isEnrolledInPartA = isEnrolledInPartA;
    }

    /**
     * @return Returns the isEnrolledInPartB.
     */
    public String getIsEnrolledInPartB()
    {
        return isEnrolledInPartB;
    }

    /**
     * @param isEnrolledInPartB The isEnrolledInPartB to set.
     */
    public void setIsEnrolledInPartB(String isEnrolledInPartB)
    {
        this.isEnrolledInPartB = isEnrolledInPartB;
    }

    /**
     * @return Returns the nameOnMedicareCard.
     */
    public String getNameOnMedicareCard()
    {
        return nameOnMedicareCard;
    }

    /**
     * @param nameOnMedicareCard The nameOnMedicareCard to set.
     */
    public void setNameOnMedicareCard(String nameOnMedicareCard)
    {
        this.nameOnMedicareCard = nameOnMedicareCard;
    }

    /**
     * @return Returns the partAEffectiveDate.
     */
    public String getPartAEffectiveDate()
    {
        return partAEffectiveDate;
    }

    /**
     * @param partAEffectiveDate The partAEffectiveDate to set.
     */
    public void setPartAEffectiveDate(String partAEffectiveDate)
    {
        this.partAEffectiveDate = partAEffectiveDate;
    }

    /**
     * @return Returns the partBEffectiveDate.
     */
    public String getPartBEffectiveDate()
    {
        return partBEffectiveDate;
    }

    /**
     * @param partBEffectiveDate The partBEffectiveDate to set.
     */
    public void setPartBEffectiveDate(String partBEffectiveDate)
    {
        this.partBEffectiveDate = partBEffectiveDate;
    }

    /**
     * @return Returns the medicareInd.
     */
    public boolean getMedicareInd()
    {
        return medicareInd;
    }

    /**
     * @param medicareInd The medicareInd to set.
     */
    public void setMedicareInd(boolean medicareInd)
    {
        this.medicareInd = medicareInd;
    }

    /**
     * @return Returns the typeOfMedicare.
     */
    public String getTypeOfMedicare()
    {
        return typeOfMedicare;
    }

    /**
     * @param typeOfMedicare The typeOfMedicare to set.
     */
    public void setTypeOfMedicare(String typeOfMedicare)
    {
        this.typeOfMedicare = typeOfMedicare;
    }

    /**
     * @return Returns the typeOfMedicareList.
     */
    public List getTypeOfMedicareList()
    {
        if (typeOfMedicareList == null)
        {
            typeOfMedicareList = new ArrayList();
            typeOfMedicareList.add(new LabelValueBean("A", "Part A"));
            typeOfMedicareList.add(new LabelValueBean("B", "Part B"));
            typeOfMedicareList.add(new LabelValueBean("A and B", "Part A and B"));
        }
        return typeOfMedicareList;
    }

    /**
     * @param typeOfMedicareList The typeOfMedicareList to set.
     */
    public void setTypeOfMedicareList(List typeOfMedicareList)
    {
        this.typeOfMedicareList = typeOfMedicareList;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
        ActionErrors validationErrors = super.validate(mapping, request);
        return validateOptionalAddress(mapping, request, validationErrors);
    }
    public String getDateOfDeath()
    {
        return dateOfDeath;
    }
    public void setDateOfDeath(String dateOfDeath)
    {
        this.dateOfDeath = dateOfDeath;
    }
    public String getDateOfBirth()
    {
        return dateOfBirth;
    }
    public void setDateOfBirth(String dateOfBirth)
    {
        this.dateOfBirth = dateOfBirth;
    }
}
