/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

// Java classes
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Set;
import java.util.List;
import java.util.Collections;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// ESR Classes
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.ui.util.SessionManager;

/**
 * @author DNS   RAMACP
 * @author Andrew Pach
 */
public class InsuranceInfoAction extends AddressValidationAction
{
    // Struts Forwards
    public static final String FORWARD_RETURN_TO_SAME_PAGE = "success";
    public static final String FORWARD_TO_OVERVIEW_PAGE = "overview";

    /**
     * Default Constructor.
     */
    public InsuranceInfoAction()
    {
        super();
    }

    /**
     * Displays the page.
     *
     * @param mapping An action mapping
     * @param form A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     *
     * @return An action forward class encapsulating information about a next page
     * @throws Exception Thrown if failed to process
     */
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception
    {
        InsuranceInfoForm insForm = (form instanceof InsuranceInfoForm) ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
	        boolean isAddAPerson = false;
	        isAddAPerson = SessionManager.isAddAPerson(request);
	        insForm.setAddAPerson(isAddAPerson);
	        
	        getInsuranceInfo(insForm, getSelectedPerson(request));
        }
        return mapping.findForward("success");
    }

    /**
     * Adds a private insurance record.
     *
     * @param mapping An action mapping
     * @param form A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     *
     * @return An action forward class encapsulating information about a next page
     * @throws Exception Thrown if failed to process
     */
    public ActionForward addPrivateIns(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception
    {
        InsuranceInfoForm insForm = (form instanceof InsuranceInfoForm) ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
	        insForm.setMedicareInd(false);
	        boolean isAddAPerson = false;
	        isAddAPerson = SessionManager.isAddAPerson(request);
	        insForm.setAddAPerson(isAddAPerson);
        }
        return mapping.findForward("addPrivateIns");
    }

    /**
     * Adds a medicare insurance record.
     *
     * @param mapping An action mapping
     * @param form A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     *
     * @return An action forward class encapsulating information about a next page
     * @throws Exception Thrown if failed to process
     */
    public ActionForward addMedicare(ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws Exception
    {
        InsuranceInfoForm insForm = (form instanceof InsuranceInfoForm) ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
	        insForm.setMedicareInd(true);
	        boolean isAddAPerson = false;
	        isAddAPerson = SessionManager.isAddAPerson(request);
	        insForm.setAddAPerson(isAddAPerson);
        }
        return mapping.findForward("addMedicare");
    }

    /**
     * Set the Insurance attributes of the form.
     *
     * @param form Reference to the ActionForm
     * @param person Source Person object from which to retrieve the Insurance field values
     */
    private void getInsuranceInfo(InsuranceInfoForm form, Person person)
    {
        // Sort the insurances to a predictable order
        List insurances = new ArrayList(person.getInsurances());
        Collections.sort(insurances);

        // Iterate through each insurance record
        Iterator iter = insurances.iterator();
        while (iter.hasNext())
        {
            InsurancePolicy insPolicy = (InsurancePolicy)iter.next();

            if (insPolicy.isSiteRecord())
            {
                form.addSiteInsurance(insPolicy);
            }
            else
            {
                form.addHecInsurance(insPolicy);
            }
        }
    }

    /**
     * Gets an insurance policy by Id.
     * @param person The person
     * @param insuranceId The insurance Id of the policy to get
     * @return the insurance policy or null if one doesn't exist for the specified Id.
     */
    protected InsurancePolicy getInsuranceById(Person person, String insuranceId)
    {
        BigDecimal id = new BigDecimal(insuranceId);
        Set insurances = person.getInsurances();
        if ((insurances != null) && (!insurances.isEmpty()))
        {
            Iterator iter = insurances.iterator();
            while (iter.hasNext())
            {
                InsurancePolicy insurancePolicy = (InsurancePolicy)iter.next();
                if ((insurancePolicy != null && insurancePolicy.getEntityKey()!=null && id!=null ) && (id.equals(insurancePolicy.getEntityKey().getKeyValue())))
                {
                    return insurancePolicy;
                }
            }
        }

        // It wasn't found so return null
        return null;
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
        // Checked for required components here
    }
}
 