/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

// Java Classes

// Library Classes

// Framework Classes
// import gov.va.med.fw.ui.struts.AbstractForm;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.esr.ui.common.action.AddressForm;
// ESR Classes
import gov.va.med.fw.util.StringUtils;

/**
 * This is the form used in conjunction with the Demographics Personal page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DemographicPersonalForm extends AddressForm
{
    private static final long serialVersionUID = 4753426470546054487L;

    public static final String FIELD_DOD = "dateOfDeath";
    public static final String LABEL_DOD = "label.personal.dateOfDeath";
    public static final String LABEL_DEATH_NOT_SOURCE = "label.personal.deathNotificationSource";
    public static final String LABEL_DEATH_NOT_SITE = "label.personal.deathNotificationSite";
    public final static String ERRORS_REQUIRED2 = "errors.required2";
    public final static String EMPLOYERINFO = "Employer";
    /**
     * Default constructor.
     */
    public DemographicPersonalForm()
    {
        super();
        init();
    }

    //fields are in the order they appear on the screen
    private boolean sensitivityFlag = false;
    private String sensitivityFlagSourceOfUpdate;
    private String sensitivityFlagSiteOfUpdate;
    private String degree = null; // None Masters of Education PHD
    private String otherNames = null;
    private String otherLastNames = null;
    private String otherFirstNames = null;
    private String otherSsns = null;
    private String employmentStatus = null; // Select
    private String onFileEmploymentStatus = null; // Hidden
    private String dateOfDeath = null; // mm/dd/yyyy
    private String deathNotificationSource = null;
    private String deathNotificationSite = null;
    private String dateOfDeathReport = null; // mm/dd/yyyy
   // private String deathVerifyStatus = null; //verified/unverified
    
    // CCR10640 -- allow multiple preferred facilities
    /*private String preferredFacility = null; */     
    private List preferredFacilityIds = new ArrayList();
    private List preferredFacilitySites = new ArrayList();
    private List preferredFacilitySDs = new ArrayList();  // source designation
    
    private String languageEntryDate = null; // mm/dd/yyyy
    private String preferredLanguageCode = null;
    private List languages = new ArrayList();
    
    
    private String claimFolderNumber = null;
    private String claimFolderLocation = null; // Select
    private String userEnrolleeValidthroughDate = null;
    private String userEnrolleeSite = null; // Select ?
    private String appointmentRequestDate = null; // mm/dd/yyyy
    private String appointmentRequestResponse = null;
    private String ssn = null;
    private String[] emergencyResponse = {};
    private String maritalStatus = null;
    private String religion = null;
    private String fathersName = null;
    private String mothersName = null;
    private String fathersLastName = null;
    private String mothersLastName = null;
    private String fathersFirstName = null;
    private String mothersFirstName = null;
    private String employerName = null;
    private String occupation = null;
    private String employerAddress = null;
    private String employerPhone = null;
    private String retirementDate = null;
    private String benefitAppliedFor = null;
    private String needCareDueToInjury = null;
    private String needCareDueToAccident = null;
    
    private boolean dodEditableFlag = false;
    private boolean showAllDeathSourcesFlag = false;
    //private String dodVerificationIndicator = null;
    private String deathNotificationSourceDesc = null;
    private String deathNotificationSiteName = null;

    
     public String getAppointmentRequestDate()
    {
        return appointmentRequestDate;
    }

    public String getAppointmentRequestResponse()
    {
        return appointmentRequestResponse;
    }

    public String getClaimFolderLocation()
    {
        return claimFolderLocation;
    }

    public String getClaimFolderNumber()
    {
        return claimFolderNumber;
    }

    public String getDateOfDeath()
    {
        return dateOfDeath;
    }

    public String getDateOfDeathReport()
    {
        return dateOfDeathReport;
    }

    public String getDeathNotificationSite()
    {
        return deathNotificationSite;
    }

    public String getDeathNotificationSource()
    {
        return deathNotificationSource;
    }
    
    /*
    public String getDeathVerifyStatus()
    {
        return deathVerifyStatus;
    }
    */
    public String getDegree()
    {
        return degree;
    }

    public String getEmploymentStatus()
    {
        return employmentStatus;
    }
    public String getOnFileEmploymentStatus()
    {
        return onFileEmploymentStatus;
    }

    public String getOtherNames()
    {
        return otherNames;
    }

    public String getOtherSsns()
    {
        return otherSsns;
    }

    public boolean isSensitivityFlag()
    {
        return sensitivityFlag;
    }

    public String getUserEnrolleeSite()
    {
        return userEnrolleeSite;
    }

    public String getUserEnrolleeValidthroughDate()
    {
        return userEnrolleeValidthroughDate;
    }

    public String getSsn()
    {
        return ssn;
    }

    public void setAppointmentRequestDate(String appointmentRequestDate)
    {
        this.appointmentRequestDate = appointmentRequestDate;
    }

    public void setAppointmentRequestResponse(String appointmentRequestResponse)
    {
        this.appointmentRequestResponse = appointmentRequestResponse;
    }

    public void setClaimFolderLocation(String claimFolderLocation)
    {
        this.claimFolderLocation = claimFolderLocation;
    }

    public void setClaimFolderNumber(String claimFolderNumber)
    {
        this.claimFolderNumber = claimFolderNumber;
    }

    public void setDateOfDeath(String dateOfDeath)
    {
        this.dateOfDeath = dateOfDeath;
    }

   /*
    public void setDeathVerifyStatus(String status)
    {
        this.deathVerifyStatus = status;
    }
    */
    public void setDateOfDeathReport(String dateOfDeathReport)
    {
        this.dateOfDeathReport = dateOfDeathReport;
    }

    public void setDeathNotificationSite(String deathNotificationSite)
    {
        this.deathNotificationSite = deathNotificationSite;
    }

    public void setDeathNotificationSource(String deathNotificationSource)
    {
        this.deathNotificationSource = deathNotificationSource;
    }

    public void setDegree(String degree)
    {
        this.degree = degree;
    }
    public void setOnFileEmploymentStatus(String onFileEmploymentStatus)
    {
        this.onFileEmploymentStatus = onFileEmploymentStatus;
      
    }
    public void setEmploymentStatus(String employmentStatus)
    {
           this.employmentStatus = employmentStatus;
        
    }

    public void setOtherNames(String otherNames)
    {
        this.otherNames = otherNames;
    }

    public void setOtherSsns(String otherSsns)
    {
        this.otherSsns = otherSsns;
    }

     public void setSensitivityFlag(boolean sensitivityFlag)
    {
        this.sensitivityFlag = sensitivityFlag;
    }

    public void setUserEnrolleeSite(String userEnrolleeSite)
    {
        this.userEnrolleeSite = userEnrolleeSite;
    }

    public void setUserEnrolleeValidthroughDate(String userEnrolleeValidthroughDate)
    {
        this.userEnrolleeValidthroughDate = userEnrolleeValidthroughDate;
    }

    public void setSsn(String ssn)
    {
        this.ssn = ssn;
    }

    public String[] getEmergencyResponse()
    {
        return emergencyResponse;
    }

    public void setEmergencyResponse(String[] emergencyResponse)
    {
        this.emergencyResponse = emergencyResponse;
    }

    public String getSensitivityFlagSourceOfUpdate()
    {
        return sensitivityFlagSourceOfUpdate;
    }

    public void setSensitivityFlagSourceOfUpdate(String sensitivityFlagSourceOfUpdate)
    {
        this.sensitivityFlagSourceOfUpdate = sensitivityFlagSourceOfUpdate;
    }

    public String getSensitivityFlagSiteOfUpdate()
    {
        return sensitivityFlagSiteOfUpdate;
    }

    public void setSensitivityFlagSiteOfUpdate(String sensitivityFlagSiteOfUpdate)
    {
        this.sensitivityFlagSiteOfUpdate = sensitivityFlagSiteOfUpdate;
    }
    
    public String getMaritalStatus() {
        return maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getReligion() {
        return religion;
    }

    public void setReligion(String religion) {
        this.religion = religion;
    }

    public String getFathersName() {
        return fathersName;
    }

    public void setFathersName(String fathersName) {
        this.fathersName = fathersName;
    }

    public String getMothersName() {
        return mothersName;
    }

    public void setMothersName(String mothersName) {
        this.mothersName = mothersName;
    }

    public String getEmployerAddress() {
        return employerAddress;
    }

    public void setEmployerAddress(String employerAddress) {
        this.employerAddress = employerAddress;
    }

    public String getEmployerName() {
        return employerName;
    }

    public void setEmployerName(String employerName) {
        this.employerName = employerName;
    }

    public String getEmployerPhone() {
        return employerPhone;
    }

    public void setEmployerPhone(String employerPhone) {
        this.employerPhone = employerPhone;
    }

    public String getOccupation() {
        return occupation;
    }

    public void setOccupation(String occupation) {
        this.occupation = occupation;
    }

    public String getRetirementDate() {
        return retirementDate;
    }

    public void setRetirementDate(String retirementDate) {
        this.retirementDate = retirementDate;
    }

    public String getBenefitAppliedFor() {
        return benefitAppliedFor;
    }

    public void setBenefitAppliedFor(String benefitAppliedFor) {
        this.benefitAppliedFor = benefitAppliedFor;
    }

	public String getFathersFirstName() {
		return fathersFirstName;
	}

	public void setFathersFirstName(String fathersFirstName) {
		this.fathersFirstName = fathersFirstName;
	}

	public String getFathersLastName() {
		return fathersLastName;
	}

	public void setFathersLastName(String fathersLastName) {
		this.fathersLastName = fathersLastName;
	}

	public String getMothersFirstName() {
		return mothersFirstName;
	}

	public void setMothersFirstName(String mothersFirstName) {
		this.mothersFirstName = mothersFirstName;
	}

	public String getMothersLastName() {
		return mothersLastName;
	}

	public void setMothersLastName(String mothersLastName) {
		this.mothersLastName = mothersLastName;
	}
	
	 public void init() {
	       // country = Country.CODE_USA.getName();
	    }

	 public ActionErrors validate(ActionMapping mapping,
	            HttpServletRequest request) {
	        ActionErrors validationErrors = super.validate(mapping, request);
	        
	        // TODO only check employer address when employer status is not NOT EMPLOYED
	        // TODO need to validate employer phone if entered as well here
	        
	        if ( this.isAddAPerson()){
	        	validateNamesEntered(mapping, request, validationErrors);
	        	validateOptionalAddressIncludingCountry(mapping, request, validationErrors);
	 		}
	        return validationErrors;
	}
	
	
	 protected ActionErrors validateNamesEntered(ActionMapping mapping, HttpServletRequest request, ActionErrors errors) {
		 	// MessageResources messageResources = this.getResources(request);
		    boolean firstCheckFlag = false;
		 	if (StringUtils.containsNumbers(this.getFathersLastName())){
		 		errors.add("FathersLastName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Father's Last Name can not contain numbers."));
		 		firstCheckFlag = true;
		 	}
		 	if (StringUtils.containsNumbers(this.getFathersFirstName())){
		 		errors.add("FathersFirstName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Father's First Name can not contain numbers."));
		 		firstCheckFlag = true;
		 	}
		 	if (StringUtils.containsNumbers(this.getMothersLastName())){
		 		errors.add("MothersLastName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Mother's Last Name can not contain numbers."));
		 		firstCheckFlag = true;
		 	}
		 	if (StringUtils.containsNumbers(this.getMothersFirstName())){
		 		errors.add("MothersFirstName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Mother's First Name can not contain numbers."));
		 		firstCheckFlag = true;
		 	}
		 	if (firstCheckFlag) return errors;
		 	
		 	if (StringUtils.isNotEmpty(this.getFathersFirstName()) && StringUtils.isEmpty(this.getFathersLastName()))
	        	errors.add("FathersLastName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Father's Last Name is required when first name is entered."));
	        if (StringUtils.isNotEmpty(this.getMothersFirstName()) && StringUtils.isEmpty(this.getMothersLastName()))
        		errors.add("MothersLastName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Mother's Last Name is required when first name is entered."));
	       
	       // errors.add(POSTAL_CODE,new ActionMessage(MessageKeys.ERRORS_REQUIRED,messageResources.getMessage(LABEL_POSTAL_CODE)));
	        return errors;
	 }
	 
	 
	public String getNeedCareDueToAccident() {
		return needCareDueToAccident;
	}

	public void setNeedCareDueToAccident(String needCareDueToAccident) {
		this.needCareDueToAccident = needCareDueToAccident;
	}

	public String getNeedCareDueToInjury() {
		return needCareDueToInjury;
	}

	public void setNeedCareDueToInjury(String needCareDueToInjury) {
		this.needCareDueToInjury = needCareDueToInjury;
	}

	public String getOtherFirstNames() {
		return otherFirstNames;
	}

	public void setOtherFirstNames(String otherFirstNames) {
		this.otherFirstNames = otherFirstNames;
	}

	public String getOtherLastNames() {
		return otherLastNames;
	}

	public void setOtherLastNames(String otherLastNames) {
		this.otherLastNames = otherLastNames;
	}
	
	   public int getPreferredFacilitySize()
	    {
	        return preferredFacilityIds.size();
	    }

	    public String getPreferredFacilityId(int index)
	    {
	        return (String)preferredFacilityIds.get(index);
	    }

	    public List getPreferredFacilityIds()
	    {
	        return preferredFacilityIds;
	    }

	    public void setPreferredFacilityId(int index, String PreferredFacilityId)
	    {
	        setElement(this.preferredFacilityIds, index, PreferredFacilityId);
	    }

	    public void setPreferredFacilityIds(List preferredFacilityIds)
	    {
	        this.preferredFacilityIds = preferredFacilityIds;
	    }

	    public String getPreferredFacilitySite(int index)
	    {
	        return (String)preferredFacilitySites.get(index);
	    }

	    public List getPreferredFacilitySites()
	    {
	        return preferredFacilitySites;
	    }

	    public void setPreferredFacilitySite(int index, String preferredFacilitySite)
	    {
	        setElement(this.preferredFacilitySites, index, preferredFacilitySite);
	    }

	    public void setPreferredFacilitySites(List preferredFacilitySites)
	    {
	        this.preferredFacilitySites = preferredFacilitySites;
	    }

	    public String getPreferredFacilitySD(int index)
	    {
	        return (String)preferredFacilitySDs.get(index);
	    }

	    public List getPreferredFacilitySDs()
	    {
	        return preferredFacilitySDs;
	    }

	    public void setPreferredFacilitySD(int index, String preferredFacilitySD)
	    {
	        setElement(this.preferredFacilitySDs, index, preferredFacilitySD);
	    }

	    public void setPreferredFacilitySDs(List preferredFacilitySDs)
	    {
	        this.preferredFacilitySDs = preferredFacilitySDs;
	    }
	    
	    /**
	     * Adds a preferredFacility to the list of preferredFacility.
	     *
	     * @param pfId The preferredFacility Id
	     * @param site The station number of the preferred facility site
	     * @param source designation The source designation of the preferred facility
	     */
	    public void addPreferredFacility(String pfId, String site, String sourceDesignation)
	    {
	        this.preferredFacilityIds.add(pfId);
	        this.preferredFacilitySites.add(site);
	        this.preferredFacilitySDs.add(sourceDesignation);
	    }

	    /**
	     * Adds a new preferred facility to the form.
	     */
	    public void addNewPreferredFacility()
	    {
	        addPreferredFacility("", "", "");
	    }

	    public boolean isNoPreferredFacilityData()
	    {
	        if ((preferredFacilityIds == null) || (preferredFacilityIds.size() == 0))
	        {
	            return true;
	        }
	        else
	        {
	            return false;
	        }
	    }
	    

        public String getLanguage(int index)
        {
            return (String)languages.get(index);
        } 
        
        public List getLanguages() {
            return languages;
        }

        public void setLanguages(List languages) {
            this.languages = languages;
        }

        public String getLanguageEntryDate() {
            return languageEntryDate;
        }

        public void setLanguageEntryDate(String languageEntryDate) {
            this.languageEntryDate = languageEntryDate;
        }

        public String getPreferredLanguageCode() {
            return preferredLanguageCode;
        }

        public void setPreferredLanguageCode(String preferredLanguageCode) {
            this.preferredLanguageCode = preferredLanguageCode;
        }
        
        public boolean getDodEditableFlag() {
			return dodEditableFlag;
		}

		public void setDodEditableFlag(boolean dodEditableFlag) {
			this.dodEditableFlag = dodEditableFlag;
		}

        public boolean getShowAllDeathSourcesFlag() {
			return showAllDeathSourcesFlag;
		}

		public void setShowAllDeathSourcesFlag(boolean showAllFlag) {
			this.showAllDeathSourcesFlag = showAllFlag;
		}

		
       /*
		public String getDodVerificationIndicator() {
			return dodVerificationIndicator;
		}

		public void setDodVerificationIndicator(String dodVerificationIndicator) {
			this.dodVerificationIndicator = dodVerificationIndicator;
		}
        */
		public String getDeathNotificationSiteName() {
			return deathNotificationSiteName;
		}

		public void setDeathNotificationSiteName(String deathNotificationSiteName) {
			this.deathNotificationSiteName = deathNotificationSiteName;
		}

		public String getDeathNotificationSourceDesc() {
			return deathNotificationSourceDesc;
		}

		public void setDeathNotificationSourceDesc(String deathNotificationSourceDesc) {
			this.deathNotificationSourceDesc = deathNotificationSourceDesc;
		}


}
