/********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

// Java Classes
import java.util.List;
import java.util.ArrayList;

// Framework Classes
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;

/**
 * This is the form used in conjunction with the Demographics Overview page.
 *
 * @author Andrew Pach
 * @author Madhu Katikala
 * @version 3.0
 */
public class DemographicOverviewForm extends AbstractForm
{
    private static final long serialVersionUID = 8349234654043407545L;
    
    private String currentMailingAddress = null;
    private String residentialAddress = null;
    private String permanentAddress = null;
    private String confidentialAddress = null;
    private String temporaryAddress = null;
    
    private String phoneNumber = null;
    private String currentStatus = null;
    private String employmentStatus = null;
    private String preferredLanguage = null;
    private List siteInsuraceCarriers = null;
    private List hecInsuraceCarriers = null;
    private List associations = null;
    private String emergencyResponse = null;
    private String badAddressReasonPerm = null;
    private String badAddressReasonConf = null;
    private String badAddressReasonTemp = null;

    
    private String confStartDate = null;
    private String confEndDate = null;
    private String tempStartDate = null;
    private String tempEndDate = null;
 
    private String activeAddress = null;
    
    public String getActiveAddress() {
		return activeAddress;
	}

	public void setActiveAddress(String activeAddress) {
		this.activeAddress = activeAddress;
	}

	public String getConfStartDate() {
		return confStartDate;
	}

	public void setConfStartDate(String confStartDate) {
		this.confStartDate = confStartDate;
	}

	public String getConfEndDate() {
		return confEndDate;
	}

	public void setConfEndDate(String confEndDate) {
		this.confEndDate = confEndDate;
	}

	public String getTempStartDate() {
		return tempStartDate;
	}

	public void setTempStartDate(String tempStartDate) {
		this.tempStartDate = tempStartDate;
	}

	public String getTempEndDate() {
		return tempEndDate;
	}

	public void setTempEndDate(String tempEndDate) {
		this.tempEndDate = tempEndDate;
	}

	/**
     * Default constructor.
     */
    public DemographicOverviewForm()
    {
        super();
    }

    /* (non-Javadoc)
    * @see gov.va.med.fw.ui.struts.AbstractForm#createValueObject()
    */
    protected AbstractEntity createValueObject()
    {
        return null;
    }

    public String getCurrentMailingAddress()
    {
        return currentMailingAddress;
    }

    public String getCurrentStatus()
    {
        return currentStatus;
    }

    public String getPhoneNumber()
    {
        return phoneNumber;
    }

    public String getEmploymentStatus()
    {
        return employmentStatus;
    }

    public List getAssociations()
    {
        return associations;
    }

    public void setCurrentMailingAddress(String currentMailingAddress)
    {
        this.currentMailingAddress = currentMailingAddress;
    }

    public void setCurrentStatus(String currentStatus)
    {
        this.currentStatus = currentStatus;
    }

    public void setPhoneNumber(String phoneNumber)
    {
        this.phoneNumber = phoneNumber;
    }

    public void setEmploymentStatus(String employmentStatus)
    {
        this.employmentStatus = employmentStatus;
    }

    public void setAssociations(List associations)
    {
        this.associations = associations;
    }

    public boolean getAssociationsPresent()
    {
        return (this.associations != null) && (this.associations.size() > 0);
    }

    public boolean getSiteInsuranceCarriersPresent()
    {
        return (this.siteInsuraceCarriers != null) && (this.siteInsuraceCarriers.size() > 0);
    }

    public boolean getHecInsuranceCarriersPresent()
    {
        return (this.hecInsuraceCarriers != null) && (this.hecInsuraceCarriers.size() > 0);
    }

    public boolean getAnyInsuranceCarriersPresent()
    {
        return (getSiteInsuranceCarriersPresent() || getHecInsuranceCarriersPresent());
    }

    /**
     * @return Returns the emergencyResponse.
     */
    public String getEmergencyResponse()
    {
        return emergencyResponse;
    }

    /**
     * @param emergencyResponse The emergencyResponse to set.
     */
    public void setEmergencyResponse(String emergencyResponse)
    {
        this.emergencyResponse = emergencyResponse;
    }

    public String getBadAddressReasonPerm()
    {
        return badAddressReasonPerm;
    }

    public void setBadAddressReasonPerm(String badAddressReason)
    {
        this.badAddressReasonPerm = badAddressReason;
    }

    public String getBadAddressReasonConf() {
		return badAddressReasonConf;
	}

	public void setBadAddressReasonConf(String badAddressReasonConf) {
		this.badAddressReasonConf = badAddressReasonConf;
	}

	public String getBadAddressReasonTemp() {
		return badAddressReasonTemp;
	}

	public void setBadAddressReasonTemp(String badAddressReasonTemp) {
		this.badAddressReasonTemp = badAddressReasonTemp;
	}

	public List getSiteInsuraceCarriers()
    {
        if (siteInsuraceCarriers == null)
        {
            siteInsuraceCarriers = new ArrayList();
        }
        return siteInsuraceCarriers;
    }

    public void setSiteInsuraceCarriers(List siteInsuraceCarriers)
    {
        this.siteInsuraceCarriers = siteInsuraceCarriers;
    }

    public List getHecInsuraceCarriers()
    {
        if (hecInsuraceCarriers == null)
        {
            hecInsuraceCarriers = new ArrayList();
        }
        return hecInsuraceCarriers;
    }

    public void setHecInsuraceCarriers(List hecInsuraceCarriers)
    {
        this.hecInsuraceCarriers = hecInsuraceCarriers;
    }

    public void addSiteInsurance(InsurancePolicy insurance)
    {
        if (this.siteInsuraceCarriers == null)
        {
            this.siteInsuraceCarriers = new ArrayList();
        }
        this.siteInsuraceCarriers.add(insurance);
    }

    public void addHecInsurance(InsurancePolicy insurance)
    {
        if (this.hecInsuraceCarriers == null)
        {
            this.hecInsuraceCarriers = new ArrayList();
        }
        this.hecInsuraceCarriers.add(insurance);
    }
    
    public String getPreferredLanguage() {
        return preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

	public String getResidentialAddress() {
		return residentialAddress;
	}

	public void setResidentialAddress(String residentialAddress) {
		this.residentialAddress = residentialAddress;
	}

	public String getPermanentAddress() {
		return permanentAddress;
	}

	public void setPermanentAddress(String permanentAddress) {
		this.permanentAddress = permanentAddress;
	}

	public String getConfidentialAddress() {
		return confidentialAddress;
	}

	public void setConfidentialAddress(String confidentialAddress) {
		this.confidentialAddress = confidentialAddress;
	}

	public String getTemporaryAddress() {
		return temporaryAddress;
	}

	public void setTemporaryAddress(String temporaryAddress) {
		this.temporaryAddress = temporaryAddress;
	}
    
    
}
