/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

// Java Classes
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.service.ServiceConfigurationException;

// ESR Classes
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.util.SessionManager;

/**
 * This struts action is used to support the demographics overview page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DemographicOverviewAction extends PersonAbstractAction
{
    // Struts forwards
    public static final String FORWARD_DEMOGRAPHIC_OVERVIEW = "demographicOverview";
    public static final String FORWARD_DEMOGRAPHIC_ADDRESS_OVERVIEW = "demographicAddressOverview";
    
    /**
     * Default constructor.
     */
    public DemographicOverviewAction()
    {
        super();
    }

    /**
     * Displays the Demographics Overview page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Convert all the addresses data to the form
    	DemographicOverviewForm overviewForm =  getOverviewForm(form);
    	boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        overviewForm.setAddAPerson(isAddAPerson);
    	conversionService.convert(getSelectedPerson(request), overviewForm );
       // conversionService.convert(getSelectedPerson(request), getOverviewForm(form));
    	
    	String actionType = request.getParameter("actionType");
    	
        return "ADDRESS".equalsIgnoreCase(actionType)? mapping.findForward(FORWARD_DEMOGRAPHIC_ADDRESS_OVERVIEW) : mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW);
    }

    /**
     * Checks to ensure the passed in ActionForm is not null and of the correct type.
     *
     * @param form The struts form to check
     *
     * @return The passed in form type-casted to a DemographicOverviewForm
     * @throws gov.va.med.fw.service.ServiceConfigurationException if the form is null or of an incorrect type.
     */
    protected DemographicOverviewForm getOverviewForm(ActionForm form) throws ServiceConfigurationException
    {
        DemographicOverviewForm overviewForm =
            (form instanceof DemographicOverviewForm) ? (DemographicOverviewForm)form : null;
        if (overviewForm == null)
        {
            throw new ServiceConfigurationException("DemographicOverviewForm not properly configured.");
        }
        return overviewForm;
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.display", "display");
        map.put("text.subMenu.overview", "display");
        return map;
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
        Validate.notNull(conversionService, "required DemographicOverviewConversionService is null");
    }
}