// Package 
package gov.va.med.esr.ui.demographic.action;

// Java Classes
// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.util.StringUtils;

import java.util.Calendar;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

// Library Classes
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
// Framework Classes

/**
 * This is the form used in conjunction with the Demographics Identity Traits page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DemographicIdentityTraitsForm extends AddressForm
{
    private static final long serialVersionUID = 5305813411097040117L;

    public static final String FIELD_DOB = "dateOfBirth";
    public static final String FIELD_MotherMaidenName = "mothersMaidenName";
    public static final String FIELD_PlaceOfBirthState = "placeOfBirthState";
    public static final String FIELD_PlaceOfBirthCity = "placeOfBirthCity";
    public static final String ERROR_BEFORE_1870 = "errors.invalidDOB";
    public static final String LABEL_DOB = "label.personal.dateOfBirth";
    public static final String ERROR_FUTURE = "errors.future";

    private String prefix = null;
    private String firstName = null;
    private String middleName = null;
    private String lastName = null;
    private String suffix = null;
    private String ssn = null;
    private String pseudoSsnReason = null;
    private String otherSSN = null;
    private String ssnSourceOfChange = null;
    private String ssaVerificationStatus = null;
    private String ssaVerificationDate = null;
    private String ssaMessage = null;
    private String gender = null;
    private String dateOfBirth = null;
    private String vpidValue = null;
    private String birthCity = null;
    private String birthState = null;
    private String multipleBirth = null;
    private String mothersMaidenName = null;
    private String ethnicity = null;
    private String[] raceSelections = {};

    private boolean disabledMultipleBirthIndicator = true;
    private boolean disableSelfIdentifiedGenderIdentity = true;
    private SelfIdentifiedGenderIdentity selfIdentifiedGenderIdentity = null;
  
    public boolean isDisabledMultipleBirthIndicator() {
		return disabledMultipleBirthIndicator;
	}

	public void setDisabledMultipleBirthIndicator(
			boolean disabledMultipleBirthIndicator) {
		this.disabledMultipleBirthIndicator = disabledMultipleBirthIndicator;
	}

	/**
     * Default constructor.
     */
    public DemographicIdentityTraitsForm()
    {
        super();
    }

    public String getOtherSSN()
    {
        return otherSSN;
    }

    public String getPseudoSsnReason()
    {
        return pseudoSsnReason;
    }

    public String getSsaMessage()
    {
        return ssaMessage;
    }

    public String getSsaVerificationDate()
    {
        return ssaVerificationDate;
    }

    public String getSsaVerificationStatus()
    {
        return ssaVerificationStatus;
    }

    public String getSsn()
    {
        return ssn;
    }

    public String getSsnSourceOfChange()
    {
        return ssnSourceOfChange;
    }

    public void setOtherSSN(String otherSSN)
    {
        this.otherSSN = otherSSN;
    }

    public void setPseudoSsnReason(String pseudoSsnReason)
    {
        this.pseudoSsnReason = pseudoSsnReason;
    }

    public void setSsaMessage(String ssaMessage)
    {
        this.ssaMessage = ssaMessage;
    }

    public void setSsaVerificationDate(String ssaVerificationDate)
    {
        this.ssaVerificationDate = ssaVerificationDate;
    }

    public void setSsaVerificationStatus(String ssaVerificationStatus)
    {
        this.ssaVerificationStatus = ssaVerificationStatus;
    }

    public void setSsn(String ssn)
    {
        this.ssn = ssn;
    }

    public void setSsnSourceOfChange(String ssnSourceOfChange)
    {
        this.ssnSourceOfChange = ssnSourceOfChange;
    }

    public String getPrefix()
    {
        return prefix;
    }

    public void setPrefix(String prefix)
    {
        this.prefix = prefix;
    }

    public String getFirstName()
    {
        return firstName;
    }

    public void setFirstName(String firstName)
    {
        this.firstName = firstName;
    }

    public String getMiddleName()
    {
        return middleName;
    }

    public void setMiddleName(String middleName)
    {
        this.middleName = middleName;
    }

    public String getLastName()
    {
        return lastName;
    }

    public void setLastName(String lastName)
    {
        this.lastName = lastName;
    }

    public String getSuffix()
    {
        return suffix;
    }

    public void setSuffix(String suffix)
    {
        this.suffix = suffix;
    }

    public String getGender()
    {
        return gender;
    }

    public void setGender(String gender)
    {
        this.gender = gender;
    }

    public String getDateOfBirth()
    {
        return dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth)
    {
        this.dateOfBirth = dateOfBirth;
    }

    public String getVpidValue()
    {
        return vpidValue;
    }

    public void setVpidValue(String vpidValue)
    {
        this.vpidValue = vpidValue;
    }

    public String getBirthCity() {
        return birthCity;
    }

    public void setBirthCity(String birthCity) {
        this.birthCity = birthCity;
    }

    public String getBirthState() {
        return birthState;
    }

    public void setBirthState(String birthState) {
        this.birthState = birthState;
    }

    public String getEthnicity() {
        return ethnicity;
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    public String getMothersMaidenName() {
        return mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public String getMultipleBirth() {
        return multipleBirth;
    }

    public void setMultipleBirth(String multipleBirth) {
        this.multipleBirth = multipleBirth;
    }

	public String[] getRaceSelections() {
		return raceSelections;
	}

	public void setRaceSelections(String[] raceSelections) {
		this.raceSelections = raceSelections;
	}

	
    public SelfIdentifiedGenderIdentity getSelfIdentifiedGenderIdentity() {
        return selfIdentifiedGenderIdentity;
    }

    public void setSelfIdentifiedGenderIdentity(SelfIdentifiedGenderIdentity selfIdentifiedGenderIdentity) {
        this.selfIdentifiedGenderIdentity = selfIdentifiedGenderIdentity;
    }

    public boolean isDisableSelfIdentifiedGenderIdentity() {
        return disableSelfIdentifiedGenderIdentity;
    }

    public void setDisableSelfIdentifiedGenderIdentity(
            boolean disableSelfIdentifiedGenderIdentity) {
        this.disableSelfIdentifiedGenderIdentity = disableSelfIdentifiedGenderIdentity;
    }

    /**
     * Custom validations for Date of birth
     */
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request)
    {
        ActionErrors messages = super.validate(mapping, request);

        // If any declarative messages were produced, display them first.
        if ((messages != null) && (!messages.isEmpty()))
        {
            return messages;
        }

        if (messages == null)
        {
            messages = new ActionErrors();
        }

        //CCR9737: DOB of 12/31/1870 is not accepted.
        //SUC418.28 [3064] Date of Birth
        //Date of Birth is required; it must be a date that is on or after 12/31/1870.
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Calendar.YEAR, 1870);
        calendar.set(Calendar.MONTH, 11);
        calendar.set(Calendar.DAY_OF_MONTH, 31);
        Date minDate = calendar.getTime();

        ImpreciseDate dob = DateUtils.getImpreciseDate(getDateOfBirth());
        
        boolean dobCheckFlag = false;
        if (dob != null)
        {
        	if (ImpreciseDateUtils.getDateWithDefault(dob).before(minDate))
            {
                // Date should on and after 12/31/1870
                messages.add(FIELD_DOB, new ActionMessage(ERROR_BEFORE_1870));
                dobCheckFlag = true;
            }

            if (new Date().before(ImpreciseDateUtils.getDateWithDefault(dob)))
            {
                messages.add(FIELD_DOB, new ActionMessage(ERROR_FUTURE, "Date of Birth"));
                dobCheckFlag = true;
            }
        }
      //  if (dobCheckFlag)
      //  	return messages;
        
        if ( this.isAddAPerson()){
        	if (StringUtils.containsNumbers(this.getMothersMaidenName())){
		 		messages.add("FIELD_MotherMaidenName", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Mother's Maiden Name can not contain numbers."));
		 	}
        	if ((this.getBirthState()) == null || (this.getBirthState()).length()==0){
		 		messages.add("FIELD_PlaceOfBirthState", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Place of Birth State is required."));
		 	}
        	if ((this.getBirthCity()) == null || (this.getBirthCity()).length()==0){
		 		messages.add("FIELD_PlaceOfBirthCity", new ActionMessage(MessageKeys.ERRORS_DETAIL,"Place of Birth City is required."));
		 	}
        }
        return messages;
    }    
    
}
