/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.conversion;

// Java Classes
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.HBPDefinitionService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.UserAdminService;
import gov.va.med.esr.service.VHICCardInfoService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.esr.common.ui.conversion.CommonConversionServiceImpl;

/**
 * A UI specific implementation of the conversion service.
 *
 * @author Andrew Pach
 * @version 1.0
 */
public class UIConversionServiceImpl extends CommonConversionServiceImpl implements UIConversionService
{

    private LookupCacheService lookupCacheService;
    private PersonHelperService personHelperService;
    private UserAdminService	userAdminService;
    private HandBookService handBookService;
    private VHICCardInfoService vhicCardInfoService;
    private HBPDefinitionService hbpDefinitionService;
    private DemographicService demographicService;
   	
	/**
     * Default constructor.
     */
    public UIConversionServiceImpl()
    {
    }

    public LookupCacheService getLookupCacheService()
    {
        return lookupCacheService;
    }

    public void setLookupCacheService(LookupCacheService lookupCacheService)
    {
        this.lookupCacheService = lookupCacheService;
    }
    
	public PersonHelperService getPersonHelperService() 
	{
		return personHelperService;
	}
	
	public void setPersonHelperService(PersonHelperService personHelperService) 
	{
		this.personHelperService = personHelperService;
	}
	
    public Lookup getLookup(Class clazz,String code)
    throws ConversionServiceException {
        Lookup lookup = null;
        try {
            if(StringUtils.isNotEmpty(code)) {
                lookup = getLookupCacheService().getByCodeFromCache(clazz,code);
            }
        } catch(Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Error while getting lookup object for ");
            buffer.append(" type = " + clazz.getName());
            buffer.append(" code = " + code);
            throw new ConversionServiceException(buffer.toString(),ex);
        }
        return lookup;
    }
    
    public Boolean getBoolean(String flag) {
        if(StringUtils.isEmpty(flag) || StringUtils.equals(flag,ND)) return null;
        return (StringUtils.equals(flag,Y)) ? Boolean.TRUE : Boolean.FALSE;
    }
    
    public Boolean getBooleanIndicatorCode(String flag) {
        if(StringUtils.isEmpty(flag) || StringUtils.equals(flag,Indicator.UNKNOWN.getCode())) return null;
        return (StringUtils.equals(flag,Indicator.YES.getCode())) ? Boolean.TRUE : Boolean.FALSE;
    }
    
    public String getYesNoNoData(Indicator indicator) {
        if(indicator == null || StringUtils.equals(indicator.getCode(),Indicator.UNKNOWN.getCode())) return ND;
        return (StringUtils.equals(indicator.getCode(),Indicator.YES.getCode())) ? Y : N;
    }
    
    public Indicator getIndicatorFromYesNoNoData(String flag) throws ConversionServiceException {
        String indFlag = null;
        if(StringUtils.isEmpty(flag) || StringUtils.equals(flag,ND)) {
            indFlag = Indicator.UNKNOWN.getCode();
        } else {
            indFlag = (StringUtils.equals(flag,Y)) ? Indicator.YES.getCode() : Indicator.NO.getCode();
        }
        return StringUtils.isNotEmpty(indFlag) ? (Indicator)getLookup(Indicator.class,indFlag) : null;
    }
    
    public String getIndicatorCode(Boolean flag) {
        if(flag == null) {
            return Indicator.UNKNOWN.getCode();
        } else {
            return (flag.equals(Boolean.TRUE)) ? Indicator.YES.getCode() : Indicator.NO.getCode();
        }
    }
    
 
    public void afterPropertiesSet() throws Exception 
	{
        super.afterPropertiesSet();
        
        if( getPersonHelperService() == null) {
        	throw new ServiceConfigurationException( "Missing required PersonHelperService");
        }
    }   
    
    protected UserPrincipal getLoggedInUser() {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        return (securityContext != null) ? securityContext.getUserPrincipal() : null;
    }

	public UserAdminService getUserAdminService() {
		return userAdminService;
	}

	public void setUserAdminService(UserAdminService userAdminService) {
		this.userAdminService = userAdminService;
	}

	public HandBookService getHandBookService() {
		return handBookService;
	}

	public void setHandBookService(HandBookService handBookService) {
		this.handBookService = handBookService;
	}
	
	 public VHICCardInfoService getVhicCardInfoService() {
	        return vhicCardInfoService;
	    }

	public void setVhicCardInfoService(VHICCardInfoService vhicCardInfoService) {
	        this.vhicCardInfoService = vhicCardInfoService;
	    }

    public HBPDefinitionService getHbpDefinitionService() {
            return hbpDefinitionService;
        }

    public void setHbpDefinitionService(HBPDefinitionService hbpDefinitionService) {
            this.hbpDefinitionService = hbpDefinitionService;
        }
    
    public DemographicService getDemographicService() {
		return demographicService;
	}

	public void setDemographicService(DemographicService demographicService) {
		this.demographicService = demographicService;
	}
 }