/*********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import java.math.BigDecimal;

// Library Classes
import org.apache.struts.action.ActionForm;

// Framework Classes
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.ui.valuelist.SelectableSearchValueListAdapter;
import gov.va.med.fw.util.StringUtils;

// ESR Classes
import gov.va.med.esr.common.model.comms.CommsLogSearchQueryInfo;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.ui.common.util.DateUtils;


/**
 * This value list adapter provides an extension to the default SearchValueListAdapter by
 * implementing a custom populateFormAttributes implementation.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailSearchValueListAdapter extends SelectableSearchValueListAdapter
{
    private static final long serialVersionUID = 8342303395122801154L;
    
    private LookupService lookupService = null;

    /**
     * Performs a custom form to searchQueryInfo conversion to handle lookup data. It is assumed
     * that a valid state and form code exists on the passed in form.
     *
     * @param form The form that contains search parameters
     * @param searchQueryInfo The search query info object to populate with the search parameters.
     *
     * @throws ValueListException if there are any problems copying properties.
     */
    protected void populateFormAttributes(ActionForm form, SearchQueryInfo searchQueryInfo)
        throws ValueListException
    {
        // Typecase the parameters
        UndeliverableMailSearchForm searchForm = (UndeliverableMailSearchForm)form;
        CommsLogSearchQueryInfo commsQueryInfo = (CommsLogSearchQueryInfo)searchQueryInfo;

        // Convert the standard parameters
        commsQueryInfo.setSSN(SSN.formatSSN(searchForm.getSSN()));
        commsQueryInfo.setBarcode(searchForm.getBarcode());
        commsQueryInfo.setGivenName(searchForm.getGivenName());
        commsQueryInfo.setMiddleName(searchForm.getMiddleName());
        commsQueryInfo.setFamilyName(searchForm.getFamilyName());
        commsQueryInfo.setCaseNumber(StringUtils.isEmpty(searchForm.getCaseNumber()) ? null : new BigDecimal(searchForm.getCaseNumber()));
        commsQueryInfo.setDateMailed(DateUtils.getDate(searchForm.getDateMailed()));
        commsQueryInfo.setAddressLine1(searchForm.getAddressLine1());
        commsQueryInfo.setAddressLine2(searchForm.getAddressLine2());
        commsQueryInfo.setAddressLine3(searchForm.getAddressLine3());
        commsQueryInfo.setCity(searchForm.getCity());
        commsQueryInfo.setCounty(searchForm.getCounty());
        commsQueryInfo.setZipCode(searchForm.getZipCode());
        commsQueryInfo.setZipPlus4(searchForm.getZipPlus4());
        commsQueryInfo.setCountry(searchForm.getCountry());
        commsQueryInfo.setProvince(searchForm.getProvince());
        commsQueryInfo.setPostalCode(searchForm.getPostalCode());

        
        try {
            // Convert the state
            if(StringUtils.isNotEmpty(searchForm.getState())) {
                // Find the State based on the state code and set it on the query info
                commsQueryInfo.setState(lookupService.getStateByCode(searchForm.getState()));
            }
            
            // Convert the Form Number
            if(StringUtils.isNotEmpty(searchForm.getFormNumber())) {
                // Find the CommsForm based on the form code and set it on the query info
                commsQueryInfo.setFormNumber(lookupService.getComLetterTemplateTypeByCode(searchForm.getFormNumber()));
            }
        }
        catch (Exception ex)
        {
            throw new ValueListException(
                "Error converting UndeliverableMailSearchForm data to CommsLogSearchQueryInfo " +
                    "data.  " + ex.getMessage(), ex);
        }
    }

    public LookupService getLookupService()
    {
        return lookupService;
    }

    public void setLookupService(LookupService lookupService)
    {
        this.lookupService = lookupService;
    }
}