/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import net.mlw.vlh.ValueList;

// Framework Classes
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.SelectableResult;

// ESR Classes
import gov.va.med.esr.common.model.comms.UndeliverableMailInfo;

/**
 * This struts action is used to support the Undeliverable Mail Search Results page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailSearchResultsAction extends UndeliverableMailAction
{
    /**
     * Default constructor.
     */
    public UndeliverableMailSearchResultsAction()
    {
        super();
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Return to the results display
        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Cancels this page and returns to the search page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward cancel(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Return to the results display
        return mapping.findForward(FORWARD_RETURN_TO_PREV_SCREEN);
    }

    /**
     * Updates the status of the selected entries as "returned from post office".
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward update(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Ensure some results were previously returned.  This will protect against the user hitting
        // the back button after processing undeliverable mail on the search results page previously.
        if (!ValueListActionUtils.isCachedResults(request.getSession(), UNDELIVERABLE_MAIL_SEARCH_TABLE_ID))
        {
            // Add a message to be displayed to the user
            setMessageInSession(request.getSession(), SEARCH_RESULTS_NO_LONGER_VALID_MESSAGE_KEY, true);

            // The user didn't select any results so display an error message
            return mapping.findForward(FORWARD_RETURN_TO_PREV_SCREEN_ERROR);
        }

        // Get the value list information
        ValueList valueList = ValueListActionUtils.getSelectableResultValuleList(form,
            request, UNDELIVERABLE_MAIL_SEARCH_TABLE_ID, UNDELIVERABLE_MAIL_SEARCH_ADAPTER, null);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils
            .setValueList(request, valueList, UNDELIVERABLE_MAIL_VALUELIST_REQUEST_KEY);

        //Get selectedResults from Session instead of from ValueList, which is a SubList
        List selectedResults = ValueListActionUtils.getSelectableResultsFromSession(
        			request, UNDELIVERABLE_MAIL_SEARCH_TABLE_ID, new Boolean(true));

        // Check if the user selected any items
        if ((selectedResults == null) || (selectedResults.size() == 0))
        {
            // Add a message to be displayed to the user
            setMessageInSession(request.getSession(), NO_RESULTS_MESSAGE_KEY, true);

            // The user didn't select any results so display an error message
            return mapping.findForward(FORWARD_RETURN_TO_PREV_SCREEN_ERROR);
        }

        // Create a list of CommsLogEntry objects for the processUndeliverableMail method.
        ArrayList commsLogEntryList = new ArrayList();
        for (Iterator iterator = selectedResults.iterator(); iterator.hasNext();)
        {
            SelectableResult selectableResult = (SelectableResult)iterator.next();
            UndeliverableMailInfo undeliverableMailInfo =
                (UndeliverableMailInfo)selectableResult.getResult();
            commsLogEntryList.add(undeliverableMailInfo.getCommsLogEntry());
        }

        // Process the selected entries
        getCommsLogService().processUndeliverableMail(commsLogEntryList);

        // Return to the results display
        return mapping.findForward(FORWARD_RETURN_TO_PREV_SCREEN_SUCCESSFUL_UPDATE);
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.display", "display");
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        return map;
    }
}