/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

// Library Classes
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.ui.struts.AbstractForm;

// ESR Classes


/**
 * This is the form used in conjunction with the Undeliverable Mail pages.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailForm extends AbstractForm
{
    private static final long serialVersionUID = 1711650251696253431L;
    private List barcode;
    private List returned;

    /**
     * Default constructor.
     */
    public UndeliverableMailForm()
    {
        super();
        initialize();
    }

    /**
     * Resets all the form data to null.
     */
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }

    /**
     * Initializes the data on this form.
     */
    protected void initialize()
    {
        barcode = new ArrayList();
        returned = new ArrayList();
    }

    /**
     * Adds an undeliverable piece of mail to the list.
     *
     * @param barcode The barcode Id
     * @param returned The returned by Post Office indicator.
     */
    public void addUndeliverableMail(String barcode, String returned)
    {
        this.barcode.add(barcode);
        this.returned.add(returned);
    }

    public int getUndeliverableMailSize()
    {
        return barcode.size();
    }

    public String getBarcode(int index)
    {
        return (String)barcode.get(index);
    }

    public List getBarcodeList()
    {
        return barcode;
    }

    public void setBarcode(int index, String barcode)
    {
        setElement(this.barcode, index, barcode);
    }

    public void setBarcodeList(List barcode)
    {
        this.barcode = barcode;
    }

    public String getReturned(int index)
    {
        return (String)returned.get(index);
    }

    public List getReturnedList()
    {
        return returned;
    }

    public void setReturned(int index, String returned)
    {
        setElement(this.returned, index, returned);
    }

    public void setReturnedList(List returned)
    {
        this.returned = returned;
    }
}
