/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Libraries Classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// Framework Classes

// ESR Classes

/**
 * This struts action is used to edit the permanent address when the user came from the
 * Undeliverable Mail search flow.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailEditPermAddressFromSearchAction
    extends UndeliverableMailEditPermAddressAction
{
    /**
     * Default constructor.
     */
    public UndeliverableMailEditPermAddressFromSearchAction()
    {
        super();
    }

    /**
     * Updates the permanent address.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward update(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Perform the standard update
        ActionForward forward = super.update(mapping, form, request, response);

        // Add a success message to be displayed to the user
        setMessageInSession(request.getSession(), SUCCESSFUL_PERM_ADDRESS_UPDATE_MESSAGE_KEY, false);

        // Return to the previous screen
        return forward;
    }

    /**
     * Handle an entity not changed exception.
     *
     * @param mapping the ActionMapping
     * @param form the ActionForm
     * @param request The request
     * @param response The response
     *
     * @throws Exception If any problems are encountered.
     */
    protected ActionForward handleEntityNotChangedException(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get the olerror page
        ActionForward forward = mapping.findForward(FWD_NO_DATA_CHANGED);

        // Get the input page if the oleror page is not specified
        if (forward == null)
        {
            forward = mapping.getInputForward();
        }

        // Add a success message to be displayed to the user
        setMessageInSession(request.getSession(), MESSAGE_DATA_NOT_CHANGED_KEY, false);

        return forward;
    }
}