/********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import javax.servlet.http.HttpServletRequest;

// Library Classes
import org.apache.struts.action.ActionMapping;

// Framework Classes

// ESR Classes
import gov.va.med.esr.ui.common.action.AddressForm;

/**
 * This is the form used in conjunction with the Undeliverable Mail Edit Permanent Address page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailEditPermAddressForm extends AddressForm
{
    private static final long serialVersionUID = -7552009383899232806L;
    
    private String selectedPersonId = null;

    /**
     * Default constructor.
     */
    public UndeliverableMailEditPermAddressForm()
    {
        super();
        initialize();
    }

    /**
     * Resets all the form data to null.
     */
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }

    /**
     * Initializes the data on this form.
     */
    protected void initialize()
    {
        super.initialize();
        selectedPersonId = null;
    }

    public String getSelectedPersonId()
    {
        return selectedPersonId;
    }

    public void setSelectedPersonId(String selectedPersonId)
    {
        this.selectedPersonId = selectedPersonId;
    }
}
