// Package 
package gov.va.med.esr.ui.comms.action;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;

// ESR Classes
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.party.Address;

/**
 * The conversion service for the undeliverable mail edit permanent address screens.
 *
 * @author Andrew Pach
 * @version 1.0
 */
public class UndeliverableMailEditPermAddressConversionService extends AddressConversionService
{
    /**
     * Default constructor.
     */
    public UndeliverableMailEditPermAddressConversionService()
    {
        super();
    }

    /**
     * Converts between a Person object that contains the addresses information and the DemographicAddressesForm.
     *
     * @param source the source object
     * @param target the target object
     *
     * @throws gov.va.med.fw.conversion.ConversionServiceException if any errors were encountered during the
     * conversion.
     */
    protected void convertBean(Object source, Object target) throws ConversionServiceException
    {
        Person person = null;
        UndeliverableMailEditPermAddressForm form = null;

        if (source instanceof Person)
        {
            person = (Person)source;
            if (target instanceof UndeliverableMailEditPermAddressForm)
            {
                form = (UndeliverableMailEditPermAddressForm)target;
            }
            else
            {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() +
                    " and must be of type UndeliverableMailEditPermAddressForm.");
            }

            // Convert from the Person to the form
            convertPersonToForm(person, form);
        }
        else
        {
            if (source instanceof UndeliverableMailEditPermAddressForm)
            {
                form = (UndeliverableMailEditPermAddressForm)source;
                if (target instanceof Person)
                {
                    person = (Person)target;
                }
                else
                {
                    throw new ConversionServiceException("Target object is of type " + target.getClass().getName() +
                        " and must be of type Person.");
                }

                // Convert from the Form to Person
                convertFormToPerson(form, person);
            }
            else
            {
                throw new ConversionServiceException("Source object is of type " + target.getClass().getName() +
                    " and must be of type Person or UndeliverableMailEditPermAddressForm.");
            }
        }
    }

    /**
     * Converts the addresses data from the Person object to the form.
     *
     * @param person The person
     * @param form The form
     *
     * @throws gov.va.med.fw.conversion.ConversionServiceException If there were any problems converting the person to the form.
     */
    protected void convertPersonToForm(Person person, UndeliverableMailEditPermAddressForm form) throws ConversionServiceException
    {
        try
        {
            // Get the permanent address
            Address permAddress = person.getPermanentAddress();

            // Convert the standard address fields (will set only the country if null)
            convertAddressToForm(permAddress, form);

            // Update country to United States if a country isn't set currently.
            if (StringUtils.isBlank(form.getCountry()))
            {
                form.setCountry(Country.CODE_USA.getName());
            }
        }
        catch (Exception ex)
        {
            throw new ConversionServiceException("Unable to convert Person to DemographicAddressesForm.", ex);
        }
    }

    /**
     * Converts the form data to the Person object.
     *
     * @param form The form
     * @param person The person
     *
     * @throws gov.va.med.fw.conversion.ConversionServiceException If there were any problems converting the form to the person.
     */
    protected void convertFormToPerson(UndeliverableMailEditPermAddressForm form, Person person) throws ConversionServiceException
    {
        LookupCacheService lookupCacheService = getLookupCacheService();

        try
        {
            // Add/Update the permanent address
            Address permAddress = person.getPermanentAddress();
            if (permAddress == null)
            {
                permAddress = new Address();
                permAddress.setType((AddressType)lookupCacheService.getByCodeFromCache(AddressType.class,
                    AddressType.CODE_PERMANENT_ADDRESS.getName()));
                person.addAddress(permAddress);
            }

            // Convert the standard address fields
            convertFormToAddress(form, permAddress);
        }
        catch (Exception ex)
        {
            throw new ConversionServiceException("Unable to convert DemographicAddressesForm to Person.", ex);
        }
    }
}
