/********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

// Library Classes
import org.apache.struts.action.ActionMapping;

// Framework Classes
import gov.va.med.fw.ui.struts.AbstractForm;

// ESR Classes


/**
 * This is the form used in conjunction with the Undeliverable Mail Barcode Scanning page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailBarcodeScanningForm extends AbstractForm
{
    private static final long serialVersionUID = -3458834926465242595L;
    
    private String barcode;
    private List selected;

    /**
     * Default constructor.
     */
    public UndeliverableMailBarcodeScanningForm()
    {
        super();
        initialize();
    }

    /**
     * Resets all the form data to null.
     */
    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }

    /**
     * Initializes the data on this form.
     */
    protected void initialize()
    {
        barcode = null;
        selected = new ArrayList();
    }

    public String getBarcode()
    {
        return barcode;
    }

    public void setBarcode(String barcode)
    {
        this.barcode = barcode;
    }

    public int getSelectedSize()
    {
        return selected.size();
    }

    public List getSelected()
    {
        return selected;
    }

    public void setSelected(Object selected)
    {
        if (selected instanceof List)
        {
            this.selected = (List)selected;
        }
        else
        {
            ArrayList selectedList = new ArrayList();
            selectedList.add(selected);
            this.selected = selectedList;
        }
    }
}
