/********************************************************************
 * Copyright  2005-2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java Classes
import javax.servlet.http.HttpSession;

// Libraries Classes
import org.apache.struts.action.ActionForm;

// Framework Classes
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.StringUtils;

// ESR Classes
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.common.model.lookup.Country;

/**
 * This is a struts action base class used for Handle Undeliverable Mail pages.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class UndeliverableMailAction extends AddressValidationAction
{
    // Struts forwards
    public static final String FORWARD_DISPLAY = "display";
    public static final String FORWARD_DISPLAY_SEARCH_RESULTS =
        "displayUndeliverableMailSearchResults";
    public static final String FORWARD_RETURN_TO_PREV_SCREEN = "returnToPrevScreen";
    public static final String FORWARD_RETURN_TO_PREV_SCREEN_SUCCESSFUL_UPDATE =
        "returnToPrevScreenSuccessfulUpdate";
    public static final String FORWARD_RETURN_TO_PREV_SCREEN_ERROR = "returnToPrevScreenError";

    // ValueList Constants
    public static final String UNDELIVERABLE_MAIL_SEARCH_TABLE_ID =
        "undeliverableMailSearchTableId";
    public static final String UNDELIVERABLE_MAIL_SEARCH_ADAPTER = "undeliverableMailSearchAdapter";
    public static final String UNDELIVERABLE_MAIL_VALUELIST_REQUEST_KEY = "vlhlist";

    // Session and Message Keys
    private static final String ERROR_MESSAGE_SESSION_KEY =
        "undeliverableMailErrorMessageSessionKey";
    private static final String INFO_MESSAGE_SESSION_KEY = "undeliverableMailInfoMessageSessionKey";
    public static final String NO_RESULTS_MESSAGE_KEY = "message.comms.noResultsSelected";
    public static final String SEARCH_RESULTS_NO_LONGER_VALID_MESSAGE_KEY = "message.comms.searchResultsNoLongerValid";
    public static final String BARCODE_REQUIRED = "message.comms.barcodeRequired";
    public static final String BARCODE_NOT_FOUND = "message.comms.barcodeNotFound";
    public static final String DUPLICATE_BARCODE = "message.comms.duplicateBarcode";
    public static final String SUCCESSFUL_PERM_ADDRESS_UPDATE_MESSAGE_KEY =
        "message.comms.successfulPermAddressUpdate";
    public static final String MESSAGE_DATA_NOT_CHANGED_KEY = "message.dataNotChanged";
    public static final String SUCCESSFUL_STATUS_UPDATE = "message.comms.successfulStatusUpdate";


    /**
     * Default constructor.
     */
    public UndeliverableMailAction()
    {
        super();
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
    }

    /**
     * A person isn't required to be selected for these Actions.  This method is required since
     * we're extending AddressValidationAction which extends PersonAbstractAction which requires a
     * person by default.
     *
     * @return false.
     */
    protected boolean requiresSelectedPerson()
    {
        return false;
    }

    /**
     * Sets an error message bundle key to display an error message to the user.
     *
     * @param session The HttpSession
     * @param messageBundleKey The resource bundle key for the message to be displayed.
     * @param errorMessage If true, an error message will be produced.  Otherwise, an information
     * message will be displayed.
     */
    protected void setMessageInSession(HttpSession session, String messageBundleKey,
        boolean errorMessage)
    {
        session.setAttribute(errorMessage ? ERROR_MESSAGE_SESSION_KEY : INFO_MESSAGE_SESSION_KEY,
            messageBundleKey);
    }

    /**
     * Gets the error message bundle key for displaying an error message to the user.
     *
     * @param session The HttpSession
     * @param errorMessage If true, the error message will be returned.  Otherwise, the
     * informational message will be returned.
     *
     * @return The resource bundle key for the message to be displayed.
     */
    protected String getMessageFromSession(HttpSession session, boolean errorMessage)
    {
        return (String)session
            .getAttribute(errorMessage ? ERROR_MESSAGE_SESSION_KEY : INFO_MESSAGE_SESSION_KEY);
    }

    /**
     * Checks to ensure the passed in ActionForm is not null and of the correct type -
     * UndeliverableMailBarcodeScanningForm.
     *
     * @param form The struts form to check
     *
     * @return The passed in form type-casted to our screen specific form
     * @throws gov.va.med.fw.service.ServiceConfigurationException if the form is null or of an
     * incorrect type.
     */
    protected UndeliverableMailBarcodeScanningForm getUndeliverableMailBarcodeScanningForm(
        ActionForm form)
        throws ServiceConfigurationException
    {
        UndeliverableMailBarcodeScanningForm specificForm =
            (form instanceof UndeliverableMailBarcodeScanningForm) ?
                (UndeliverableMailBarcodeScanningForm)form : null;
        if (specificForm == null)
        {
            throw new ServiceConfigurationException(
                "UndeliverableMailBarcodeScanningForm not properly configured.");
        }
        return specificForm;
    }

    /**
     * Checks to ensure the passed in ActionForm is not null and of the correct type -
     * UndeliverableMailSearchForm.
     *
     * @param form The struts form to check
     *
     * @return The passed in form type-casted to our screen specific form
     * @throws gov.va.med.fw.service.ServiceConfigurationException if the form is null or of an
     * incorrect type.
     */
    protected UndeliverableMailSearchForm getUndeliverableMailSearchForm(ActionForm form)
        throws ServiceConfigurationException
    {
        UndeliverableMailSearchForm specificForm = (form instanceof UndeliverableMailSearchForm) ?
            (UndeliverableMailSearchForm)form : null;
        if (specificForm == null)
        {
            throw new ServiceConfigurationException(
                "UndeliverableMailSearchForm not properly configured.");
        }
        return specificForm;
    }

    /**
     * Checks to ensure the passed in ActionForm is not null and of the correct type -
     * UndeliverableMailEditPermAddressForm.
     *
     * @param form The struts form to check
     *
     * @return The passed in form type-casted to our screen specific form
     * @throws gov.va.med.fw.service.ServiceConfigurationException if the form is null or of an
     * incorrect type.
     */
    protected UndeliverableMailEditPermAddressForm getUndeliverableMailEditPermAddressForm(
        ActionForm form)
        throws ServiceConfigurationException
    {
        UndeliverableMailEditPermAddressForm specificForm =
            (form instanceof UndeliverableMailEditPermAddressForm) ?
                (UndeliverableMailEditPermAddressForm)form : null;
        if (specificForm == null)
        {
            throw new ServiceConfigurationException(
                "UndeliverableMailEditPermAddressForm not properly configured.");
        }
        return specificForm;
    }

    /**
     * Nulls out certain address form search fields that don't apply if a Country is set.
     *
     * @param form The form
     */
    protected void removeUnapplicableAddressFields(UndeliverableMailSearchForm form)
    {
        // Null out the Country in case it is the empty string
        if (StringUtils.isEmpty(form.getCountry()))
        {
            form.setCountry(null);
        }

        // Blank out appropriate US and non-US fields when applicable
        if (Country.isUSAddress(form.getCountry()))
        {
            form.setProvince(null);
            form.setPostalCode(null);
        }
        else
        {
            form.setCounty(null);
            form.setState(null);
            form.setZipCode(null);
            form.setZipPlus4(null);
        }
    }
}