package gov.va.med.esr.ui.comms.action;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.DeliveryPreferenceEmail;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceSourceOfChange;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.util.StringUtils;

public class DeliveryPreferencesConversionService extends UIConversionServiceImpl {

	private static DeliveryPreferenceSourceOfChange SOURCE_CHANGE = null;
    /**
     * Default constructor.
     */
    public DeliveryPreferencesConversionService()
    {
    }

    /**
     * Converts between an DeliveryPreferences object and the AddressForm.
     *
     * @param source the source object
     * @param target the target object
     *
     * @throws gov.va.med.fw.conversion.ConversionServiceException if any errors were encountered during the
     * conversion.
     */
    protected void convertBean(Object source, Object target) throws ConversionServiceException
    {
    	DeliveryPreference dp = null;
        DeliveryPreferencesForm form = null;

        if (source instanceof DeliveryPreference)
        {
            dp = (DeliveryPreference)source;
            if (target instanceof DeliveryPreferencesForm)
            {
                form = (DeliveryPreferencesForm)target;
            }
            else
            {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() +
                    " and must be of type DeliveryPreferencesForm.");
            }
            // Convert from the Person to the form
            convertDeliveryPreferenceToForm(dp, form);       	
        }
        else
        {
            if (source instanceof DeliveryPreferencesForm)
            {
                form = (DeliveryPreferencesForm)source;
                if (target instanceof DeliveryPreference)
                {
                    dp = (DeliveryPreference)target;
                }
                else
                {
                    throw new ConversionServiceException("Target object is of type " + target.getClass().getName() +
                        " and must be of type Person.");
                }

                // Convert from the Form to Person
                convertFormToDeliveryPreference(form, dp);
            }
            else
            {
                throw new ConversionServiceException("Source object is of type " + target.getClass().getName() +
                    " and must be of type Person or DeliveryPreferencesForm.");
            }
        }
    }

    /**
     * Converts the Address data onto the form.
     *
     * @param address The address
     * @param form The form
     */
    protected void convertDeliveryPreferenceToForm(DeliveryPreference dp, DeliveryPreferencesForm form)
    {
        if (dp != null)
        {
        	form.setChangeDate(DateUtils.format(dp.getChangeDate(), null));
        	form.setDeliveryPreference(dp.getDeliveryPreferenceType().getCode());
        	DeliveryPreferenceEmail dpEmail = dp.getEmail();
        	if (dpEmail != null)
        	{
        		form.setEmailAddress(dpEmail.getAddress());
        		form.setEmailType(dpEmail.getType().getCode());
        	}
        	form.setSourceOfChange(dp.getSourceOfChange().getCode());
        	form.setUserName(dp.getModifiedBy().getName());
        }
    }

    /**
     * Converts the address form data onto the address object.
     *
     * @param form The form
     * @param address The address
     */
    protected void convertFormToDeliveryPreference(DeliveryPreferencesForm form, DeliveryPreference dp)
    	throws ConversionServiceException
    {	
    	try {
    		if (SOURCE_CHANGE == null)
    		{
    			SOURCE_CHANGE = (DeliveryPreferenceSourceOfChange)getLookupCacheService()
                .getByCodeFromCache(DeliveryPreferenceSourceOfChange.class, DeliveryPreferenceSourceOfChange.CODE_HEC.getCode());
    		}
    		
//        	Note: In common service, it requires the inputs of the Source of Change and last update date.
//        	- Source of change = HEC.
//        	- Last update date = system time.    		
    		dp.setSourceOfChange(SOURCE_CHANGE);
    		dp.setChangeDate(new Date());
    		
    		dp.setDeliveryPreferenceType(StringUtils.isBlank(form.getDeliveryPreference()) ? null : (DeliveryPreferenceType)getLookupCacheService()
                    .getByCodeFromCache(DeliveryPreferenceType.class, form.getDeliveryPreference()));
    		
    		if (StringUtils.isBlank(form.getEmailAddress()))
    		{
    			dp.setEmail(null); //wipe out email
    		} else
    		{		
    			DeliveryPreferenceEmail email = dp.getEmail();
    		
				if (email == null)	
				{
					email = new DeliveryPreferenceEmail(); //new email
					email.setDeliveryPreference(dp);
				}
				
				email.setAddress(form.getEmailAddress());
				email.setType((EmailType)getLookupCacheService()
	                .getByCodeFromCache(EmailType.class, form.getEmailType()));
	
				dp.setEmail(email);
    		}
    	}
        catch (Exception ex)
        {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
 
    }
}