/********************************************************************
 * Copyright � 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.comms.action;

// Java classes
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

//import org.apache.commons.lang.StringUtils;


import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.web.context.WebApplicationContext;



import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.security.EncryptionServiceException;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.security.UIEncryptionService;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.comms.GeocodeTransmit;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.Waittime;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.CommonJspUtils;
import gov.va.med.esr.service.external.VHICCardInfo;
import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;
import gov.va.med.esr.ui.message.action.MessageConstants;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.ui.struts.ValueListActionUtils;

/**
 * @author DNS   RAMACP
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CommsLogForm extends AbstractForm {
    private static final long serialVersionUID = -7677484911378149017L;

    private String selectedCommsLogId;
	private String newComment;
	private List failedConditions;
	private List taxYearList;
	private String taxYearSel;
	private String selectedFormNumber;
	private String selectedFormName;
	private CommsLogEntry selectedCommsLog;
	private HandBookMailQueue selectedHandbookLog;
	private Correspondence selectedCorrespondence;
	private VHICCardInfo vhicCardInfo;
	private String selectedCaseId;
	private boolean remailInd;
	private Address address;
	private boolean coveredJan;
	private boolean coveredFeb;
	private boolean coveredMar;
	private boolean coveredApr;
	private boolean coveredMay;
	private boolean coveredJun;
	private boolean coveredJul;
	private boolean coveredAug;
	private boolean coveredSep;
	private boolean coveredOct;
	private boolean coveredNov;
	private boolean coveredDec;

	private boolean cancelMailing = false;
	private boolean override = false;
	private boolean returnedByPostOffice = false;
	private boolean requiredFieldMissingInd = false;

	
	// CR 13726
	private Person person;
	private String vetChoiceStat;
	private GeocodeTransmit geocodeTransmit;
	private Waittime waittime;
	private String homePhone;
	private String workPhone;
	private String cellPhone;
	private String tempPhone;
	private String serviceConnectionAward;
	private String enrollmentDetermination;
	private String effectiveDate;
	private String combatVeteranStatus;
	private String specialAuthority;
	private String geocodeDate;
	private List waittimeList;


	// 3.6 CCR 10960
	private List handbookMailValidationErrors = null;

	public static final String PATTERN_REGEX = "[\\s\\w=.]*"; // #########

	// 3.6 CCR 10956
	private String rawData = "";

    /**
     * @see gov.vha.fw.ui.struts.AbstractForm#createValueObject()
     */
    protected AbstractEntity createValueObject() {
       return new Person();
    }

	public String getVetChoiceStat() {
		return vetChoiceStat;
	}

	public void setVetChoiceStat(String vetChoiceStat) {
		this.vetChoiceStat = vetChoiceStat;
	}

	public GeocodeTransmit getGeocodeTransmit() {
		return geocodeTransmit;
	}

	public void setGeocodeTransmit(GeocodeTransmit geocodeTransmit) {
		this.geocodeTransmit = geocodeTransmit;
	}

	public Waittime getWaittime() {
		return waittime;
	}

	public void setWaittime(Waittime waittime) {
		this.waittime = waittime;
	}

	public String getHomePhone() {
		return homePhone;
	}

	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}

	public String getWorkPhone() {
		return workPhone;
	}

	public void setWorkPhone(String workPhone) {
		this.workPhone = workPhone;
	}

	public String getCellPhone() {
		return cellPhone;
	}

	public void setCellPhone(String cellPhone) {
		this.cellPhone = cellPhone;
	}

	public String getTempPhone() {
		return tempPhone;
	}

	public void setTempPhone(String tempPhone) {
		this.tempPhone = tempPhone;
	}

	public String getServiceConnectionAward() {
		return serviceConnectionAward;
	}

	public void setServiceConnectionAward(String serviceConnectionAward) {
		this.serviceConnectionAward = serviceConnectionAward;
	}

	public String getEnrollmentDetermination() {
		return enrollmentDetermination;
	}

	public void setEnrollmentDetermination(String enrollmentDetermination) {
		this.enrollmentDetermination = enrollmentDetermination;
	}

	public String getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(String effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getCombatVeteranStatus() {
		return combatVeteranStatus;
	}

	public void setCombatVeteranStatus(String combatVeteranStatus) {
		this.combatVeteranStatus = combatVeteranStatus;
	}

	public String getSpecialAuthority() {
		return specialAuthority;
	}

	public void setSpecialAuthority(String specialAuthority) {
		this.specialAuthority = specialAuthority;
	}

	public String getGeocodeDate() {
		return geocodeDate;
	}

	public void setGeocodeDate(String geocodeDate) {
		this.geocodeDate = geocodeDate;
	}


	public List getWaittimeList() {
		return waittimeList;
	}

	public void setWaittimeList(List waittimeList) {
		this.waittimeList = waittimeList;
	}



	// 3.6 CCR 10956
    /**
     *
     * @return the raw data string to display to the user
     */
	public String getRawData() {
		return rawData;
	}

	// 3.6 CCR 10956
	/**
	 *
	 * @param rawData the raw data string to display to the user
	 */
	public void setRawData(String rawData) {
		this.rawData = rawData;
	}

	public List getTaxYearList() {
		return taxYearList;
	}

	public void setTaxYearList(List taxYearList) {
		this.taxYearList = taxYearList;
	}


	public String getTaxYearSel() {
		return taxYearSel;
	}

	public void setTaxYearSel(String taxYearSel) {
		this.taxYearSel = taxYearSel;
	}

	public boolean isCoveredJan() {
		return coveredJan;
	}

	public void setCoveredJan(boolean coveredJan) {
		this.coveredJan = coveredJan;
	}

	/**
	 * @return Returns
	the failedConditions.
	 */
	public List getFailedConditions() {
		return failedConditions;
	}
	/**
	 * @param failedConditions The failedConditions to set.
	 */
	public void setFailedConditions(List failedConditions) {
		this.failedConditions = failedConditions;
	}
	/**
	 * @return Returns the selectedCommsLog.
	 */
	public CommsLogEntry getSelectedCommsLog() {
		return selectedCommsLog;
	}
	/**
	 * @param selectedCommsLog The selectedCommsLog to set.
	 */
	public void setSelectedCommsLog(CommsLogEntry selectedCommsLog) {
		this.selectedCommsLog = selectedCommsLog;
		this.selectedFormNumber = selectedCommsLog != null ? selectedCommsLog.getFormNumber() : null;
		this.selectedFormName = selectedCommsLog != null ? selectedCommsLog.getTemplateName() : null;
	}

	/**
	 * @return Returns the selectedHandbookLog.
	 */
	public HandBookMailQueue getSelectedHandbookLog() {
		return selectedHandbookLog;
	}
	/**
	 * @param selectedCommsLog The selectedCommsLog to set.
	 */
	public void setSelectedHandbookLog(HandBookMailQueue selectedHandbookLog) {
		this.selectedHandbookLog = selectedHandbookLog;
		this.selectedFormNumber = selectedHandbookLog != null ? selectedHandbookLog.getFormNumber() : null;
		this.selectedFormName = selectedHandbookLog != null ? selectedHandbookLog.getTemplateName() : null;
	}



	/**
	 * @return Returns the selectedCommsLogId.
	 */
	public String getSelectedCommsLogId() {
		return selectedCommsLogId;
	}
	/**
	 * @param selectedCommsLogId The selectedCommsLogId to set.
	 */
	public void setSelectedCommsLogId(String selectedCommsLogId) {
		this.selectedCommsLogId = selectedCommsLogId;
	}
	/**
	 * @return Returns the selectedFormNumber.
	 */
	public String getSelectedFormNumber() {
		return selectedFormNumber;
	}
	/**
	 * @param selectedFormNumber The selectedFormNumber to set.
	 */
	public void setSelectedFormNumber(String selectedFormNumber) {
		this.selectedFormNumber = selectedFormNumber;
	}
	/**
	 * @return Returns the cancelMailing.
	 */
	public boolean isCancelMailing() {
		return cancelMailing;
	}
	/**
	 * @param cancelMailing The cancelMailing to set.
	 */
	public void setCancelMailing(boolean cancelMailing) {
		this.cancelMailing = cancelMailing;
	}
	/**
	 * @return Returns the override.
	 */
	public boolean isOverride() {
		return override;
	}
	/**
	 * @param override The override to set.
	 */
	public void setOverride(boolean override) {
		this.override = override;
	}
	/**
	 * @return Returns the returnedByPostOffice.
	 */
	public boolean isReturnedByPostOffice() {
		return returnedByPostOffice;
	}
	/**
	 * @param returnedByPostOffice The returnedByPostOffice to set.
	 */
	public void setReturnedByPostOffice(boolean returnedByPostOffice) {
		this.returnedByPostOffice = returnedByPostOffice;
	}
	/**
	 * @return Returns the newComment.
	 */
	public String getNewComment() {
		return newComment;
	}

	public String getFomattedActionComment() {
		if(selectedCommsLog != null && StringUtils.isNotBlank(selectedCommsLog.getActionComment())) {
			return selectedCommsLog.getActionComment().replaceAll(CommonJspUtils.escapeRegExprChars(System.getProperty("line.separator")), "<br/>");
		}
		return null;
	}

	public String getFomattedHandbookActionComment() {
		if(selectedHandbookLog != null && StringUtils.isNotBlank(selectedHandbookLog.getActionComment())) {
			return selectedHandbookLog.getActionComment().replaceAll(CommonJspUtils.escapeRegExprChars(System.getProperty("line.separator")), "<br/>");
		}
		return null;
	}

	/**
	 * @param newComment The newComment to set.
	 */
	public void setNewComment(String newComment) {
		this.newComment = newComment;
	}
	/**
	 * @return Returns the address.
	 */
	public Address getAddress() {
		return address;
	}
	/**
	 * @param address The address to set.
	 */
	public void setAddress(Address address) {
		this.address = address;
	}
	/**
	 * @return Returns the remailInd.
	 */
	public boolean isRemailInd() {
		return remailInd;
	}
	/**
	 * @param remailInd The remailInd to set.
	 */
	public void setRemailInd(boolean remailInd) {
		this.remailInd = remailInd;
	}
	/**
	 * @return Returns the selectedCaseId.
	 */
	public String getSelectedCaseId() {
		return selectedCaseId;
	}
	/**
	 * @param selectedCaseId The selectedCaseId to set.
	 */
	public void setSelectedCaseId(String selectedCaseId) {
		this.selectedCaseId = selectedCaseId;
	}
	/**
	 * @return Returns the requiredFieldMissingInd.
	 */
	public boolean getRequiredFieldMissingInd() {
		return requiredFieldMissingInd;
	}
	/**
	 * @param requiredFieldMissingInd The requiredFieldMissingInd to set.
	 */
	public void setRequiredFieldMissingInd(boolean requiredFieldMissingInd) {
		this.requiredFieldMissingInd = requiredFieldMissingInd;
	}

	/**
	 * @return Returns the selectedFormName.
	 */
	public String getSelectedFormName() {
		return selectedFormName;
	}

	/**
	 * @param selectedFormName The selectedFormName to set.
	 */
	public void setSelectedFormName(String selectedFormName) {
		this.selectedFormName = selectedFormName;
	}

	public boolean getAllowHandbookMail() {
		return (handbookMailValidationErrors == null || handbookMailValidationErrors.isEmpty());
	}

	public List getHandbookMailValidationErrors() {
		return handbookMailValidationErrors;
	}

	public void setHandbookMailValidationErrors(List handbookMailValidationErrors) {
		this.handbookMailValidationErrors = handbookMailValidationErrors;
	}

	public String getFormattedHandbookMailValidationErrors () {
		String errors = "The Handbook cannot be mailed at this time:\\n\\n";
		for (int idx = 0; idx <= handbookMailValidationErrors.size()-1; idx++) {
			errors += "\\n" + (String)handbookMailValidationErrors.get(idx);
		}
		return errors;
	}

	public VHICCardInfo getVhicCardInfo() {
		return vhicCardInfo;
	}

	public void setVhicCardInfo(VHICCardInfo vhicCardInfo) {
		this.vhicCardInfo = vhicCardInfo;
	}



	public boolean isCoveredFeb() {
		return coveredFeb;
	}



	public void setCoveredFeb(boolean coveredFeb) {
		this.coveredFeb = coveredFeb;
	}



	public boolean isCoveredMar() {
		return coveredMar;
	}



	public void setCoveredMar(boolean coveredMar) {
		this.coveredMar = coveredMar;
	}



	public boolean isCoveredApr() {
		return coveredApr;
	}



	public void setCoveredApr(boolean coveredApr) {
		this.coveredApr = coveredApr;
	}



	public boolean isCoveredMay() {
		return coveredMay;
	}



	public void setCoveredMay(boolean coveredMay) {
		this.coveredMay = coveredMay;
	}



	public boolean isCoveredJun() {
		return coveredJun;
	}



	public void setCoveredJun(boolean coveredJun) {
		this.coveredJun = coveredJun;
	}



	public boolean isCoveredJul() {
		return coveredJul;
	}



	public void setCoveredJul(boolean coveredJul) {
		this.coveredJul = coveredJul;
	}



	public boolean isCoveredAug() {
		return coveredAug;
	}



	public void setCoveredAug(boolean coveredAug) {
		this.coveredAug = coveredAug;
	}



	public boolean isCoveredSep() {
		return coveredSep;
	}



	public void setCoveredSep(boolean coveredSep) {
		this.coveredSep = coveredSep;
	}



	public boolean isCoveredOct() {
		return coveredOct;
	}



	public void setCoveredOct(boolean coveredOct) {
		this.coveredOct = coveredOct;
	}



	public boolean isCoveredNov() {
		return coveredNov;
	}



	public void setCoveredNov(boolean coveredNov) {
		this.coveredNov = coveredNov;
	}



	public boolean isCoveredDec() {
		return coveredDec;
	}



	public void setCoveredDec(boolean coveredDec) {
		this.coveredDec = coveredDec;
	}


	@Override
	public ActionMessages validateForm(ActionMapping mapping,
			HttpServletRequest request) {
		ActionMessages messages = new ActionMessages();
		Map<String, String[]> parameterMap = request.getParameterMap();
		for(Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
			String key = entry.getKey();
			String[] values = entry.getValue();
			if (!key.equals("OWASP_CSRFTOKEN") && !key.equals("org.apache.struts.taglib.html.TOKEN")) {
				if(key != null ) {
					if(StringUtils.validateEntry(key, PATTERN_REGEX)){
						if(StringUtils.contains(key, "--")){
							messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, key + " is invalid"));
						}
					}
					else{
						messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, key + " is invalid"));
					}
				}

				if(values != null) {
					for(int i = 0; i < values.length; i++) {
						String value = values[i];
						boolean validateValue = true;
						if(key.equals("encry")){
							validateValue = false;
						}
						if (value.startsWith("742-")) {
							validateValue = false;
						}
						if(validateValue){
							if(StringUtils.validateEntry(value, PATTERN_REGEX)){
								if(StringUtils.contains(value, "--")){
									messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, value + " is invalid"));
								}
							}
							else{
								messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, value + " is invalid"));
							}
						}
					}
				}
			}
		}

		return messages;
	}



	public Correspondence getSelectedCorrespondence() {
		return selectedCorrespondence;
	}



	public void setSelectedCorrespondence(Correspondence selectedCorrespondence) {
		this.selectedCorrespondence = selectedCorrespondence;
	}


}
