/**
 * Created 6/28/2016
 */
package gov.va.med.esr.ui.comms.action;

// Java classes
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.comms.CorrespondenceDocument;
import gov.va.med.esr.ui.common.action.DownloadAction;
import gov.va.med.fw.service.ServiceConfigurationException;

public class ACADisplayAction extends DownloadAction {
	protected transient Log logger = LogFactory.getLog(getClass());
	public ACADisplayAction() {
		super();
	}

	protected StreamInfo getStreamInfo(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		Correspondence corr =  this.getCorrespondenceService().getCorrespondenceWithHistory(new BigDecimal(request.getParameter("submissionId")));
		CorrespondenceDocument doc = corr.getCorrespondenceDocument();

		String contentType = "application/pdf";

		return new ByteStreamInfo(contentType, new ByteArrayInputStream(javax.xml.bind.DatatypeConverter.parseHexBinary(doc.getDocumentFile())));
	}


	public String displayACA(HttpServletRequest request) throws Exception {

		//handle the query parameters from overview page
		String docId= request.getParameter("submissionId");

		return null;
	}



	/**
	 * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
	 */
	public void afterPropertiesSet() {
		// Check for required components here
	}

	protected Map getKeyMethodMap() {
		Map map = new HashMap();
		map.put("title.ACA", "displayACA");
		return map;
	}

	protected CommsLogForm getCommsLogForm(ActionForm form)
			throws ServiceConfigurationException {
		CommsLogForm specificForm = (form instanceof CommsLogForm) ? (CommsLogForm) form
				: null;
		if (specificForm == null) {
			throw new ServiceConfigurationException(
					"CommsLogForm not properly configured.");
		}
		return specificForm;
	}
}