/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.service;

// Java classes
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.model.lookup.Lookup;

import java.util.Collection;
import java.util.List;
import java.util.Map;


/**
 * Interface for lookup cache service.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface LookupCacheService 
{
	//Spring bean id
	public static final String LOOKUP_CACHE_SERVICE = "lookupCacheService";
	
	/**
	 * Gets the look up collection from the cache(ServletContext). If not found calls the LookupService
	 * and converts the collection in to LabelValueBean and returns. It caches the lookup data obtained 
	 * from the LookupService.
	 * 
	 * @param request the request object
	 * @param className filly qualified name of the lookup class
	 * 
	 * @return collection of <code>LabelValueBean<code> objects.
	 * 
	 * @throws UnknownLookupTypeException
	 * @throws ClassNotFoundException
	 */
	public Collection getFromCache(String className)
	throws UnknownLookupTypeException,ClassNotFoundException;
	
	public Lookup getByCodeFromCache(String className, String code)
	throws UnknownLookupTypeException,ClassNotFoundException;
	
	public Lookup getByCodeFromCache(Class clazz, String code)
	throws UnknownLookupTypeException,ClassNotFoundException;	
	
	public List getZipCode(String className,String zipCode)
	throws UnknownLookupTypeException,ClassNotFoundException;
	
	public List getZipCode(Class clazz,String zipCode)
	throws UnknownLookupTypeException,ClassNotFoundException;
    
    public Map getVISNSiteMap() 
    throws UnknownLookupTypeException, ClassNotFoundException;
    
    public LookupService getLookupService();
    public void setLookupService(LookupService lookupService);
    
    public Map getParentSiteMap() throws UnknownLookupTypeException, ClassNotFoundException;
    
    public Map getVISNVAMCMap() throws UnknownLookupTypeException, ClassNotFoundException;
}
